/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
/*
 * MKSYM.C
 *
 * This program takes a map file from one of the various DOS linkers
 * and creates a GRDB symbol table file.
 *
 * it is best compiled in large model
 *
 * (tested with TLINK, VALX, and MICROSOFT LINK)
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct sym {
   struct sym *link ;
   char *name ;
   unsigned int seg ;
   unsigned int ofs ;
} *symptr ;
char infile[256],outfile[256] ;


void setext(char *buf, char *ext)
{
   char *p = strrchr(buf,'.') ;
   if (!p)
      strcat(buf,ext) ;
   else if (p[-1] == '.'|| p[1] == '\\')
      strcat(buf,ext) ;
}
void symInsert(struct sym *s)
{
   struct sym **p = &symptr ;
   while (*p && (*p)->seg <= s->seg)
     if ( (*p)->seg != s->seg || (*p)->ofs < s->ofs)
       p = &(*p)->link ;
     else
       break ;
   s->link = *p ;
   *p = s ;
}
void ReadSymbols(FILE *in)
{
   unsigned int seg,ofs ;
   char name[256] ;
   char line[256] ;
   struct sym *s ;
   fgets(line,256,in) ;
   while (!feof(in)) {
      line[0] = 0 ;
      fgets(line,256,in) ;
      if (sscanf(line," %X:%X %[a-zA-Z0-9_@$]",&seg,&ofs,name) != 3)
         return ;
      s = malloc(sizeof(struct sym)) ;
      if (!s) {
         fprintf(stderr,"out of memory") ;
         exit(1) ;
      }
      s->seg = seg ;
      s->ofs = ofs ;
      s->name = strdup(name) ;
      symInsert(s) ;
   }
}
void WriteSymbols(char *name)
{
   FILE *fil = fopen(name,"wb") ;
   struct sym *s = symptr ;
   fprintf(fil,"SY01") ;
   while (s) {
      fputc(1,fil) ;
      fputc(s->ofs,fil) ;
      fputc(s->ofs >> 8,fil) ;
      fputc(0,fil) ;
      fputc(0,fil) ;
      fputc(s->seg,fil) ;
      fputc(s->seg >> 8,fil) ;
      fputc(strlen(s->name),fil) ;
      fputs(s->name,fil) ;
//      printf("%X:%X \"%s\"\n",s->seg,s->ofs,s->name) ;
      s = s->link ;
   }
   fclose(fil) ;
}
int main(int argc, char **argv)
{
   FILE *fil ;
   if (argc < 2 || argc > 3) {
      fprintf(stderr,"usage:  mksym inputfile [outputfile]") ;
      exit(1) ;
   }
   strcpy(infile,argv[1]) ;
   strcpy(outfile,argv[1]) ;
   if (argc == 3)
      strcpy(outfile,argv[2]) ;

   setext(infile,".map") ;
   setext(outfile,".sym") ;

   fil = fopen(infile,"r") ;
   if (!fil) {
      fprintf(stderr,"Cannot open input file %s for read access",infile) ;
      exit(1) ;
   }
   while (!feof(fil)) {
      char line[256] ;
      line[0] = 0;
      fgets(line,256,fil) ;
      if (line[0]) {
         if (strstr(line,"Publics by Name")) {
            ReadSymbols(fil) ;
            break ;
         }
      }
   }
   fclose(fil) ;
   if (!symptr) {
      fprintf(stderr,"No public symbols found"); 
      exit(0) ;
   }
   WriteSymbols(outfile) ;
   return 0;

}