VERSION 5.00
Object = "{AC957AC8-A491-11CE-A69B-0000E8A490E7}#1.0#0"; "wdtvocx.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmTableData 
   BackColor       =   &H00FF8080&
   Caption         =   "SAP Data Retrieval Wizard - Step 5"
   ClientHeight    =   5595
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9885
   LinkTopic       =   "frmTableData"
   ScaleHeight     =   5595
   ScaleWidth      =   9885
   StartUpPosition =   3  'Windows Default
   Begin SAPTableView.SAPTableView grdTable 
      Height          =   2895
      Left            =   3120
      TabIndex        =   2
      Top             =   1800
      Width           =   6255
      _Version        =   3
      _ExtentX        =   11033
      _ExtentY        =   5106
      _StockProps     =   109
      ForeColor       =   -2147483634
      BackColor       =   16761024
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty CtrlVColsVCollFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty CtrlVRowsVCollFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      SelectMode      =   1
      EnableProtection=   -1  'True
      ShowColHeaders  =   0   'False
      FixedRows       =   2
      Events          =   0
      BackColor       =   16761024
   End
   Begin VB.CommandButton cmdStartOver 
      Caption         =   "Start &Over"
      Height          =   400
      Left            =   6840
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   400
      Left            =   8160
      TabIndex        =   15
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdPrevious 
      Caption         =   "&Previous"
      Height          =   400
      Left            =   4200
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "&Next"
      Enabled         =   0   'False
      Height          =   400
      Left            =   5520
      TabIndex        =   13
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdHelp 
      Caption         =   "&Help"
      Height          =   400
      Left            =   2040
      TabIndex        =   12
      Top             =   4920
      Width           =   1200
   End
   Begin MSComDlg.CommonDialog CommonDialog 
      Left            =   2400
      Top             =   3240
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DialogTitle     =   "Save As"
      Filter          =   "*.csv"
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "&Save Data"
      Height          =   400
      Left            =   8160
      TabIndex        =   1
      Top             =   840
      Width           =   1200
   End
   Begin VB.PictureBox picLogo 
      BackColor       =   &H80000014&
      BorderStyle     =   0  'None
      Height          =   5655
      Left            =   0
      ScaleHeight     =   5655
      ScaleWidth      =   1935
      TabIndex        =   0
      Top             =   0
      Width           =   1935
      Begin VB.PictureBox Picture1 
         BackColor       =   &H80000014&
         BorderStyle     =   0  'None
         Height          =   5655
         Left            =   0
         Picture         =   "frmTableData.frx":0000
         ScaleHeight     =   5655
         ScaleWidth      =   1935
         TabIndex        =   6
         TabStop         =   0   'False
         Top             =   0
         Width           =   1935
         Begin VB.Label lblStep5 
            BackColor       =   &H8000000E&
            Caption         =   "Step 5 - Finished!"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   495
            Left            =   120
            TabIndex        =   11
            Top             =   4800
            Width           =   1575
         End
         Begin VB.Label lblStep3 
            BackColor       =   &H8000000E&
            Caption         =   "Step 3 - Choose Columns to Display"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   975
            Left            =   120
            TabIndex        =   10
            Top             =   2880
            Width           =   1575
         End
         Begin VB.Label lblStep2 
            BackColor       =   &H8000000E&
            Caption         =   "Step 2 - Choose Table"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   495
            Left            =   120
            TabIndex        =   9
            Top             =   2280
            Width           =   1575
         End
         Begin VB.Label lblStep4 
            BackColor       =   &H8000000E&
            Caption         =   "Step 4 - Enter Additional Options"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   735
            Left            =   120
            TabIndex        =   8
            Top             =   3960
            Width           =   1575
         End
         Begin VB.Label lblStep1 
            BackColor       =   &H8000000E&
            Caption         =   "Step 1 - Introduction"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   495
            Left            =   120
            TabIndex        =   7
            Top             =   1680
            Width           =   1575
         End
      End
      Begin VB.Label lblStep 
         BackColor       =   &H8000000E&
         Caption         =   "Step 4 - Enter Additional Options"
         BeginProperty Font 
            Name            =   "Verdana"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2175
         Left            =   120
         TabIndex        =   5
         Top             =   1680
         Width           =   1575
      End
   End
   Begin VB.Label lblDescription 
      BackColor       =   &H00FF8080&
      Caption         =   "The data you requested is available below."
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   855
      Left            =   3240
      TabIndex        =   4
      Top             =   960
      Width           =   5415
   End
   Begin VB.Label lblTitle 
      Alignment       =   2  'Center
      BackColor       =   &H80000014&
      Caption         =   "Data Retrieval Wizard for SAP"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   1920
      TabIndex        =   3
      Top             =   0
      Width           =   7935
   End
End
Attribute VB_Name = "frmTableData"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdCopy_Click()
    grdTable.CopyToClipboard
    grdTable.ClearSelection
End Sub

Private Sub cmdFinish_Click()
    QuitApp
End Sub

Private Sub cmdExit_Click()
    QuitApp
End Sub

Private Sub cmdPrevious_Click()
    Me.Hide
    frmTableOptions.Show
End Sub

Private Sub cmdStartOver_Click()
    ResetValues Me
End Sub

Private Sub cmdSave_Click()
    SaveData
End Sub

Private Sub Form_Activate()
    Dim iRow As Integer
    Dim iIndex As Integer
    Dim iColumn As Integer
    Dim iResult As Integer
    Dim oRow As Object
    Dim oColumn As Object
    Dim sException As String
    Dim iPosition As Integer
    Dim iStart As Integer
    Dim iPrevIndex As Integer
    Dim iPrevRow As Integer

    SetTextConstants Me
    
    frmTableData.grdTable.RowCount = 0
    
    Me.cmdStartOver.SetFocus

    frmTableData.MousePointer = 11
    
'   Clear ALL rows from the oFields object
    oFields.Rows.RemoveAll
    
'   Set up values for oFields using the Grid Control
    For iIndex = 0 To frmTableColumns.lstColumns.ListCount - 1
        If frmTableColumns.lstColumns.Selected(iIndex) Then
            iRow = iRow + 1
            oFields.Rows.Add
            iPosition = InStr(1, frmTableColumns.lstColumns.List(iIndex), " ", 1)
            oFields.Value(iRow, "FIELDNAME") = Left(frmTableColumns.lstColumns.List(iIndex), iPosition - 1)
        End If
    Next

'   Clear all entries in Fields object (Internal Table)
    oOptions.Rows.RemoveAll
    
'   Set up values for oOPTIONS using text control
    iStart = 1
'   Remove the CR/LF combos from the text box
    Do
        iPosition = InStr(iStart, frmTableOptions.txtWhere, _
                    ChrW(13) & ChrW(10), vbBinaryCompare)
        
        If iPosition = 0 Then Exit Do
        
        frmTableOptions.txtWhere = Left(frmTableOptions.txtWhere, iPosition - 1) _
                                   & " " _
                                   & Right(frmTableOptions.txtWhere, Len(frmTableOptions.txtWhere) - iPosition - 1)
        iStart = iPosition
    Loop
    
'   Put 72 character chunks into oFields
    iRow = 0
    Do
        iRow = iRow + 1
        oOptions.Rows.Add
        oOptions.Value(iRow, "TEXT") = Left(frmTableOptions.txtWhere, 72)
        iPosition = Len(frmTableOptions.txtWhere) - 72
        If iPosition < 1 Then
            Exit Do
        End If
        frmTableOptions.txtWhere = Right(frmTableOptions.txtWhere, iPosition)
   Loop
    
'   Give message if there is a large number of cells being returned
    If iRowcount * oFields.RowCount > 10000 Then
        iResult = MsgBox("You have chosed a large amount of data to return.  This will take some time to retrieve the data.  Do you want to continue?", vbYesNo)
        If iResult = vbNo Then
            Me.Hide
            frmTableOptions.Show
            Exit Sub
        End If
    End If
   
   cSap.RFC_READ_TABLE sTableName, _
                       "", _
                       oFields, _
                       , _
                       iRowskips, _
                       iRowcount, _
                       oOptions, _
                       oData
    
'********************************************
    grdTable.ColumnCount = oFields.RowCount
    grdTable.RowCount = oData.RowCount + 2

'   Fill headers
    For Each oColumn In oFields.Rows
        iColumn = iColumn + 1
        grdTable.Value(1, iColumn) = oFields.Value(iColumn, "FIELDNAME")
        grdTable.Value(2, iColumn) = oFields.Value(iColumn, "FIELDTEXT")
        
'       Set Header Cells format
        grdTable.Cell(1, iColumn).Font.Bold = True
        grdTable.Cell(2, iColumn).Font.Bold = True
    Next oColumn

'   Fill values
    iRow = 2
    For Each oRow In oData.Rows
        iRow = iRow + 1
        For iColumn = 1 To oFields.RowCount
            grdTable.Value(iRow, iColumn) = Mid(oRow("WA"), oFields(iColumn, "OFFSET") + 1, oFields(iColumn, "LENGTH"))
        Next
    Next oRow
    
'   Set each column's size
    grdTable.ColumnAutoWidth 1, oFields.RowCount
    
    frmTableData.MousePointer = 0

End Sub

Private Sub Form_Load()
    CentreForm Me
End Sub

Private Sub cmdHelp_Click()
    ShowHelp Me.hwnd
End Sub

Private Sub SaveData()
    Dim sFilename As String
    Dim vLine As Variant
    Dim iRow As Integer
    Dim iColumn As Integer
    Dim cSeparator As String
    Dim cItem As String
        
    sFilename = "c:\temp\" & sTableName & ".txt"
    
    CommonDialog.FileName = sFilename
    CommonDialog.Filter = "Tab Delimited (*.txt)|*.txt|DIF Format (*.dif)|*.dif|Comma Delimited (*.csv)|*.csv"
    CommonDialog.ShowSave
    
    sFilename = CommonDialog.FileName
        

    On Error GoTo FileError                     ' Handler File Errors
    
    Open sFilename For Output Access Write As #1

    Select Case CommonDialog.FilterIndex
        ' TAB or COMMA separated files
        Case 1, 3
            If CommonDialog.FilterIndex = 1 Then
                cSeparator = ChrW(9)    ' TAB Char
            Else
                cSeparator = ","        ' Comma Char
            End If
            
            For iRow = 1 To grdTable.RowCount
                vLine = Null
                For iColumn = 1 To grdTable.ColumnCount
                    If iColumn > 1 Then
                        vLine = vLine & cSeparator
                    End If
        
        '          If the cell is a char, put the value in double quotes
                    Select Case oFields.Value(iColumn, "TYPE")
                        Case "C", "N", "V"
                            vLine = vLine & ChrW(34) & Trim(grdTable.Value(iRow, iColumn)) & ChrW(34)
                        Case Else
                            vLine = vLine & grdTable.Value(iRow, iColumn)
                    End Select
                Next
                Print #1, vLine
            Next
        Case 2
'       Save as a DIF file
            Print #1, "Table"               ' Topic
            Print #1, "0,1"                 ' Value
            Print #1, "Data Wizard for SAP"     ' Title
            
            Print #1, "VECTORS"             ' Topic (number of rows)
            cItem = "0," & grdTable.RowCount
            Print #1, cItem
            cItem = ChrW(34) & ChrW(34)
            Print #1, cItem
            
            Print #1, "TUPLES"              ' Topic (number of columns)
            cItem = "0," & grdTable.ColumnCount
            Print #1, cItem
            cItem = ChrW(34) & ChrW(34)
            Print #1, cItem
            
            Print #1, "DATA"                ' Start of the data header
            Print #1, "0,0"
            cItem = ChrW(34) & ChrW(34)
            Print #1, cItem
            Print #1, "-1,0"
            
            For iRow = 1 To grdTable.RowCount
                Print #1, "BOT"             ' Start of row (TUPLE)
                For iColumn = 1 To grdTable.ColumnCount
                    If iRow < 3 Then ' Rows 1 and 2 are Header Rows
                        Print #1, "1,0"
                        cItem = ChrW(34) & Trim(grdTable.Value(iRow, iColumn)) & ChrW(34)
                        Print #1, cItem
                    Else
                        Select Case oFields.Value(iColumn, "TYPE")
                            Case "C", "N", "V", "D", "S", "T", "X"
                                Print #1, "1,0"
                                cItem = ChrW(34) & Trim(grdTable.Value(iRow, iColumn)) & ChrW(34)
                                Print #1, cItem
                            Case Else
                                Print #1, "0,0"
                                Print #1, Trim(grdTable.Value(iRow, iColumn))
                        End Select
                    End If
                Next
                Print #1, "-1,0"
            Next
            
            Print #1, "EOD"
    
    End Select
    
    Close #1
    Exit Sub
FileError:
    MsgBox "File not saved.  Error returned is " & Err.Description

End Sub

