VERSION 5.00
Begin VB.Form frmTableColumns 
   BackColor       =   &H00FF8080&
   Caption         =   "SAP Data Retrieval Wizard - Step 3"
   ClientHeight    =   5595
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   9885
   ForeColor       =   &H8000000E&
   LinkTopic       =   "frmTableColumns"
   ScaleHeight     =   5595
   ScaleWidth      =   9885
   StartUpPosition =   3  'Windows Default
   Visible         =   0   'False
   Begin VB.CommandButton cmdStartOver 
      Caption         =   "Start &Over"
      Height          =   400
      Left            =   6960
      TabIndex        =   19
      TabStop         =   0   'False
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   400
      Left            =   8280
      TabIndex        =   18
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdPrevious 
      Caption         =   "&Previous"
      Height          =   400
      Left            =   4320
      TabIndex        =   17
      TabStop         =   0   'False
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdNext 
      Caption         =   "&Next"
      Height          =   400
      Left            =   5640
      TabIndex        =   16
      Top             =   4920
      Width           =   1200
   End
   Begin VB.TextBox txtInfo 
      Appearance      =   0  'Flat
      BackColor       =   &H00FF8080&
      BorderStyle     =   0  'None
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   525
      Left            =   4320
      MultiLine       =   -1  'True
      TabIndex        =   15
      TabStop         =   0   'False
      Text            =   "frmTableColumns.frx":0000
      Top             =   4200
      Width           =   5175
   End
   Begin VB.TextBox txtWidth 
      BackColor       =   &H00FFC0C0&
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   3240
      TabIndex        =   14
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   4200
      Width           =   975
   End
   Begin VB.CommandButton cmdHelp 
      Caption         =   "&Help"
      Height          =   400
      Left            =   2040
      TabIndex        =   13
      Top             =   4920
      Width           =   1200
   End
   Begin VB.CommandButton cmdSelNone 
      Caption         =   "&Select None"
      Height          =   400
      Left            =   8160
      TabIndex        =   2
      Top             =   1320
      Width           =   1200
   End
   Begin VB.CommandButton cmdSelAll 
      Caption         =   "Select &All"
      Height          =   400
      Left            =   8160
      TabIndex        =   1
      Top             =   840
      Width           =   1200
   End
   Begin VB.ListBox lstColumns 
      BackColor       =   &H00FFC0C0&
      Height          =   2310
      ItemData        =   "frmTableColumns.frx":0002
      Left            =   3240
      List            =   "frmTableColumns.frx":0004
      Style           =   1  'Checkbox
      TabIndex        =   3
      Top             =   1800
      Width           =   6255
   End
   Begin VB.PictureBox picLogo 
      BackColor       =   &H80000014&
      BorderStyle     =   0  'None
      Height          =   5655
      Left            =   0
      ScaleHeight     =   5655
      ScaleWidth      =   1935
      TabIndex        =   0
      Top             =   0
      Width           =   1935
      Begin VB.PictureBox Picture1 
         BackColor       =   &H80000014&
         BorderStyle     =   0  'None
         Height          =   5655
         Left            =   0
         Picture         =   "frmTableColumns.frx":0006
         ScaleHeight     =   5655
         ScaleWidth      =   1935
         TabIndex        =   7
         TabStop         =   0   'False
         Top             =   0
         Width           =   1935
         Begin VB.Label lblStep5 
            BackColor       =   &H8000000E&
            Caption         =   "Step 5 - Finished!"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   495
            Left            =   120
            TabIndex        =   12
            Top             =   4800
            Width           =   1575
         End
         Begin VB.Label lblStep3 
            BackColor       =   &H8000000E&
            Caption         =   "Step 3 - Choose Columns to Display"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   700
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   975
            Left            =   120
            TabIndex        =   11
            Top             =   2880
            Width           =   1575
         End
         Begin VB.Label lblStep2 
            BackColor       =   &H8000000E&
            Caption         =   "Step 2 - Choose Table"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   495
            Left            =   120
            TabIndex        =   10
            Top             =   2280
            Width           =   1575
         End
         Begin VB.Label lblStep4 
            BackColor       =   &H8000000E&
            Caption         =   "Step 4 - Enter Additional Options"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   735
            Left            =   120
            TabIndex        =   9
            Top             =   3960
            Width           =   1575
         End
         Begin VB.Label lblStep1 
            BackColor       =   &H8000000E&
            Caption         =   "Step 1 - Introduction"
            BeginProperty Font 
               Name            =   "Verdana"
               Size            =   9.75
               Charset         =   0
               Weight          =   400
               Underline       =   0   'False
               Italic          =   0   'False
               Strikethrough   =   0   'False
            EndProperty
            Height          =   495
            Left            =   120
            TabIndex        =   8
            Top             =   1680
            Width           =   1575
         End
      End
      Begin VB.Label lblStep 
         BackColor       =   &H8000000E&
         Caption         =   "Step 3 - Choose Columns"
         BeginProperty Font 
            Name            =   "Verdana"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   2175
         Left            =   120
         TabIndex        =   6
         Top             =   1680
         Width           =   1575
      End
   End
   Begin VB.Label lblDescription 
      BackColor       =   &H00FF8080&
      Caption         =   "Select the fields that you want to display."
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   855
      Left            =   3240
      TabIndex        =   5
      Top             =   960
      Width           =   5415
   End
   Begin VB.Label lblTitle 
      Alignment       =   2  'Center
      BackColor       =   &H80000014&
      Caption         =   "SAP Data Retrieval Wizard"
      BeginProperty Font 
         Name            =   "Verdana"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   1920
      TabIndex        =   4
      Top             =   0
      Width           =   7935
   End
End
Attribute VB_Name = "frmTableColumns"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdExit_Click()
QuitApp
End Sub

Private Sub cmdHelp_Click()
    ShowHelp Me.hwnd
End Sub

Private Sub cmdPrevious_Click()
'    SaveFields
    Me.Hide
    frmTableName.Show
End Sub
Private Sub cmdNext_Click()
'   Check width of data to be returned
    If txtWidth > 510 Then
        MsgBox "Too many columns selected.  Total in the Red box must be less than 510.", vbOKOnly
        Exit Sub
    End If
    
'   SaveFields
    Me.Hide
    frmTableOptions.Show
End Sub

Private Sub cmdSelAll_Click()
    Dim iIndex As Integer
    For iIndex = 0 To frmTableColumns.lstColumns.ListCount - 1
        If Not frmTableColumns.lstColumns.Selected(iIndex) Then
            frmTableColumns.lstColumns.Selected(iIndex) = True
        End If
    Next
End Sub

Private Sub cmdSelNone_Click()
    Dim iIndex As Integer
    For iIndex = 0 To frmTableColumns.lstColumns.ListCount - 1
        If frmTableColumns.lstColumns.Selected(iIndex) Then
            frmTableColumns.lstColumns.Selected(iIndex) = False
        End If
    Next

End Sub

Private Sub cmdStartOver_Click()
    ResetValues Me
End Sub

Private Sub Form_Load()
    CentreForm Me
End Sub

Private Sub Form_Activate()
    Dim oFunc As Object
    Dim oRow As Object
    Dim oItem As Object
    Dim iIndex As Integer
    Dim lWidth As Long
    
    SetTextConstants Me
    
    txtWidth = 0
    txtInfo = ""
    
    Me.cmdNext.SetFocus
    
'   Reset lstColumns
    lstColumns.Clear
        
    frmTableColumns.MousePointer = 11

'   Pass the oOptions and oData objects here even though they are not used.
'   This allows the objects to be manipulated later
    cSap.RFC_READ_TABLE sTableName, _
                        "X", _
                        oFields, _
                        , _
                        , _
                        , _
                        oOptions, _
                        oData
    
    For Each oRow In oFields.Rows
        lWidth = lWidth + oRow("LENGTH")
        lstColumns.AddItem oRow("FIELDNAME") & _
                           " - " & _
                           oRow("FIELDTEXT") & _
                           " (" & _
                           Val(oRow("LENGTH")) & _
                           " characters)"
        cmdSelAll_Click
    Next
    
    txtWidth = lWidth
    
    lstColumns.ListIndex = 0
    
    frmTableColumns.MousePointer = 0
    
End Sub

Private Sub lstColumns_ItemCheck(Item As Integer)
    If lstColumns.Selected(Item) = True Then
        'The TABLES object starts counting at 1
        txtWidth = Val(txtWidth) + Val(oFields(Item + 1, "LENGTH"))
    Else
        txtWidth = Val(txtWidth) - Val(oFields(Item + 1, "LENGTH"))
    End If
    
    If Val(txtWidth) > 510 Then
        txtWidth.BackColor = Val("&H000000FF")
        txtWidth.ForeColor = Val("&H80000005")
        txtInfo.Text = "Too many columns chosen.  Deselect columns until number is less than 510"
    Else
        txtWidth.BackColor = Val("&H00FFC0C0")
        txtWidth.ForeColor = Val("&H80000008")
        txtInfo.Text = ""
    End If
End Sub

