VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "SAP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Compare Text
Option Explicit

Public oFunction As Object      ' SAP Functions
Public oConnection As Object    ' SAP oConnection
Private ConnectionObjectDestroyed As Boolean


' define storage area for property values

Private mUserId As String
Private mPassword As String
Private mSystem As String           ' SAP R/3 System name.
Private mApplicationServer As String  'Application Server of the R/3 System.
Private mSystemNumber As Long       ' System number of the R/3 System.
Private mMessageServer As String    ' Message Server of the R/3 system that is doing the load balancing.
Private mGroupName As String        ' Name of the group of R/3 Application Servers you want to oConnect to.
Private mClient As Long             ' Client in the R/3 System.
Private mLanguage As String         ' Language you use want to use in the R/3 System


' SAP Constants
Private tloRfcNotConnected As Integer   ' = 0  The r/3 oConnection is not established or
                                        ' logon was not called, or logoff has been called
Private tloRfcConnected As Integer      '= 1  the r/3 oConnection is established
Private tloRfcConnectCancel As Integer  '= 2  the r/3 oConnection is not not established due to the fact that
                                        ' user pressed the cancel button during logon.
Private tloRfcConnectParameterMissing As Integer  '= 4   the r/3 oConnection could not be established
                                        ' due to the fact a silent logon has taken
                                        ' place and not all the oConnection parameters were
                                        ' given
Private tloRfcConnectFailed As Integer    '= 8  The r/3 oConnection failed, call LastError to display
                                        'additional information

Function SapLogon(Optional bForceLogon As Boolean) As Boolean

    Dim bSilentLogon As Boolean
    
    ' if trying to log on and already logged on terminate the
    ' current session and re-logon
    
    If SAPConnected Then
        SAPLogoff
    End If
    
    Set oFunction = CreateObject("SAP.Functions")

    ' Log file. Set log level to 9 to see lots of internal
    ' information.
    oFunction.LogFileName = "wdtflog.txt"
    oFunction.LogLevel = 0


    Set oConnection = oFunction.Connection

    ' Enter you app-server and login info, or comment
    ' lines and fill in dialog.

    oConnection.Client = "001"
    oConnection.Language = "E"
    oConnection.TraceLevel = 0
    
    ' logon information is captured when the user first logs on
    ' for a re-logon attempt poplate the control with the saved values
    ' to prevent the logon window from appearing
       
    
    If Len(mPassword) > 0 And Not (bForceLogon) Then
        oConnection.User = mUserId
        oConnection.Password = mPassword
        oConnection.System = mSystem
        oConnection.ApplicationServer = mApplicationServer
        oConnection.SystemNumber = mSystemNumber
        oConnection.MessageServer = mMessageServer
        oConnection.GroupName = mGroupName
        oConnection.Client = mClient
        oConnection.Language = mLanguage
        
        bSilentLogon = True   ' logon to SAP without presenting the logon screen
    Else
        bSilentLogon = False
    End If
        
    ' invoke the SAP logon control
    If oConnection.Logon(0, bSilentLogon) <> True Then
        SapLogon = False
    Else
        ' confirm the SAP oConnection
        If oConnection.IsConnected = tloRfcConnected Then
            SapLogon = True
            
            ' save the logon information for future silent logon's
            mUserId = oConnection.User
            mPassword = oConnection.Password
            mSystem = oConnection.System
            mApplicationServer = oConnection.ApplicationServer
            mSystemNumber = oConnection.SystemNumber
            mMessageServer = oConnection.MessageServer
            mGroupName = oConnection.GroupName
            mClient = oConnection.Client
            mLanguage = oConnection.Language
        Else
            SapLogon = False
        End If

    End If

    ConnectionObjectDestroyed = False

    ' use the isoConnected property to deterime the status of the oConnection
End Function

Function SAPLogoff() As Boolean

' log off of SAP


    If SAPConnected Then  ' only logoff is actually oConnected
        oFunction.Connection.Logoff
        Set oConnection = Nothing
        Set oFunction = Nothing
        SAPLogoff = True
    Else
        SAPLogoff = True
    End If
    
    ConnectionObjectDestroyed = True
    
End Function

Sub RFC_READ_TABLE(mQuery_Table As String, _
                   mNo_Data As String, _
                   mFields As Object, _
                   Optional mDelimiter As String, _
                   Optional mRowSkips As Integer, _
                   Optional mRowCount As Integer, _
                   Optional mOptions As Object, _
                   Optional mData As Object)
    
    Dim result As Boolean
    Dim exception As Variant
                   
'   Logon to SAP
    cSap.SapLogon
    
    result = cSap.oFunction.RFC_READ_TABLE(exception, _
                                           QUERY_TABLE:=mQuery_Table, _
                                           NO_DATA:=mNo_Data, _
                                           FIELDS:=mFields, _
                                           DELIMITER:=mDelimiter, _
                                           ROWSKIPS:=mRowSkips, _
                                           RowCount:=mRowCount, _
                                           Options:=mOptions, _
                                           Data:=mData)
                                           
    If result <> True Then
        MsgBox exception
    End If
    
    cSap.SAPLogoff
    
End Sub
Property Get SAPConnected() As Boolean

    ' Determine if a oConnection to SAP has been destroyed (logged off


    If ConnectionObjectDestroyed Then
    
        SAPConnected = False
    Else
    
        SAPConnected = True
          
    End If

End Property

Private Sub Class_Initialize()
    
    ConnectionObjectDestroyed = True
    
    ' initialize constant values
    
    tloRfcNotConnected = 0
    tloRfcConnected = 1
    tloRfcConnectCancel = 2
    tloRfcConnectParameterMissing = 4
    tloRfcConnectFailed = 8

End Sub

Private Sub Class_Terminate()
    ' logoff of SAP
    SAPLogoff
End Sub

Property Get UserId() As String

    If Len(mUserId) = 0 Then
        mUserId = "Unknown"
    End If
    
    UserId = mUserId
    
End Property

Property Get SapSystem() As String

    If Len(SapSystem) > 0 Then
        SapSystem = mSystem
    End If
    
End Property

Property Get ApplicationServer() As String

    If Len(mApplicationServer) > 0 Then
        ApplicationServer = mApplicationServer
    End If
End Property

Property Get SystemNumber() As Long

    If Len(mSystemNumber) > 0 Then
        SystemNumber = mSystemNumber
    End If
End Property

Property Get MessageServer() As String

    If Len(mMessageServer) > 0 Then
        MessageServer = mMessageServer
    End If
End Property

Property Get GroupName() As String

    If Len(mGroupName) > 0 Then
        GroupName = mGroupName
    End If
End Property

Property Get Client() As Long

    If Len(mClient) > 0 Then
        Client = mClient
    End If
End Property

Property Get Language() As String
    If Len(mLanguage) > 0 Then
        Language = mLanguage
    End If
End Property
Property Get Password() As String
    If Len(mPassword) > 0 Then
        Password = mPassword
    End If
End Property

