Attribute VB_Name = "PublicVariables"
Option Explicit
Option Private Module

' Setup Windows API calls for reading/writing INI files
Declare Function WritePrivateProfileString Lib "kernel32" _
        Alias "WritePrivateProfileStringA" _
            (ByVal lpApplicationName As String, _
             ByVal lpKeyName As Any, _
             ByVal lpString As Any, _
             ByVal lpFileName As String) As Long

Declare Function GetPrivateProfileString Lib "kernel32" _
        Alias "GetPrivateProfileStringA" _
            (ByVal lpApplicationName As String, _
             ByVal lpKeyName As Any, _
             ByVal lpDefault As String, _
             ByVal lpReturnedString As String, _
             ByVal nSize As Long, _
             ByVal lpFileName As String) As Long

Declare Function OSWinHelp% Lib "user32" _
        Alias "WinHelpA" (ByVal hwnd&, _
                          ByVal HelpFile$, _
                          ByVal wCommand%, _
                          dwData As Any)

Dim lpApplicationName As String, _
    lpKeyName As String, _
    lpDefault As String, _
    lpReturnString As String, _
    lpFileName As String, _
    lpString As String

Dim nSize As Long, _
    Valid As Long, _
    Path, _
    Succ

' Global Variables
Public oFunc As Object
Public oSAPFunction  As Object

Public cSap As New SAP  ' global instance of the SAP class object

Public sTableName As String

'Values for the function RFC_READ_TABLE
Public oFields As Object
Public oData As Object
Public oOptions As Object
Public iRowcount As Integer
Public iRowskips As Integer
Public Const cAppTitle As String = "Data Wizard for SAP"
Public Const cStep1 As String = "Step 1 - Introduction"
Public Const cStep2 As String = "Step 2 - Choose Table"
Public Const cStep3 As String = "Step 3 - Choose Columns to Display"
Public Const cStep4 As String = "Step 4 - Enter Additional Options"
Public Const cStep5 As String = "Step 5 - Display Data"

Public Sub QuitApp()
    Dim fForm As Form
            
    SaveInitializationFile
    
    For Each fForm In Forms
        Unload fForm
    Next fForm
    
    cSap.SAPLogoff
    
    End
End Sub
Public Sub ShowHelp(WindowHandle)
    On Error Resume Next
    
    Dim nRet As Integer
    nRet = OSWinHelp(WindowHandle, App.HelpFile, HelpConstants.cdlHelpContents, 0)
End Sub
Public Sub CentreForm(fForm As Form)
    Dim ILeft As Integer
    Dim iTop As Integer
    
    ILeft = (Screen.Width - fForm.Width) / 2
    iTop = (Screen.Height - fForm.Height) / 2
    fForm.Move ILeft, iTop
End Sub

Public Sub SetTextConstants(fForm As Form)
    fForm.lblTitle.Caption = cAppTitle
    fForm.lblStep1.Caption = cStep1
    fForm.lblStep2.Caption = cStep2
    fForm.lblStep3.Caption = cStep3
    fForm.lblStep4.Caption = cStep4
    fForm.lblStep5.Caption = cStep5
End Sub
Public Sub ReadInitializationFile()
    
    On Error GoTo FileError
    
    lpApplicationName = "DataWizardForSAP"
    lpDefault = ""
    lpReturnString = Space(128)
    nSize = Len(lpReturnString)
    lpFileName = "c:\sdw.ini"
    
    lpKeyName = "TableName"
    Valid = GetPrivateProfileString(lpApplicationName, _
                                    lpKeyName, _
                                    lpDefault, _
                                    lpReturnString, _
                                    nSize, _
                                    lpFileName)
    sTableName = Left(lpReturnString, Valid)
    
    Exit Sub
    
FileError:
    Exit Sub
End Sub
Public Sub SaveInitializationFile()
    
    On Error GoTo FileError
    
    lpApplicationName = "DataWizardForSAP"
    lpFileName = "c:\sdw.ini"
    lpKeyName = "TableName"
    Valid = WritePrivateProfileString(lpApplicationName, _
                                    lpKeyName, _
                                    sTableName, _
                                    lpFileName)
    
    Exit Sub
    
FileError:
    MsgBox Err.Number & "-" & Err.Description
    Resume Next
End Sub


Public Sub ResetValues(oFormName As Form)
    oFormName.Hide
'   Clear objects
    Set oData = Nothing
    Set oFields = Nothing
    Set oOptions = Nothing
'   Clear Controls
    frmTableData.grdTable.RowCount = 0
    frmTableOptions.txtWhere = ""
    frmTableColumns.lstColumns = ""
    frmMain.Show
End Sub
