;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
; vcpi.asm
;
; Function: VCPI handler functions/ protected - v86 mode
;
	.386p
include segs.asi
include ems.asi
include vm86.asi
include vcpi.asi
include pic.asi

	public	vcpientry
seg386data	segment
	extrn	tGDT: dword, freelist : dword, freepages : dword
	extrn	PageTables : dword, pGDT : fword, pIDT : fword
	extrn	MapBase : dword, TOS: BYTE, zero : DWORD, firstfree : dword
	extrn	logdir : dword, maxpages : dword, zero : dword
vcpiused	dd	0000h
seg386data	ends
seg386	segment
	extrn	getmappos : proc
	assume	cs:dgroup, ds:dgroup
vcpitab	label	dword
	dd	dgroup:vcpi_00, dgroup:vcpi_01, dgroup:vcpi_02, dgroup:vcpi_03a, dgroup:vcpi_04a, dgroup:vcpi_05a, dgroup:vcpi_06
	dd	dgroup:vcpi_07, dgroup:vcpi_08, dgroup:vcpi_09, dgroup:vcpi_0a, dgroup:vcpi_0b, dgroup:vcpi_0c
;
; Main VCPI entry for v86 mode
;
vcpientry	proc
	movzx	eax,byte ptr [GFEAX]	; Get VCPI func
	cmp	al,MAXVCPIFUNC		; See if in range
	mov	ah,EMSC_UNDEFUNC	; Enddef func if not
	ja	short seterror		;
	call	cs:[eax*4 + vcpitab]	; Else dispatch it
seterror:
	mov	byte ptr [GFEAX + 1],ah	; Save return code
	ret				; Return to V86 handler
vcpientry	endp
;
; Protected mode entry
;
vcpi_protectedmode	proc	far
	cmp	ah,VCPI_FUNC       	; Must have the DE or we barf
	mov	ah,EMSC_UNDEFUNC	; Error if not
	jnz	short noprotmode	;
	cmp	al,0ch			; See if is rundown func
	jz	rundown			; yep- branch to rundown routine
	push	ebx			; Branch to routine for allowed funcs
	push	ecx			; Save regs first
	push	esi			;
	push	edi			;
	push	ds			;
	push	es			;
	push	fs			;
	push	eax			;
	push	cs			;
	pop	ax			;
	add	ax,8			; Switch to our data seg
	mov	ds,ax			;
	mov	es,ax			;
	add	ax,8			; Switch to our abs seg
	mov	fs,ax			;
	cmp	al,3			; 3 is ok
	mov	ebx,offset vcpi_03
	jz	short callfunc		;
	cmp	al,4			; 4 is ok
	mov	ebx,offset vcpi_04		;
	jz	short callfunc		;
	cmp	al,5			; 5 is ok
	mov	ebx,offset vcpi_05		;
	jnz	short error		;
callfunc:
	call	[ebx]			; Call the function
	jmp	short ok		; get out
error:
	mov	ah,EMSC_UNDEFSUBFUNC	; undef function
ok:
	pop	ebx			; Get old ax
	mov	bh,ah			; return code in ah
	mov	eax,ebx			;
	pop	fs			; Pop all other regs
	pop	es			;
	pop	ds			;
	pop	edi			;
	pop	esi			;
	pop	ecx			;
	pop	ebx			;
noprotmode:
	ret				; Return to caller
vcpi_protectedmode	endp
;
; Return VCPI version - 00
;
vcpi_00	proc
	mov	ax,VCPI_VERSION		; Version in BX
	mov	[GFEBX],ax		;
	sub	ah,ah
	ret
vcpi_00	endp
;
; Get protected mode interface - 01
;
vcpi_01	proc
	mov	eax,offset vcpi_protectedmode	; EBX = protected mode call func
	mov	[GFEBX],eax		;
	mov	eax,4096		; Using entire lower 4 MB
	mov	[GFEDI],ax		;
	GETFRAME GFESI, GFDS, edi	; Get GDT frame
	push	es			; Switch ES to abs segment
	push	fs
	pop	es
	mov	esi,offset tGDT		; Move code seg to new GDT
	add	esi,CS386 AND 0fff8h	;
	movsd                           ;
	movsd                           ;
	mov	esi,offset tGDT         ; Move data seg to new GDT
	add	esi,DS386 AND 0fff8h	;
	movsd				;
	movsd                           ;
	mov	esi,offset tGDT         ; Move abs seg to new GDT
	add	esi,DSABS AND 0fff8h	;
	movsd                           ;
	movsd                           ;
	GETFRAME GFEDI,GFDS,EDI         ; Get page table frame
	sub	eax,eax			; We map the whole page table linearly
	or	eax,7			; Can access as writable in user mode
	mov	ecx,1024		; 1024 entries
fillp:
	stosd				; Save mapping
	add	eax,4096		;
	loop fillp			;
	pop	es
	sub	ah,ah			; no errors
	ret

vcpi_01	endp
;
; Get phys address of highest memory frame - 02
;
vcpi_02	proc
	mov	eax,[firstfree]		; Get free pages
	mov	ebx,[maxpages]		; Add in offset for max pages
	shl	ebx,14			;
	add	eax,ebx			;
	sub	eax,4096		; Point to last page
	mov	[GFEDX],eax		;
	sub	ah,ah			; no errors
	ret
vcpi_02	endp
;
; Get free pages - 03
;
vcpi_03a	proc
	mov	edx,[maxpages]		; Get max pages, prot mode version
	shl	edx,2			; 4 4K pages / ems 16K page
	sub	ah,ah			; no errors
	ret
vcpi_03a	endp
;
vcpi_03	proc
	call	vcpi_03a			; Get max pages
	mov	[GFEDX],edx		; Return for V86
	ret				; ret
vcpi_03	endp
;
; Allocate a 4K page - 04
;
vcpi_04a	proc
	lea	eax,[vcpiused]		; Get the used list
	add	eax,[zero]
v04_chkpartial:
	mov	ecx,eax
	bt	dword ptr fs:[eax],VCPIB_USED ; See if end of list
	jnc	short v04_nomorepartial	; Go allocate another item if so
	mov	bx,fs:[eax]		; See if available partial page
	and	bx,VCPIB_MASK		;
	cmp	bx,VCPIB_MASK		;
	jnz	short v04_gotpartial	; Branch if so
	movzx	ebx,word ptr fs:[eax]	; Else follow link
	and	ebx, NOT VCPIB_MASK OR NOT VCPIB_USED ; Clear tag bits
	lea	eax,[ebx*2]		;
	add	eax,[logdir]            ; Link is in logdir
	jmp	short v04_chkpartial	; Loop till something found or end
v04_gotpartial:
	mov	ebx,VCPIB_00		; Lowest bit to check
	mov	ecx,4			; 4 bits to check
v04_findpartial:
	bt	fs:[eax],ebx		; Check the bit
	jnc	short v04_caladdr	; got one
	inc	ebx			; Else next bit
	loop	v04_findpartial		; Loop till done
					; severe error if we fall through
v04_error:
	mov	ah,EMSC_NOTENOUGHPAGES
	ret
v04_nomorepartial:
	test	[freepages],-1		; See if any free pages
	jz	short v04_error		;
	mov	eax,[freelist]         	; Get an item off the free list
	push	eax                     ;
	shl	eax,1                   ;
	add	eax,[logdir]            ;
	movzx	ebx,word ptr fs:[eax]   ;
	mov	[freelist],ebx          ; Mark new start of free list
	dec	[freepages]		; Delete a page
	pop	ebx			; The got item
	movzx	eax,word ptr fs:[ecx]   ; on the end of the used list
	mov	word ptr fs:[ecx],bx	;
	shl	ebx,2                   ; Point to entry we got
	add	ebx,[logdir]		;
	mov	word ptr fs:[ebx],0	; place a zero in the link field
	mov	eax,ecx			;
	bts	dword ptr [eax],VCPIB_USED ; Mark as used
	mov	ebx,VCPIB_00		; Bit to mark
	mov	ecx,4
v04_caladdr:
	bts	fs:[eax],ebx		; Mark the used bit
	mov	eax,fs:[eax]		; Get the page number
	and	eax,07ffh		; Lower 11 bits
	shl	eax,14			; To a page
	mov	ebx,4			; Get index
	sub	ebx,ecx			; negate it modulo 4
	shl	ebx,12			; to a 4096 page
	add	eax,ebx			; add the two
	add	eax,[firstfree]		; Add to EMS base
	mov	edx,eax
	sub	ah,ah			; no errors
	ret
vcpi_04a	endp
;
; 16-bit alloc call
;
vcpi_04	proc
	call	vcpi_04a		; allocate
	mov	[GFEDX],edx		; Save return value
	ret
vcpi_04	endp
;
; Deallocate a  4k page - 05
;
vcpi_05	proc
	mov	eax,edx			; Get address
	sub	eax,[firstfree]		; Make relativ
	mov	ecx,eax			;
	shr	ecx,12			; Get 4096 byte page #
	and	ecx,3			;
	shr	eax,14			; Get 16K page #
	lea	esi,[vcpiused]		; Get list
	add	esi,[zero]
	push	ecx			; save subpage
v05_look:
	bt	word ptr fs:[esi], VCPIB_USED ; See if end of list
	jnc	short v05_notfound	; Get out if so
	movzx	ebx,word ptr fs:[esi]	; Get next page #
	and	ebx,NOT VCPIB_USED AND NOT VCPIB_MASK ;
	cmp	eax,ebx			; See if match
	jz	short v05_found		; branch if found
	shl	ebx,1			; Else go to next item in list
	add	ebx,[logdir]		;
	mov	esi,ebx			;
	jmp	v05_look		; loop
v05_notfound:	
	pop	ecx			; clear stack
	mov	ah,EMSC_NOLOGICALPAGE	; Error- not found
	ret
v05_found:
	pop	eax			; Deallocate the subpage
	btr	fs:[esi],eax		;
	test	word ptr fs:[esi],VCPIB_MASK ; See if page is empty
	jnz	short v05_out		; Quit if not
	movzx	eax,word ptr fs:[esi]	; Else get page
	and	eax, NOT VCPIB_USED	; Clear the used bit
	push	eax			; save page #
	shl	eax,1  			; get link		     
	add	eax,[logdir]		;
	push	eax			; save page ptr
	mov	eax,fs:[eax]		; Move link it up
	mov	fs:[esi],eax		;
	mov	ebx,fs:[freelist]	; Get free list
	pop	eax			; Get page ptr
	mov	fs:[eax],ebx		; Append free list to page
	pop	eax			; Get page number
	mov	[freelist],eax		; free list starts here
	inc	[freepages]		; A page was freed

v05_out:
	sub	ah,ah			; No errors
	ret
vcpi_05	endp
;
; 16 bit deallocate call
;
vcpi_05a	proc
	mov	edx,[GFEDX]		; Get page
	call	vcpi_05			; Deallocate
	ret				; return
vcpi_05a	endp
;
; Get phys address of page in first MB - 06
;
vcpi_06	proc
	movzx	eax,word ptr [GFECX]	; Get page number
	cmp	eax,100h		; See if out of range
	mov	ah,EMSC_PHYSPAGERANGE	;
	jnc	short v06_err		; Yep - error
	call	getmappos		; Else get page table pos
	mov	eax,fs:[eax]		; Get value
	and	eax,0fffff000h		; Get address
	mov	[GFEDX],eax		; Save return value
	sub	ah,ah			; No errors
v06_err:
	ret
vcpi_06	endp
;
; Read CR0 - 07
;
vcpi_07	proc
	mov	eax,CR0			; Returns CR0
	mov	[GFEBX],eax		;
	sub	ah,ah			; no errors
	ret
vcpi_07	endp
;
; Read debug regs - 08
;
vcpi_08	proc
	GETFRAME GFEDI,GFES,edi		; Get buffer address
	push	es			; Switch to abs seg in ex
	push	fs
	pop	es
	mov	eax,DR0			; Read DR0
	stosd
	mov	eax,DR1			; Read DR1
	stosd
	mov	eax,DR2			; Read DR2
	stosd		
	mov	eax,DR3 		; Read DR3
	stosd
	sub	eax,eax			; Leave space for DR4 and DR5
	stosd
	stosd
	mov	eax,DR6			; Read DR6
	stosd
	mov	eax,DR7			; Read DR7
	stosd
	pop	es
	sub	ah,ah			; No errors
	ret
vcpi_08	endp
;
; Load debug regs - 09
;
vcpi_09	proc
	GETFRAME GFEDI,GFES,ESI		; Get buffer address
	push	ds			; Switch to absseg in DS
	push	fs
	pop	ds
	lodsd
	mov	DR0,eax			; write DR0
	lodsd
	mov	DR1,eax			; write DR1
	lodsd
	mov	DR2,eax			; write DR2
	lodsd
	mov	DR3,eax			; Write DR3
	lodsd
	lodsd
	lodsd
	mov	DR6,eax			; Write dr6
	lodsd
	mov	DR7,eax			; Write DR7
	pop	ds
	sub	ah,ah			; no errors
	ret
vcpi_09	endp
;
; Get interrupt vector mappings -0a
;
vcpi_0a	proc
	mov	word ptr [GFEBX],PIC0VECTOR	; Get vectors as we map them
	mov	word ptr [GFECX],PIC1VECTOR	;
	sub	ah,ah				; no errors
	ret
vcpi_0a	endp
;
; Set interrupt vector mappings - 0b
;
vcpi_0b	proc
	sub	ah,ah				; function ignored, no errors
	ret
vcpi_0b	endp
;
; Switch to protected mode - 0c
;
vcpi_0c	proc
	GETFRAME GFESI,GFDS,esi			; Get buffer pos
	push	FS				; Switch to abs in ds
	pop	ds
	lodsd					; Read new CR3
	mov	CR3,eax				;
	LGDT	[esi]				; Load GDT
	mov	ebx,[esi+2]			; Get GDT address
	add	esi,4
	lidt	[esi]				; IDT
	add	esi,4
	lldt	[esi]				; LDT
	add	esi,2
	mov	ax,[esi]			; get TR
	and	ax,0fff8h			; Clear lower bits
	btr	dword ptr [eax+ebx+4],9		; Clear the busy bit
	ltr	word ptr [esi]			; Load the task reg
	add	esi,2				; Point to CS:EIP
	mov	ebx,[GFEBX]			; Load non-changing regs
	mov	ecx,[GFECX]			;
	mov	edx,[GFEDX]			;
	mov	edi,[GFEDI]			;
	jmp	far [esi]			; Branch to user prog
vcpi_0c	endp
;
; Protected mode function 0c
;
rundown	proc
	cli					; make sure
	push	ecx				; Save non-changing regs
	push	edi				; on caller stack
	push	esi				;
	push	cs				;
	pop	eax				; Get our data seg
	add	eax,8				;
	mov	ds,eax                          ;
	add	eax,8                           ;
	mov	es,eax                          ; And our abs seg
	mov	esi,esp				;
	add	esi,28h + 0ch-4			; Point to top of real-mode data
	mov	edi,offset TOS - 4			; Transfering to temp stack
						; note that next ring switch will
						; get us back to the p-mode stack
	add	edi,ds:zero			; Dest in abs seg
	mov	ecx,28h				; Moving stack fra,e
	push	ss				; Do it
	pop	ds
	std
	rep	movsd
	mov	eax,edi				; eax = new TOS
	pop	esi				; pop unchanging regs
	pop	edi				;
	pop	ecx				;
	push	eax				; save new TOS
	mov	eax,[PageTables]		; reset to our page tables
	mov	CR3,eax				;
	pop	eax				; restore new TOS
	LGDT	[pgdt]				; Load GDT and IDT
	LIDT	[pidt]				;
	db	0eah				; Make sure using new tables
	dd	offset rdo
	dw	CS386
rdo:
	mov	esp,eax				; New TOS
	mov	eax,DS386			; Reset seg regs to prot vals
	mov	ds,eax				;
	mov	es,eax
	mov	eax,DSABS
	mov	fs,eax
	mov	gs,eax
	mov	ss,eax
	mov	ax,TSSDESC			; Load the TSS
	ltr	ax
	sub	eax,eax				; Clear the ldt
	lldt	ax   				;
	mov	dword ptr [GFFLAGS],23002h	; Set flags sensibly
	add	esp,4				; Clear ret address from stack
	iretd					; Back to caller in V86 mode
rundown	endp
seg386	ends
	end