;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; Reboot.asm
;
; function: handle jumps to FFFF:0
;   handle remapping ram to the rom page at FF00:0 and changing the boot jump 
;
; caveat: debugging instructions (with debug) which write to our rom page
;   will lose a single step trap at the V86 level
; Also there is a bug, try doing a 'e ffff:0' and changing the first value
;   in debug

	.386p
include segs.asi
include emuinter.asi
include vm86.asi
include reboot.asi
include xmsctl.asi

	public	RebootCheck, InitReboot, MapTrap, MapStep, chkctrlaltdel

BIOSDATA	segment	public word USE16 AT 40h
	org	17h
keyflags	db	?
BIOSDATA	ends
seg386data	segment

	extrn	MapBase : dword, PageTables : DWoRD
rebootflags	dd	0
sysboot	dw	0
	dw	0ffffh
cadss	dw	?
cadsp	dw	?
seg386data	ends

seg8086	segment
	extrn	xmsctl: PROC
	assume cs:dgroup
;
; Reboot vector comes here
;
newreboot	proc
	bts	[rebootflags],RBF_REBOOT		; Mark for reboot
	mov	al,EMU_RUNDOWN		; Tell 8086 emulator to run down
	out	CONTROLPORT,al		;
	mov	al,EMUP_RUNDOWN		;
	out	DATAPORT,al		;
	cli				; Severe error if we get here
	hlt
newreboot	endp
;
; Rundown procedure calls this to see if we should
; reboot rather than exit to DOS
;
	assume	ds:dgroup
RebootCheck	proc
	bt	[rebootflags],RBF_CAD	; Check if shutdown was do to CAD
	jc	short unloader		; Yep- go hit unloader
	bt	[rebootflags],RBF_REBOOT; Check for reboot
	jnc	short noreboot		; Nope, back to DOS
	jmp	dword ptr [sysboot]	; Take reboot vector
noreboot:
	ret
RebootCheck	endp
;
; Procedure to save regs for a CAD shutdown.  It is far in case I
; need to use it elsewhere
;
	assume	ds:nothing
cad_shutdown	proc	far
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	ds
	push	es
	push	fs
	push	gs
	mov	[cadss],ss
	mov	[cadsp],sp
	bts	[rebootflags],RBF_CAD	; CAD shutdown
	jmp	newreboot		; Go hit shutdown proc
unloader:
	mov	ss,[cadss]
	mov	sp,[cadsp]
	pop	gs
	pop	fs
	pop	es
	pop	ds
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	smsw	ax
	ret
cad_shutdown	endp
;
; Procedrue to handle ctrl-alt-del
;
chkctrlaltdel	proc
	push	ax			;
	cmp	ax,DELKEY		; Delkey?
	jnz	short notcad		; Nope - exit
	assume	ds:BIOSDATA		;
	push	ds			;
	push	BIOSDATA		;
	pop	ds			;
	mov	al,[keyflags]		; Check for CTRL & ALT
	pop	ds			;
	assume	ds:nothing
	and	al,CTRLALTFLAGS		;
	cmp	al,CTRLALTFLAGS		;
	jnz	short notcad		; Nope - exit
	push	ds			; Else make sure A20 is on
	push	es
	push	bx
	push	si
	push	di
	sub	ax,ax
	mov	ds,ax
	dec	ax
	mov	es,ax
	mov	cx,16
	mov	di,090h
	mov	si,080h
	rep	cmpsw
	jnz	short alreadyon
	mov	ah,XMS_A20LOCALEN	; Local enable
	push	cs			;
	call	xmsctl			;
alreadyon:
	mov	cx,16			; Now we clear 16 words in HMA
	sub	ax,ax			; 
	mov	di,10h                  ;
	rep	stosw                   ;
	call	cad_shutdown              ; Shutdown V86 engine
	pop	di			; return to caller
	pop	si			;
	pop	bx			;
	pop	es			;
	pop	ds			;
notcad:
	pop	ax
	ret
chkctrlaltdel	endp


seg8086	ends
seg386	segment
	assume	cs:dgroup,ds:nothing, es:nothing
;
; Page-map some ram over the last page of the bios.
;   Make it read-only, change the vector at FFFF:0 to point at our
;   code
;
InitReboot	proc
	push	ds			; Save regs
	push	es			;
	push	DSABS			; Get abs segment
	pop	es			;
	push	DSABS			;
	pop	ds			;
	cld				; Copy the last 4K of rom to ram
	mov	ecx,1000h / 4		;
	mov	edi,[MapBase]		; This address had better be 4K aligned
	mov	esi,100000h - 1000h	; Address to move from
	rep	movsd			; Do move
	mov	ax,DGROUP		; Form DGROUP:newreboot in eax
	shl	eax,16			;
	mov	ax,offset DGROUP:newreboot;
	mov	edi,[MapBase]		; Change the reboot vector
	mov	[edi +0ff1h],eax	;
	mov	eax,edi			; Get the map base
	or	eax,5			; Make it present & read-only page
	mov	edi,[PageTables]
	add	edi,1000h		; Point to first user page table
	mov	[edi + (100h -1 ) *4],eax; Remap the page table entry
	pop	es			; Restore regs
	pop	ds
	ret
InitReboot	endp
;
; If we get a page trap on our remapped bios page
;   we map it normal and do a single step
;
	assume	ds:dgroup
MapTrap	proc
	push	DS386			; Get data seg
	pop	ds			;
	push	DSABS			; Map in absolute seg
	pop	fs
	push	eax			; save eax
	mov	eax,CR2			; Get linear fault address
	and	eax,0fffff000h		; See if is in our remapped bios page
	cmp	eax,0000ff000h		;
	jnz	nothere			; Nope, return to handler
	pop	eax			; Clear stack
	mov	[esp],ebp		; Replace the return address with ebp
					; This gives us the Page Fault stack
					; frame, which is identical to the
					; GPF stack frame
	mov	ebp,esp			;
	push	eax			; Save regs
	push	edi			;
	mov	eax,0ff007h		; Physical address of ROM page, with
					; r/w bit and user bits set
	mov	edi,[PageTables]	; Get page tables
	mov	fs:[edi+(100h-1)*4+1000h],eax	; Set the rom page entry to point at 
					; the rom page
	mov	CR3,edi			; flush the TLBs
	bts	dword ptr [GFFLAGS],TF	; Set the single step flag
	bts	[rebootflags],RBF_STEPPING ; Mark that we are stepping
	pop	edi			; Pop regs
	pop	eax  			;
	pop	ebp			;
	add	esp,4			; Clear error number from stack
	iretd				; back to v86 mode

nothere:
	pop	eax
	ret
MapTrap	endp
;
; Done single stepping a rom write instruction, map
;   our shadow page back and disable the single stepping
;
MapStep	proc
	push	DS386			; Get data seg
	pop	ds			;
	push	DSABS
	pop	fs
	btr	[rebootflags],RBF_STEPPING ; See if stepping
	jnc	nostep			; Return to generic handler if not
	push	ebp			; The call return is still on the stack
					; This gives us the same stack frame
					; as GPF sees
	mov	ebp,esp
	push	eax			; Save regs
	push	edi			;
	mov	eax,[MapBase]           ; Get page to map in
	or	al,5			; Mark it user, read-only
	mov	edi,[PageTables]	; Get the 1st user page table
	mov	fs:[edi+(100h-1)*4+1000h],eax	; remap the page
	mov	CR3,edi			; Reload CR3 to flush the TLBs
	btr	dword ptr [GFFLAGS],TF	; Reset the trap flag for no more ints
	pop	edi			; Pop regs
	pop	eax
	pop	ebp
	add	esp,4			; Bump past call return
	iretd				; Return to V86

nostep:
	ret
MapStep	endp
	
seg386	ends
	end