;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; IDT.ASM
;
; Function: Set up the protected mode IDT and vector all ints and processor
;   traps as INT vectors so IF will be cleared when we are in
;   protected mode
;
	.386P


include segs.asi
include tss.asi
include idt.asi
include vm86.asi
	public setidt,exc1,exce, pIDT, stackdump
SEG386	segment
	extrn	emulate: PROC, transfer: PROC, endprotection : PROC
	extrn	emu386: PROC, GFTrapFrame : PROC
	extrn	MapTrap:PROC, MapStep :PROC
SEG386	ends


SEG386Data 	segment
	extrn MemBase : DWORD, MemFree : DWORD, TSSBase : DWORD, tGDT : BYTE
	extrn recent : DWORD, circle : DWORD
pIDT	dw	IDTSIZE-1
	dd	0
SEG386Data	ends


SEG386	segment
	assume cs:dgroup,ds:dgroup, fs: ABSDATA
;
; Base addresses for 386 traps
;
; (vectors 0 -1f)
traptab	dd	dgroup:exc0,dgroup:exc1,dgroup:exc2,dgroup:exc3,dgroup:exc4,dgroup:exc5,dgroup:exc6,dgroup:exc7
	dd	dgroup:exc8,dgroup:exc9,dgroup:exca,dgroup:excb,dgroup:excc,dgroup:emulate,dgroup:exce,dgroup:excf
	dd	dgroup:exc10
	dd	0,0,0,0,0,0,0
	dd	0,0,0,0,0,0,0,0
;
; Base addresses for hardware interrupts
;
; (vectors 20-2f)
;
inttab	dd	dgroup:int0,dgroup:int1,dgroup:int2,dgroup:int3,dgroup:int4,dgroup:int5,dgroup:int6,dgroup:int7
	dd	dgroup:int8,dgroup:int9,dgroup:inta,dgroup:intb,dgroup:intc,dgroup:intd,dgroup:inte,dgroup:intf
;
; Trap and interrupt vectors
;
exc0:	TRANSFERINT	0,DEBUG
exc1:	
	call	MapStep
	TRANSFERINT	1,0
exc2:	TRANSFERINT	2,DEBUG
exc3:	TRANSFERINT	3,0
exc4:	TRANSFERINT	4,DEBUG
exc5:	TRANSFERINT	5,DEBUG
exc6:	TRANSFERINT	6,DEBUG
exc7:	TRANSFERINT	7,DEBUG
exc8:	QUIT 8,DEBUG
exc9:	TRANSFERINT	9,DEBUG
exca:	QUIT 10,DEBUG
excb:	QUIT 11,DEBUG
excc:	QUIT 12,DEBUG
exce:
ife	DEBUG
	call	MapTrap		; Handle page fault on ROM write
endif
				; returns to VM86 proc if success
	QUIT	14,DEBUG
excf:	QUIT 15,DEBUG
exc10:	TRANSFERINT	10h,DEBUG
int0:	TRANSFERINT	8,0
int1:	TRANSFERINT	9,0
int2:	TRANSFERINT	0ah,0
int3:	TRANSFERINT	0bh,0
int4:	TRANSFERINT	0ch,0
int5:	TRANSFERINT	0dh,0
int6:	TRANSFERINT	0eh,0
int7:	TRANSFERINT	0fh,0
int8:	TRANSFERINT	70h,0
int9:	TRANSFERINT	71h,0
inta:	TRANSFERINT	72h,0
intb:	TRANSFERINT	73h,0
intc:	TRANSFERINT	74h,0
intd:	TRANSFERINT	75h,0
inte:	TRANSFERINT	76h,0
intf:	TRANSFERINT	77h,0
;
; Make an int gate
;
loadint	proc
	mov	word ptr fs:[edi+edx*8],ax	; Low word of vector addr
	shr	eax,16
	mov	word ptr fs:[edi+edx*8+6],ax	; High word of vector addr
	mov	word ptr fs:[edi+edx*8+2],bx	; CS Selector
	mov	byte ptr fs:[edi+edx*8+4],0	; Params to push = 0
	mov	byte ptr fs:[edi+edx*8+5],08eh	; Assume int
	ret			;
loadint	endp
;
; Main routine to initialize IDT
;
setidt	proc
	mov	edi,[TSSBase]		; IDT is at end of TSS
	add	edi,TSSSIZE-IDTSIZE	;
	mov	dword ptr [pIDT+2],edi	; Save IDT address for lidt command
	mov	esi,offset dgroup:traptab ; Get the trap list
	mov	ecx,NUMEXCEPT		; Number of traps
	mov	bx,CS386		; BX = code seg selector
	sub	edx,edx			; Init trap num = 0
@@silp:
	lodsd				; Get trap vect
	call	loadint			; Load it as an int
	inc	edx			; Inc trap num
	loop	@@silp			; Loop till done
	mov	esi,offset dgroup:inttab; Get interrupt list
	mov	ecx,NUMINT		; Number of interrupts
@@silp2:
	lodsd				; Get interrupt vect
	call	loadint			; Load it as an int
	inc	edx			; Inc int num
	loop	@@silp2			; Loop till done
	lidt	fword ptr [pIDT]	; Load the prot mode IDT
	ret
setidt	endp
SEG386	ends
IF	DEBUG
SEGMENT	seg386data
saveeax	dd	0
saveesi	dd	0
saveedi	dd	0
saveecx	dd	0
pos	dd	0
names	db	"trap #",0,"error",0,0
	db	"eax",0,"ebx",0,"ecx",0,"edx",0,"esi",0,"edi", 0,0
	db	"ebp",0,"esp",0,"eip",0,"flags",0,0
	db	" ds",0," es",0," ss",0," cs",0," fs",0," gs",0,0,"stack",0,0
ENDS	seg386data
SEGMENT	seg386
hexdword proc
	push	eax
	shr	eax,16
	call	hexword
	pop	eax
hexword:
	push	eax
	mov	al,ah
	call	hexbyte
	pop	eax
hexbyte:
	push	eax
	shr	al,4
	call	hexnib
	pop	eax
hexnib:
	and	al,0fh
	add	al,'0'
	cmp	al,'9'
	jbe	charprint
	add	al,7
charprint:
	mov	edi,[pos]
	stosb
	inc	edi
	mov	[pos],edi
	ret
hexdword endp
putstr	proc
	cmp	byte ptr [esi],0
	jnz	short nocr
	inc	esi
	call	cr
nocr:
	mov	al,20h
	call	charprint
ps2:
	cmp	byte ptr [esi],0
	jz	short psend
	movsb
	inc	edi
	jmp	ps2
psend:
	inc	esi
	mov	[pos],edi
	mov	al,':'
	call	charprint
	ret
putstr	endp
cr	proc
	push	edx
	mov	eax,[pos]
	sub	eax,0b8000h
	mov	edi,160
	sub	edx,edx
	div	edi
	inc	eax
	mul	edi
	add	eax,0b8000h
	mov	[pos],eax
	pop	edx
	ret
cr	endp
stackdump	proc
	cld
	push	ebp
	mov	ebp,esp
	add	ebp,4
	push	DSABS
	pop	es
	push	DS386
	pop	ds
	mov	[saveedi],edi
	mov	[saveesi],esi
	mov	[saveeax],eax
	mov	[saveecx],ecx
	mov	edi,0b8000h
	mov	[pos],edi
	mov	ecx,80*24
	mov	ax,0720h
	rep	stosw
	mov	esi,offset dgroup:names
	putnum	[EBP]  		; Points at trap num
	putnum	[GFERR]
	putnum	[saveeax]
	putnum	ebx
	putnum	[saveecx]
	putnum	edx
	putnum	[saveesi]
	putnum  [saveedi]
	putnum	[ebp-4]
	putnum	[GFESP]
	putnum	[GFEIP]
	putnum	[GFFLAGS]
	putnum	[GFDS]
	putnum	[GFES]
	putnum	[GFSS]
	putnum	[GFCS]
	putnum	[GFFS]
	putnum	[GFGS]
	call	putstr
	call	cr
	GETFRAME GFESP,GFSS,ebx
	mov	ecx,16
dmplp:
	mov	ax,es:[ebx]
	inc	ebx
	inc	ebx
	call	hexword
	call	cr
	loop	dmplp

	sub	[pos], 16*160-14
	mov	edx, [circle]
	mov	ecx, 16
rclp:	and	dl, 15
	mov	ax, word ptr recent[edx*8]
	call	hexword
	add	[pos], 2
	mov	ax, word ptr recent+2[edx*8]
	call	hexword
	add	[pos], 2
	mov	eax, recent+4[edx*8]
	call	hexdword
	add	[pos], 160-36
	inc	edx
	loop	rclp

hang:	hlt
	jmp	hang
stackdump	endp
ENDS	seg386
ENDIF
	end