;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; emuinter.asm
;
; function: emu interface module.  Interprets in and out to the control
; and data ports and dispatches functions
;
	.386p

include segs.asi
include emuinter.asi
include vm86.asi

	public	emuin,emuout, emuioflags

SEG386	segment
	extrn emuint15h: PROC, endprotection : PROC, mapa20 : PROC
	extrn emsentry : PROC, callrestore : PROC
SEG386	ends

SEG386DATA	segment
emuioflags	dd	0		; Flags for I/O emu
function	dd	EMU_NOCOMMAND ; Default function
SEG386data	ends

seg386	segment
	assume	CS:DGROUP, DS: DGROUP
functab	LABEL	DWORD
	dd	dgroup:nullfunc,dgroup:emuint15h
	dd	dgroup:rundown, dgroup:mapa20, dgroup:emsentry, dgroup:callrestore
;
; Run the VM86 system down
;
rundown	proc
	cmp	al,EMUP_RUNDOWN	; Must have rundown param
	jz	endprotection	; End protection if so
	ret			; Else ignore the out
rundown	endp
;
; Input from control/data port.  Right now we're doing everything with shared
; memory, just return a 0c4h.  This can be implemented if someone cares to
; move the code into extended memory.
;
emuin	proc
	bts	[EmuIOFlags],EMUF_IN	; Mark input
	mov	byte ptr [GFEAX],0c4h	; Clear return val
	ret
emuin	endp
;
; Output to control/data port
;
emuout	proc
	btr	[EmuIOFlags],EMUF_IN	; Mark output
	cmp	dl,CONTROLPORT	; Check for control port
	jz	outcontrol	; Branch if so
	mov	ebx,[function]	; Get function
	call	[ebx*4 + functab]; Call it
	btr	[EmuIOFlags],EMUF_COMMANDED	; Clear command flag
nullfunc:
	ret
	
outcontrol:
	bts	[EmuIOFlags],EMUF_COMMANDED	; Set command flag
	cmp	al,MAXEMU	; Check for out of range
	jbe	@ok
	sub	al,al		; Out of range funcs result in null func
@ok:
	movzx	eax,al        	; Get function number
	mov	[function],eax	;
	ret
emuout	endp
seg386	ends
	end