;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
; EMS.ASM
;
; function: ems support
;
	.386
include segs.asi
include ems.asi
include emuinter.asi
include vm86.asi
include vcpi.asi

OS_DENIED	EQU	31
OS_INPROGRESS	EQU	30
TIMER		EQU	46ch

	public	readmap,emsentry,callrestore, getmappos
;
; Check if something is a logical page
;
islogical	MACRO	reg
	local	xxx
	btr	fs:[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED; Clear the handle in use bit
	cmp	reg,fs:[edi + HANDLE.PAGECOUNT]	; See if page is within range
	pushfd					; Set the handle use bit
	bts	fs:[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED	;
	popfd					;
	jc	short xxx			; Branch if in range
	mov	ah,EMSC_NOLOGICALPAGE		; Else return error
	ret
xxx:
	endm

seg386data segment
	extrn	PageFrame: word, maxpages : dword, freelist : dword, logdir : dword
	extrn	handtab : DWORD, PageTables : DWORD, segentries : DWORD
	extrn	segtab : DWORD , FreePages : DWORD, firstfree:DWORD
	extrn	zero : DWORD, userIDT : DWORD, maptabs : dword
callbase	dd	?	; Used to transfer control during map & call
restorechain	dd	0	; Pointer to last call block in call chain
mapflags	dd	0feh	; Allocation bits for maps & OS priveledge flags
mapnum		dd	0	; Current map number
oskey		dd	0	; Key for OS usage
seg386data ends

seg8086 segment
	assume cs:dgroup
;
; Real mode EMS control proc
;
emsctrl	proc
oldint67h	dd	?	; Old EMS vector for restore op
int67h:
	push	ax		; Save function
	mov	al,EMU_EMS	; ISet up EMS function
	out	CONTROLPORT,al	;
	pop	ax		;
	out	DATAPORT,al	; Any data here will invoke the EMS handler
				; The EMS handler has run by this point,
				; and regs are set up
	iret
emsctrl	endp
;
; Real mode routine to do a map & call
;
; When this is called the new map will be in effect
;
emscall	proc
	call	[callbase]	; Call the user routine
	mov	al,EMU_EMSCALLRESTORE	; Function to do a return from call
	out	CONTROLPORT,al	; Tell the EMS handler to unmap and do a return
	out	DATAPORT,al	;
	cli			; If we get here the EMS handler is very corrupt
	hlt
emscall	endp

seg8086	ends

seg386	segment
	extrn	vcpientry: PROC, SFTrapFrame : PROC
;
; basic EMS function table
;
emstable	label	dword
	dd	dgroup:ems_01,dgroup:ems_02,dgroup:ems_03,dgroup:ems_04,dgroup:ems_05,dgroup:ems_06,dgroup:ems_07,dgroup:ems_08,dgroup:ems_09
	dd	dgroup:ems_10,dgroup:ems_11,dgroup:ems_12,dgroup:ems_13,dgroup:ems_14,dgroup:ems_15,dgroup:ems_16,dgroup:ems_17,dgroup:ems_18,dgroup:ems_19
	dd	dgroup:ems_20,dgroup:ems_21,dgroup:ems_22,dgroup:ems_23,dgroup:ems_24,dgroup:ems_25,dgroup:ems_26,dgroup:ems_27,dgroup:ems_28,dgroup:ems_29
	dd	dgroup:ems_30
;
; Subtables for various subfunctions
;
func15tab	label	dword
	dd	dgroup:ems_1500,dgroup:ems_1501,dgroup:ems_1502,dgroup:ems_1503
func16tab	label	dword
	dd	dgroup:ems_1600,dgroup:ems_1601,dgroup:ems_1602
func21tab	label	dword
	dd	dgroup:ems_2100,dgroup:ems_2101,dgroup:ems_2102
func28tab	label	dword
	dd	dgroup:ems_2800,dgroup:ems_2801,dgroup:ems_2802,dgroup:ems_2803,dgroup:ems_2804
func30tab	label	dword
	dd	dgroup:ems_3000,dgroup:ems_3001,dgroup:ems_3002
;
; Routine to init for EMS interrupt
;
	assume	ds:dgroup,fs:dsabs
int67hinit	proc
	pushfd        			; Clear IF
	cli				;
	mov	ebx,[userIDT]		; Get base of IDT table
	add	ebx,67h*4		; + int 15h vector ofs
	mov	eax,fs:[ebx]		; Get old vector
	mov	[oldint67h],eax		;
	mov	ax,DGROUP		; Set new vector in EAX
	shl	eax,16			;
	or	ax,offset DGROUP:int67h	;
	mov	fs:[ebx],eax		; Put vector in int table
	popfd				;
	ret
int67hinit	endp
;
; Routine to run down EMS interrupt
;
int67hrundown	proc
	pushfd				; Clear IF
	cli
	mov	eax,[oldint67h]		; Put old vect back in table
	mov	ebx,[userIDT]
	mov	fs:[ebx + 67h*4],eax	; Get base of IDT + int 15h vector ofs
	popfd				;
	ret
int67hrundown	endp
;
; EMS entry
;
emsentry	proc
	push	DSABS    		; Set FS = DSABS
	pop	fs			;
	mov	ax,[GFEAX]		; Get function code
	cmp	ah,VCPI_FUNC		; See if is VCPI
	jz	vcpientry		; Yes - transfer to VCPI handler
	sub	ah,EMS_MINFUNC		; Check function range
	jc	short bademsfunc	;
	cmp	ah,EMS_MAXFUNC		;
	ja	short bademsfunc	;
	movzx	ebx,ah			; Get function number in EBX
	call	cs:[ebx*4+emstable]	; Call ems function
	mov	byte ptr [GFEAX+1],ah	; Set function code
	ret				; Return to VM86 handler
bademsfunc:
	mov	ah,EMSC_UNDEFUNC	; Undefined EMS function
	mov	[GFEAX+1],ah		; And return it
	ret
emsentry	endp
;
; Get manager status- 01
;
ems_01	proc
statusok:
	sub	ah,ah			; Always returns good status
	ret
ems_01	endp
;
; Get page frame segment - 02
;
ems_02	proc
	mov	ax,word ptr [pageframe]; Returns page frame in bx
	mov	[GFEBX],ax		;
	sub	ah,ah			; status = good
	ret
ems_02	endp

;
; Get page counts - 03
;
ems_03	proc
	mov	eax,[maxpages]		; Return max pages in DX
	mov	[GFEDX],ax
	mov	ecx,[FreePages]		; Return free pages in BX
	mov	[GFEBX],cx	
	sub	ah,ah			; status = good
	ret	
ems_03	endp
;
; Allocate a handle
;
allocatehandle	proc
	mov	edi,[handtab]		; Get the handle table
	mov	ecx,EMS_HANDLES		; Number of handles to search through
ahlp:
	bt	fs:[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED; Check if current is allocated
	jnc	ahgot			; Branch if so
	add	edi,type(handle)	; Next handle
	loop	ahlp			; Loop
	stc
	mov	ah,EMSC_NOHANDLES	; Error, nothing free
	ret
ahgot:
	sub	eax,eax
	mov	fs:[edi + HANDLE.MAPS],eax; Clear maps
	mov	fs:[edi + HANDLE.PAGECOUNT],ax	; No pages
	bts	fs:[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED; Allocated
	mov	eax,EMS_HANDLES		; Get handle num in eax
	sub	eax,ecx
	clc				; no error
	ret
allocatehandle	endp
;
; Traverse a list
;
traverselist	proc
	mov	ebx,0ffffh		; mark nothing in list
	jecxz	tldone
tllp:
	movzx	ebx,word ptr fs:[edx]	; Get next page
	lea	edx,[ebx*2]		;
	add	edx,[logdir]            ; As offset in logdir
	cmp	word ptr fs:[edx],0ffffh; See if end of list
	jz	tldone			; quit if so
	loop	tllp			; Else loop to next entry
tldone:
	ret
traverselist	endp
;
; Allocate pages
;
allocatepages	proc
	cmp	ebx,[FreePages]		; See if enough pages left to satisfy
	jnc	aperr			; request- error if not
	or	ebx,ebx
	jz	noalloc
	push	ebx
	lea	edx,[edi + HANDLE.PAGELIST] ; Point at pagelist var
	add	edx,[zero]		;
	mov	ecx,-1			; Find end of list
	call	traverselist		;
	pop	ecx			; Get pages to allocate
	sub	[FreePages],ecx		; Decrement free pages by count
	add	fs:[edi + HANDLE.PAGECOUNT],cx ; Increment pages this handle
	mov	eax,[freelist]		; Get free list
	mov	fs:[edx],ax		; Append to handle list
	call	traverselist		; Traverse list to last moved item
	movzx	eax, word ptr [edx]	; Get new free list start
	mov	[freelist],eax		;
	mov	word ptr fs:[edx],0ffffh; End the allocation chain
noalloc:
	clc
	ret
aperr:
	mov	ah,EMSC_NOTENOUGHPAGES	; Error if not enough pages
	stc
	ret
allocatepages	endp
;
; Get Handle & Allocate Memory - 04
;
ems_04	proc
	movzx	ebx,word ptr [GFEBX]	; Get size
	or	ebx,ebx
	mov	ah,EMSC_REQZEROPAGE	; Error if zero request
	jz	short ems04out		;
	cmp	ebx,[maxpages]		; Error if more than in EMS system
	mov	ah,EMSC_PAGECOUNTERR
	ja	short ems04out		;
	call	allocatehandle		; Allocate a handle
	jc	short ems04out          ; err if none
	mov	[GFEDX],ax		; save handle for caller
	call	allocatepages		; Allocate the pages
	jc	short ems04out		; Get out if error
	sub	ah,ah			; no errors
ems04out:
	ret
ems_04	endp
;
; Get the address for a handle
;
gethandleaddr	proc
	cmp	ax,EMS_HANDLES		; See if valid handle
	Ja	ghabad			; Error if not
	mov	ebx,type(HANDLE)	; Get handle db pos
	mul	ebx			;
	add	eax,[handtab]		;
	mov	edi,eax			; Point at handle db
	bt	fs:[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED ; See if allocated
	jnc	short ghabad		; Error if not
	clc				; OK, return
	ret
ghabad:
	stc
	mov	ah,EMSC_INVHANDLE	; No such handle
	ret
gethandleaddr	endp
;
; Get map table position
;
getmappos	proc
	mov	ecx,eax			; Save lower bits
	shr	eax,22			; Get upper 10 bits
	lea	eax,[eax*4]		;
	add	eax,[PageTables]	; Index into page dir
	mov	eax,fs:[eax]		; Get entry
	and	eax,0ffffc000h		; Clear extraneous bits
	shr	ecx,12			; Get middle 10 bits
	and	ecx,03ffh		;
	lea	eax,[eax + ecx * 4]	; Point to map table entry
	ret
getmappos	endp
;
; Map/Unmap a page of memory
;
mappage	proc
	cmp	bx,0ffffh		; Check for clearing a page
	jnz	short mpgetaddr		; Nope,
	mov	ebx,eax			; Yes, calculate so physical = linear
	shl	ebx,4			;
	jmp	short mpgotaddr		;
mpgetaddr:
	shl	ebx,14			; Calculate phys address of page
	add	ebx,[firstfree]		;
mpgotaddr:
	and	ebx,0ffffc000h		; Calculate pt entry
	or	ebx,7	; present, user, read/write
	call	getmappos		; Get the pos in the pagemaps
	mov	fs:[eax],ebx		; Save entry
	add	ebx,4096		; We have to do 4 4 pages
	mov	fs:[eax+4],ebx		; for a 16K ems page
	add	ebx,4096		;
	mov	fs:[eax+8],ebx
	add	ebx,4096
	mov	fs:[eax+12],ebx
	ret
mappage	endp
;
;
; Map/unmap memory - 05
;
ems_05	proc
	mov	al,[GFEAX]		; Get phys map page
	mov	ah,EMSC_PHYSPAGERANGE	; Must be 0-3
	cmp	al,4			;
	jnc	short ems05out		;
	movzx	ebx,word ptr [GFEBX]	; Get new page
	cmp	bx,0ffffh		; -1 = unmap
	jz	e5unmap			;
	movzx	eax,word ptr [GFEDX]	; Get handle address
	call	gethandleaddr		;
	jc 	short ems05out		;
	movzx	eax,word ptr [GFEBX]	; Get logical page
	islogical	ax		; Check if is ok
e05a:
	mov	ecx,eax			; ECX = page
	lea	edx,[edi + HANDLE.PAGELIST]; Traverse list
	add	edx,[zero]		;
	call	traverselist		;
e5unmap:
	movzx	eax,byte ptr [GFEAX]	; Get phys page
	shl	eax,14			; Map into page frame
	movzx	ebx,word ptr [PageFrame]
	add	eax,ebx		;
	call	mappage			; Map the page
	sub	ah,ah			; no errors
ems05out:
	ret
ems_05	endp
;
; DeallocatePages
;
deallocatepages	proc

	movzx	eax,fs:[edi+HANDLE.PAGECOUNT]   ; Get page count
	btr	eax,EMS_ALLOCATED 		; Clear allocate bit
	cmp	ecx,eax				; See if enough pages
	jc	dpok				;
	mov	ecx,eax				; Nope- deallocate all
dpok:
	sub	fs:[edi+HANDLE.PAGECOUNT],cx	; Sub pages from count
	add	[FreePages],ecx			; Inc freepage count
	lea	edx,[edi + HANDLE.PAGELIST]	; Point at list
	add	edx,[zero]
	call	traverselist			; Traverse it
	movzx	eax,word ptr [edx]		; Get stuff to add to free list
	mov	word ptr [edx],0ffffh		; End the handle list
	push	eax				; Save new start of free list
	shl	eax,1				; Get address in logdir
	add	eax,[logdir]			;
	mov	edx,eax				;
	mov	ecx,-1				; Traverse to end of list
	call	traverselist			;
	mov	eax,[freelist]			; Save old free list here
	mov	word ptr fs:[edx],ax		;
	pop	eax				; Get new free list
	mov	[freelist],eax			;
	ret
deallocatepages	endp
	
;
; Deallocate handle and memory - 06
;
ems_06	proc
	movzx	eax,word ptr [GFEDX] 	; Get handle
	sub	ebx,ebx			; Assume 0
	or	eax,eax			;
	jz	ems_18a			; Never delete OS handle
	call	gethandleaddr		; Get handle address
	jc	short ems06out		; Get out if error
	mov	ecx,-1			; Deallocate all pages
	call	deallocatepages		;
	mov	byte ptr fs:[edi + HANDLE.PAGECOUNT],0 ; Reset page count and alloc flag
	lea	edi,fs:[edi + HANDLE.HNAME] ; Clear name to 0
	push	es			;
	push	fs			;
	pop	es			;
	sub	eax,eax			;
	stosd
	stosd
	pop	es
	sub	ah,ah			; no errors
ems06out:
	ret
ems_06	endp
;
; Get EMM version	- 07
;
ems_07	proc
	mov	byte ptr [GFEAX],EMSVERSION ; Save version
	sub	ah,ah			; no errors
	ret
ems_07	endp
;
; Save page map - 08
;
ems_08	proc
	movzx	eax,word ptr [GFEDX]	; Get handle 
	call	gethandleaddr		;
	jc	short ems08out		; out if none
	cmp	dword ptr fs:[edi + HANDLE.MAPS],0 ; See if already mapped
	mov	ah,EMSC_HASCONTEXTSTACK	; Error if so
	jnz	short ems08out		;
	movzx	eax,[PageFrame]		; Get page frame
	call	getmappos		; Find pos in map
	mov	esi,eax			;
	lea	edi,[edi + HANDLE.MAPS]	; Get map save area
	push	ds			; Switch to abs data
	push	es
	push	dsabs
	pop	ds
	push	dsabs
	pop	es
	mov	cx,16			; Move 16 map entries (64K)
	rep	movsd
	pop	es
	pop	ds
	sub	ah,ah			; No errors
ems08out:
	ret
ems_08	endp	
;
; Restore page map - 09
;
ems_09	proc
	movzx	eax,word ptr [GFEDX]	; Get handle
	call	gethandleaddr		;
	jc	short ems09out		; Out if error
	cmp	dword ptr fs:[edi + HANDLE.MAPS],0 ; See if any saved
	mov	ah,EMSC_NOCONTEXTSTACK	; Error if not
	jz	short ems09out		;
	movzx	eax,[PageFrame]		; Get map pos
	call	getmappos		;
	mov	esi,eax			;
	lea	edi,[edi + HANDLE.MAPS]	; Get handle map save area
	push	edi
	xchg	esi,edi			; Switch source & dest
	push	ds			; Switch to abs data seg
	push	es
	push	dsabs
	pop	ds
	push	dsabs
	pop	es
	mov	cx,16			; Move 16 entries back
	rep	movsd			;
	pop	es
	pop	ds
	pop	edi
	mov	dword ptr fs:[edi],0	; Mark the map save area empty
	sub	ah,ah			; No errors
ems09out:
	ret
ems_09	endp
;
;
; unused procs
;
ems_10	proc
	mov	ah,EMSC_UNDEFUNC	; Return UNDEFUNC error
	ret
ems_10	endp
ems_11	proc
	mov	ah,EMSC_UNDEFUNC	; Return UNDEFUNC error
	ret
ems_11	endp
;
; Get handle count - 12
;
ems_12	proc
	mov	ecx,EMS_HANDLES		; Gotal number of handles
	mov	esi,[handtab]		; Handle table
	sub	ebx,ebx			; Handle count = 0
e12lp2:
	bt	fs:[esi + HANDLE.PAGECOUNT],EMS_ALLOCATED ; See if allocated
	jnc	e12lp1			; Nope, continue
	inc	ebx			; Else inc handle count
e12lp1:
	add	esi,type(HANDLE)	; Move to next entry
	loop	e12lp2			; Loop till done
	mov	[GFEBX],bx		; Save handle count ret val
	sub	ah,ah			; no errors
	ret
ems_12	endp
;
; Get pages owned by handle - 13
;
ems_13	proc
	movzx	eax,word ptr [GFEDX]	; Get handle
	call	gethandleaddr		;
	jc	short ems13out		; Error if no handle
	movzx	eax,fs:[edi + HANDLE.PAGECOUNT]; Get page count
	btr	eax,EMS_ALLOCATED	; Clear allocate bit
	mov	[GFEBX],ax		; Set return value
	sub	ah,ah			; No errors
ems13out:
	ret
ems_13	endp
;
; Get pages for all handles - 14
;
ems_14	proc
	GETFRAME GFEDI,GFES,edi		; edi = save buffer
	mov	ecx,EMS_HANDLES		; Get handtab
	mov	esi,[handtab]		;
	sub	ebx,ebx			; Number of handles = 0
	sub	eax,eax			; current handle number
e14lp2:
	bt	fs:[esi + HANDLE.PAGECOUNT],EMS_ALLOCATED ; Check for allocated
	jnc	e14lp1			; No - next handle
	inc	ebx			; Yes, inc count
	movzx	edx,fs:[esi + HANDLE.PAGECOUNT]; Get pagecount
	btr	edx,EMS_ALLOCATED	; Clear allocate bit
	mov	fs:[edi],ax		; Save handle number
	mov	fs:[edi+2],dx		; Save pages
	add	edi,4			; next entry in table
e14lp1:
	inc	eax                     ; Next handle
	add	esi,type(HANDLE)	
	loop	e14lp2			; Loop till done
	mov	[GFEBX],bx		; Save handle count ret val
	sub	ah,ah			; No errors
	ret
ems_14	endp
;
; Get/set Page Map Registers 15
;
ems_15	proc
	movzx	eax,byte ptr [GFEAX]	; Get subfunction number
	cmp	al,4			; In range?
	jc	short ems15distrib	; Yes, dispatch it
ems15_err:
	mov	ah,EMSC_UNDEFSUBFUNC     ; Else undef function
	ret
ems15distrib:
	jmp	cs:[eax*4+FUNC15TAB]	; Dispatch the subfunction
;
; subfunction 0 - get pagemap regs
;
ems_1500:
	GETFRAME GFEDI,GFES,edi		; EDI = pos for map info
	mov	edx,[segtab]		; Get the segusage tab
	mov	ecx,[segentries]	; Get total seg entries
	push	es			; Switch to DSABS
	push	ds
	push	fs
	pop	es
	push	fs
	pop	ds
e1500_3:
	cmp	word ptr [esi],0      	; Check for seg in use
	jz	short e1500_1		; No- next seg
	movzx	eax,word ptr [esi]	; Get linear address of seg
	shl	eax,4			;
	push	ecx			; convert to page table address
	call	getmappos
	pop	ecx
	mov	eax,[eax]		; Get the map info
	stosd				; Save it
	dec	cx			; dec count
e1500_1:
	add	esi,4			; Point to next
e1500_2:
	or	ecx,ecx			; Loop till done
	jnz	e1500_3
	pop	ds			; Restore segs
	pop	es
	sub	ah,ah			; No errors
	ret
;
; Subfunction 1 = set pagemap regs
	
ems_1501:
	GETFRAME GFESI,GFDS,esi		; ESI = source
	mov	edi,[segtab]		; Get the usage tab
	mov	ecx,[segentries]	; Number of entries to step through
	push	es			; Switch to DSABS
	push	ds
	push	fs
	pop	es
	push	fs
	pop	ds
e1501_3:           
	cmp	word ptr [edi],0	; See if any entry
	jz	short e1501_1		; no -continue
	movzx	eax,word ptr [edi]	; Get linear address of seg
	shl	eax,4
	push	ecx			; Get page table address
	call	getmappos		;
	pop	ecx
	mov	ebx,eax			; Save page map address
	lodsd				; Get new page value
	mov	[ebx],eax		; save it
e1501_1:
	add	edi,4			; next entry in seg table
e1501_2:
	or	ecx,ecx			; See if done
	jnz	e1501_3			;
	pop	ds
	pop	es
	sub	ah,ah			; no errors
	ret
;
; Subfunction 2 - get & set page map
;
ems_1502:
	GETFRAME GFESI,GFDS,esi		; Get set array
	GETFRAME GFEDI,GFES,edi		; get get array
	mov	edx,[segtab]		; get segtab & limit
	mov	ecx,[segentries]	;
	push	es			; Switch to abs data seg
	push	ds
	push	fs
	pop	es
	push	fs
	pop	ds
e1502_3:           
	cmp	word ptr [edx],0	; See if is unused
	jz	short e1502_1		; Branch if so
	mov	eax,[edx]		; Calculate linear address of seg
	shl	eax,4			;
	push	ecx			; Calculate pos in page map
	call	getmappos		;
	pop	ecx			;
	mov	ebx,eax			; Save old value in get array
	mov	eax,[ebx]		;
	stosd
	lodsd				; Get new value from set array
	mov	[ebx],eax
	dec	cx              	; We did one more
e1502_1:			
	add	edx,4			; Point to next segtabe entry
	or	ecx,ecx 		; Check if done
	jnz	e1502_3			;
	pop	ds
	pop	es
	sub	ah,ah			; No errors
	ret
;
; Sbufunction 3 - get map table size
;
ems_1503:
	mov	eax,[segentries]	; Get size
	shl	eax,2			; * 4
	mov	[GFEAX],al		; Return it in AL
	sub	ah,ah			;
	ret
ems_15	endp
;
; Get the page pointer knowing a seg address
;
pageptrfromseg	proc
	shl	eax,4			; make it linear
	test	eax,3fffh		; Error if not a page boundary
	jnz	badpage			;
	cmp	eax,MINOSPAGE		; Check if in OS pages
	jc	badpage			;
	cmp	eax,MAXOSPAGE		;
	jc	goodpage
	cmp	eax,MINSYSPAGE		; Check if in SYS pages (upper area)
	jc	badpage			;
	cmp	eax,MAXSYSPAGE		;
	jnc	badpage			;
goodpage:
	push	eax			;
	cmp	eax,MINSYSPAGE		; Offset to base address if in sys pages
	jc	noadj			;
	add	eax,BACKFILLPAGES	;
noadj:
	mov	edx,[segtab]		; See if is a known seg
	test	dword ptr fs:[edx + eax*4],0ffffffffh	;
	pop	eax			; Restore the address
	jz	badpage			; bad page if nothing there
	call	getmappos		; Else get the map pos
	clc
	ret
badpage:
	stc
	mov	ah,EMSC_PHYSPAGERANGE	; Page out of range
	ret
pageptrfromseg	endp
;
; get/set Partial page map functions - 16
;
ems_16	proc
	movzx	eax,byte ptr [GFEAX]	; Get subfunction
	cmp	al,3			; In range?
	jnc	ems15_err		; Err if not
	jmp	cs:[eax*4+FUNC16TAB]	; Else dispatch
;
; subfunction 0 - get partial page map
ems_1600:
	GETFRAME GFEDI,GFES,edi		; edi = destination
	GETFRAME GFESI,GFDS,esi		; esi = source / page list
	movzx	eax,word ptr fs:[esi]	; Get count
	mov	ecx,eax			; to CX
	cmp	eax,[segentries]	; See if in range
	mov	ah,EMSC_INVPTR		; Error if not
	ja	short ems16out		;
	add	esi,2			; point to source after count
	push	es			; switch to DSABS
	push	ds			;
	push	fs
	pop	es
	push	fs
	pop	ds
	mov	[edi],cx		; save count in dest
	add	edi,2			;
	jecxz	e1600_2			; Quit if is zero
e1600_3:
	movzx	eax,word ptr [esi]	; Get a seg
	mov	[edi],ax		; Save it
	call	pageptrfromseg		; Get the page pointer
	jc	e16bad			; Error if not mappable
	mov	eax,[eax]		; Else get the page map value
	mov	[edi+2],eax		; save it
	add	esi,2			; bump to next array pos
	add	edi,6			;
	loop	e1600_3			; loop till done
e1600_2:
	pop	ds
	pop	es
	sub	ah,ah			; no errors
ems16out:
	ret
e16bad:
	pop	ds
	pop	es
	ret

;
; subfunction 1 - set partial page map
;	
ems_1601:
	GETFRAME GFESI,GFDS,esi		; Get the partial page array
	movzx	ecx,word ptr [esi]	; Get count
	jecxz	e1601_2			; Get out if is zero
	add	esi,2			; Point to data
	push	es			; Switch to DSABS
	push	ds
	push	fs
	pop	es
	push	fs
	pop	ds
e1601_3:           
	movzx	eax,word ptr [esi]	; Get seg
	call	pageptrfromseg		; Turn it into a page map pos
	jc	e16bad			; Error if can't
	mov	ebx,[esi+2]		; Get new map value
	mov	[eax],ebx		; save it
	add	esi,6			; point to next entry
	loop	e1601_3			; loop till done
e1601_2:
	pop	ds
	pop	es
	sub	ah,ah			; no errors
	ret
;
; subfunction 2 - get size of partial page map struct
;
ems_1602:
	movzx	eax,word ptr [GFEBX]	; get entries
	cmp	eax,[segentries]	; See if valid
	mov	ah,EMSC_PHYSPAGERANGE	; Error if not
	ja	short ems16out		;
	mov	ebx,eax			; Multiply by 6
	shl	eax,1			;
	add	ebx,eax			;
	shl	ebx,1			;
	add	ebx,2			; Add in size of count field
	mov	[GFEAX],bl		; Return size

	sub	ah,ah			; no errors
	ret
ems_16	endp
;
; Get a page table ptr from a physical page #
;
pagesegfromphys	proc
	cmp	eax,[segentries]	; Error if too big
	jnc	badpage			;
	mov	ebx,[segentries]	; Get entries before backfill
	sub	ebx,BACKFILLPAGES	;
	cmp	eax,ebx			;
	jnc	short ppfpnobackfill	; No backfill, we have to wade
	sub	eax,ebx			; Else normalize the backfill #
	shl	eax,12			; multiply by 4096
	add	eax,BACKFILLSTART * 0400h ; Add to backfill start
	jmp	short ppfpjoin		; Go save it
ppfpnobackfill:
	mov	ecx,eax			; Get number of pages to loop through
	inc	ecx			;
	mov	eax,[segtab]		; Get start of non-bckfill pages in segtab
	lea	eax,[eax + BACKFILLPAGES*4];
nextseg:
	mov	edx,fs:[eax]		; Read current seg
	or	edx,edx			; See if is zero
	jnz	short okgot		; nope- count down
	add	eax,4			; Else skip it
	jmp	nextseg			;
okgot:
	add	eax,4			; Go to next seg
	loop	nextseg			;
	mov	eax,edx			; Get seg from edx
ppfpjoin:
	clc
	ret
pagesegfromphys	endp
;
; Map multiple pages
;
mapmultiplepages	proc
	or	al,al		; See if mapping is phys # or seg
	jnz	mapmultseg	; branch if seg
	
	movzx	eax,word ptr fs:[esi+2]	; Get phys page number
	call	pagesegfromphys		; Get seg
	jc	mmperr2			
	movzx	edx,word ptr fs:[esi]	; Get logical page number
	mov	ebx,edx			; 
	or	edi,edi			; Do phys mapping if no handle
	push	ecx
	jz	short mmpmap
	btr	fs:[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED ; See if is a logical page
	cmp	dx,fs:[edi+HANDLE.PAGECOUNT] ;
	pushfd						;
	bts	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED  ;
	popfd                                           ;
	jnc	short mmperr                            ; branch if error
	push	eax
	mov	ecx,edx
	lea	edx,fs:[edi+HANDLE.PAGELIST]
	add	edx,[zero]
	call	traverselist
	pop	eax
mmpmap:
	call	mappage				; Map the page
	pop	ecx				;
	add	esi,4
	loop	mapmultiplepages
	clc
	ret
mmperr:
	pop	ecx
	mov	ah,EMSC_NOLOGICALPAGE		; Err if no page
mmperr2:
	stc
	ret
mapmultseg:
	movzx	edx,word ptr fs:[esi]		; Get seg
	mov	ebx,edx				;
	movzx	eax,word ptr fs:[esi+2]		; Get logical page
	or	edi,edi				; Do physical if no handle
	push	ecx				;
	jz	short mmsmap			; do map
	btr	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED ;
	cmp	dx,fs:[edi+HANDLE.PAGECOUNT]	; Else see if page count in range
	pushfd						;
	bts	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED  ;
	popfd                                           ;
	jnc	short mmperr
	mov	ecx,edx				; Locate logical page
	lea	edx,fs:[edi+HANDLE.PAGELIST]	;
	add	edx,[zero]
	call	traverselist
	movzx	eax,word ptr fs:[esi+2]		; reload page number
mmsmap:
	call	mappage				; map it
	pop	ecx
	add	esi,4
	loop	mapmultseg
	clc
	ret
mapmultiplepages	endp
;
; Map/Unmap multiple handle pages - 17
;
ems_17	proc
	mov	ecx,[GFECX]			; Get count
	or	ecx,ecx				; function ignored on zero count
	jz	short ems17ok			;
	movzx	edx,word ptr [GFEDX]		; Get handle
	call	gethandleaddr			;
	jc	short ems17out			; err if none
	GETFRAME GFESI,GFDS,esi			; Get table address
	mov	al,[GFEAX]			; subfunction must be 0 or 1
	cmp	al,2				;
	jnc	ems15_err			; Error if not
	call	mapmultiplepages		; Do the mapping
	jc	short ems17out			; Get out on error
ems17ok:
	sub	ah,ah				; no error
ems17out:
	ret
ems_17	endp
;
; Reallocate Pages - 18
;
ems_18	proc
	movzx	ebx,word ptr [GFEBX]		; Get desired pages
ems_18a:
	push	ebx				; save desired pages
	movzx	eax,word ptr [GFEDX]		; Get handle
	call	gethandleaddr			;
	pop	ebx				; Restore desired
	jc	ems18out			; Err if no handle
	btr	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED ; Clear allocate bit for now
	cmp	bx,fs:[edi+HANDLE.PAGECOUNT]	; See if adding pages
	jc	short ems18lower		; Nope- remove some
	sub	bx,fs:[edi+HANDLE.PAGECOUNT]	; Allocate new pages
	bts	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED;
	call	allocatepages
	jc	short ems19out			; Error
	sub	ah,ah				; no errors
	ret
ems18lower:
	bts	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED;
	mov	ecx,ebx				; count to deallocate
	call	deallocatepages			; Do deallocate
	sub	ah,ah				;
ems18out:
	ret
ems_18	endp
;
; Get/set/queary handle attribute - 19
;
ems_19	proc
	mov	al,[GFEAX]			; Error if subfunc > 3
	cmp	al,2				;
	ja	ems15_err			;
	mov	ah,EMSC_FEATURENOTSUP		; Functions 0 & 1 not supported
	jc	short ems19out
	mov	byte ptr [GFEAX],0		; Function 2 returns 0 in al
	sub	ah,ah				; and no error
ems19out:
	ret
ems_19	endp
;
; Get/set handle name - 20
;
ems_20	proc
	movzx	eax,word ptr [GFEDX]		; Get handle
	call	gethandleaddr			;
	jc	short ems20out			; Error if none
	GETFRAME GFEDI,GFES,ESI			; Get the name buffer
	mov	ecx,8				; count is 8 bytes
	mov	al,[GFEAX]			; Get function
	cmp	al,2				; only 0 & 1 allowed
	jnc	ems15_err			;
	or	al,al				; 0 is set
	jz	getname				;
setname:
	mov	al,fs:[edi]                     ; Move a byte to handle
	mov	fs:[esi + HANDLE.HNAME],al	;
	inc	esi				;
	inc	edi				;
	loop	setname				; loop till done
	sub	ah,ah				; no errors
ems20out:
	ret
getname:
	mov	al,fs:[esi + HANDLE.HNAME]	; Move a byte to buffer
	mov	fs:[edi],al			;
	inc	esi				;
	inc	edi				;
	loop	getname				; Loop till done
	sub	ah,ah				; no errors
	ret
ems_20	endp
;
; HAndle dir & misc -21
;
ems_21	proc
	movzx	eax,byte ptr [GFEAX]		; get subfunc
	cmp	al,3				; must be 0 -2
	jnc	ems15_err			; Error if not
	jmp	cs:[eax*4 + func21tab]		; dispatch
;
; subfunction 00 - get handle dir
;
ems_2100:
	GETFRAME GFEDI,GFES,EDI			; Point to dest dize
	push	es				; ES = absolute
	push	fs
	pop	es
	sub	eax,eax				; number = 0
	sub	ebx,ebx				; active handles = 0
	mov	esi,[handtab]			; Get handle tab
ems_2100_1:
	bt	fs:[esi + HANDLE.PAGECOUNT],EMS_ALLOCATED ; See if anything here
	jnc	short nothere			; Branch if not
	inc	ebx				; inc active handles
	stosw					; Save number
	mov	ecx,2
	push	esi				; Move name
	lea	esi,[esi + HANDLE.HNAME]	;
	db	064h				; FS:
	rep	movsd				;
	pop	esi				;
nothere:			
	inc	al              		; Next handle entry
	add	esi,type(HANDLE)		;
	cmp	al,EMS_HANDLES			;
	jc	short ems_2100_1		; loop till done
	mov	[GFEAX],bl			; save number of handles in table
	pop	es
	sub	ah,ah				; no errors
ems21out:
	ret
;
; Subfunction 1 - find named handle
;
ems_2101:
	GETFRAME GFEDI,GFDS,EDI			; get name pos
	push	edi				;
	sub	al,al				; al = 0
	push	es				; Switch ES to abs seg
	push	fs
	pop	es
	mov	ecx,8				; Check for a null name
	repe	scasb				;
	or	ecx,ecx				;
	mov	ah,EMSC_NAMEXISTS    		; Err if null nme
	pop	es				;
	pop	edi				;
	jz	short ems21out			;
	push	es                              ; Switch ES to abs seg again
	push	fs				;
	pop	es				;
	sub	eax,eax				; handle num = 0
	mov	esi,[handtab]			; esi = handle tab
ems_2101_1:
	bt	fs:[esi+HANDLE.PAGECOUNT],EMS_ALLOCATED ; Branch if not allocated
	jnz	short next2101			;
	push	edi				; Save name pos
	push	esi				; Get handle name pos
	lea	esi,[esi+HANDLE.HNAME]		;
	mov	ecx,8				; Compare the two
	db	064h				;
	rep	cmpsb				;
	pop	esi				; Restore handle pos
	pop	edi				; restore namepos
	jz	short namefound			; branch if match
next2101:
	add	esi,type(handle)		; Next handle
	inc	al				;
	cmp	al,EMS_HANDLES			;
	jc	ems_2101_1			; Loop till done
	pop	es
	mov	ah,EMSC_NAMENOTFOUND		; Error- name not found
	jmp	short ems21out			;
namefound:
	pop	es				;
	mov	word ptr [GFEDX],ax		; Save handle numbe in DX
	sub	ah,ah				; no errors
	ret
;
; Subfunction 2 - get max handle count
;
	
ems_2102:
	mov	word ptr [GFEBX],EMS_HANDLES	; Save count
	sub	ah,ah				; No errors
	ret					;
ems_21	endp
;
; Alter page map and jump - 22
;
ems_22	proc
	GETFRAME GFESI,GFDS,esi			; Get jump data tab
	movzx	ecx,byte ptr [esi+4]		; Anything to map
	or	ecx,ecx
	jz	short ems22jmp			; no- just jump
	movzx	edx,word ptr [GFEDX]		; Else get handle address
	call	gethandleaddr			;
	jc	short ems22out			; Get out on err
	push	esi				; Save jump tab
	GETFRAMEFS esi+5,esi+7,ebx		; Get map array into esi
	mov	esi,ebx				;
	mov	al,[GFEAX]			; Function number must be 0 or 1
	cmp	al,2				;
	jnc	ems22_err			; Error if not
	call	mapmultiplepages		; Map the pages
	pop	esi				; Restore jump tab ptr
	jc	ems22out			; Get out on error
ems22jmp:
	mov	edi,fs:[esi]			; Get branch address
	mov	[GFEIP],di			; Save it in stack image
	shr	edi,16				;
	mov	[GFCS],di			;
	SSADD	GFESP,6				; Release the int67 stuff off the user stack
ems22ok:
	sub	ah,ah				; No errors
ems22out:
	ret
ems22_err:
	pop	esi
	jmp	ems15_err
ems_22	endp
;
; Get map function for call
;
getphysarray	proc
	mov	dl,al				; Function to dl
getphysarray2:	
	or	dl,dl				; See if is seg
	jnz	physseg				; Yep, branch
	push	ecx
	mov	ecx,[segentries]		; Else get seg entries & tab
	push	esi				; Save pos in new buffer
	mov	esi,[segtab]
physlp:
	mov	eax,fs:[esi]			; Get an entry
	add	esi,4
	or	eax,eax				; Loop while 0
	jnz	physlp				;
	cmp	ax,fs:[edi+2]			; Compare phys # agains supplied #
	jz	short physok			; Get out if match
	loop	physlp				; Else loop till done
	pop	esi
	pop	ecx
	stc					; Not found, error
	mov	ah,EMSC_PHYSPAGERANGE		;
	ret
physok:
	movzx	eax,word ptr fs:[esi+2]	  	; Else get seg address
	pop	esi				; restore mew buffer pos
	pop	ecx
	jmp	short physjoin			; join seg code
physseg:
	movzx	eax,word ptr fs:[edi+2]	  	; Get seg address from new
physjoin:
	mov	fs:[esi+2],ax			; Save seg in old
	call	getmappos			; Get map pos
	mov	eax,fs:[eax]			; Convert to phys page # (system)
	sub	eax,[firstfree]			;
	shr	eax,14				;
	mov	fs:[esi],ax			; Save page #
	add	esi,4				; Bump ptrs
	add	edi,4				; 
	loop	getphysarray2                   ; Loop till done
	clc					; no errors
	ret
getphysarray	endp
;
; Alter page map and call - 23
;
ems_23	proc
	mov	al,[GFEAX]			; Get function
	cmp	al,2				;
	jz	ems2302				; Branch if size grab
	GETFRAME GFESI,GFDS,esi                 ; Get map/jump strcuct
	movzx	ecx,byte ptr fs:[esi+4]		; See if anything to map
	or	ecx,ecx				;
	mov	byte ptr fs:[esi+9],0		; Clear map size
	jz	ems23ok				; Branch if nothing to map
	movzx	edx,word ptr [GFEDX]		; Get handle
	call	gethandleaddr			;
	jc	ems23out			; Get out on error
	push	esi				;
	movzx	ecx,byte ptr fs:[esi+4]		; Get count
	mov	byte ptr fs:[esi+9],cl		;
	GETFRAMEFS esi+5, esi+7,edi		; Get new map array
	GETFRAMEFS esi+10,esi+12,ebx		; Get old map array
	mov	esi,ebx				;
	mov	al,[GFEAX]			; Get function
	cmp	al,2				;
	jnc	ems22_err			; Error if not 0 or 1
	push	edx
	call	getphysarray			; Get the old map array
	pop	edx
	jc	ems22_err
	pop	esi				; Get map/jump struct
	push	esi				;
	movzx	ecx,byte ptr fs:[esi+4]		; Pages to map
	GETFRAMEFS esi+5,esi+7,ebx		; Get new map array
	mov	esi,ebx				;
	mov	al,[GFEAX]			; Get function
	call	mapmultiplepages		; Map pages
	pop	esi				;
	jc	ems23out			; Out if errors
	mov	eax,[segentries]		; Set size of map array
	mov	fs:[esi+9],al
	GETFRAMEFS esi,esi+2,edi		; Get control address
	mov	ax,[GFCS]			; Get old CS:EIP
	shl	eax,16				; 
	mov	ax,[GFEIP]			;
	mov	[esi+14],eax			; Save in reserved area
	mov	eax,[restorechain]		; Save restore chain in reserved area
	mov	[esi+18],eax			;
	mov	[restorechain],esi		;
	mov	dword ptr [callbase],edi	; Save control address
	mov	word ptr [GFCS],SEG emscall	; Save call routine for ret
	mov	word ptr [GFEIP],OFFSET emscall	;
	ret					; Wind down and transfer
						; controll to call routine
callrestore:
	mov	esi,[restorechain]		; Get pointer to last jump/call struct
	mov	eax,[esi+18]			; Restore the chain to the previous
	mov	[restorechain],eax		; jump/call struct
	mov	eax,[esi+14]			; Restore user return addrerss
	mov	[GFEIP],ax			;
	shr	eax,16				;
	mov	[GFCS],ax			;
	movzx	ecx,byte ptr [esi+9]		; See if anything mapped
	or	ecx,ecx        			;
	jz	short	ems23ok			; return to caller if not
	GETFRAMEFS esi+10,esi+12,ebx		; get map array
	mov	esi,ebx				;
	sub	edi,edi				;
	call	mapmultiplepages                ; Map the pages in
ems23ok:
	sub	ah,ah
	ret
ems2302:
	mov	ax,10			; Requires 10 bytes on user stack
	mov	[GFEBX],ax		;
	sub	ah,ah			; no errors
ems23out:
	ret
ems_23	endp
;
; Get address of a moveable region
;
getregionaddress	proc
	movzx	eax,word ptr fs:[esi+5]		;  Get seg or page
	shl	eax,4				; Assume segment
	test	byte ptr fs:[esi],0ffh		; See if type = conventional
	jz	short convadr			; Branch if so
	shl	eax,10				; Else convert to page offset
convadr:
	movzx	ecx,word ptr fs:[esi+3]		; Add in init offset
	add	eax,ecx
	ret
getregionaddress	endp
;
; Get a logical block given the absolute address
;
getlogicalblock	proc
	test	byte ptr fs:[esi],0ffh		; See if conventional
	jz	short isconv			; branch if so
	push	ebx				; save regs
	push	ecx
	push	edx
	push	edi
	movzx	ebx,word ptr fs:[esi+5]		; Get initial page
	shl	ebx,14				; Subtract offset
	sub	eax,ebx				; Get offset in pages
	push	eax
	and	eax,03fffh			; on the way, get the move size
	jnz	glb1
	or	eax,4000h
	xchg	eax,[esp]
glb1:
	shr	eax,14
	mov	ecx,eax				; ecx = pages
	movzx	eax,word ptr [esi+1]		; get handle
	call	gethandleaddr			;
	lea	edx,[edi + HANDLE.PAGELIST]	; Search for page 
	call	traverselist			;
	mov	esi,ebx				; esi = page address
	shl	esi,14				;
	push	DS
	push	DSABS
	pop	ds
	add	esi,[firstfree]
	pop	ds
	pop	eax
	pop	edi
	pop	edx
	pop	ecx
	pop	ebx
	ret
isconv:
	mov	esi,eax				; esi = address
	mov	eax,16384			; eax = size
	ret
getlogicalblock	endp
	
;
; Move a region with decremental addressing
;
;
; Only called if overlap with same handle
;
moveregiondown	proc
	std        			; direction = down
	push	ecx			; Save regs
	push	esi			;
	mov	eax,edx			; Get dest blocak addr
	add	esi,0bh
	call	getlogicalblock		;
	mov	ecx,eax			;
	mov	edi,esi			;
	pop	esi
	push	esi
	mov	eax,ebx			; Get source block addr
	add	esi,04h
	call	getlogicalblock		;
	cmp	ecx,eax			; Limit move to smallest len
	jc	short mg1		;
	mov	ecx,eax			;
mg1:
	mov	eax,[esp+4]		; Limit to orig ecx
	cmp	ecx,eax			;
	jc	short mg2		;
	mov	ecx,eax			;
mg2:
	sub	eax,ecx			; Subtract move length from orig length
	sub	ebx,ecx			; Subtract move length from source &dest
	sub	edx,ecx			;
	rep	movsb			; Do the move
	mov	ecx,eax			; Get new length
	pop	esi			; Restore move table
	pop	eax			; Discard old size
	or	ecx,ecx			; keep going till done
	jnz	moveregiondown		;
	cld				; direction = up
	ret
moveregiondown	endp
;
; Move a region with incremental addressing
;
;
moveregionup	proc
	cld				; Direction = up
	push	ecx			; Save regs
	push	esi
	mov	eax,edx			; Get dest
	add	esi,0bh			;
	call	getlogicalblock		;
	mov	ecx,eax			;
	mov	edi,esi			; to edi
	pop	esi			;
	push	esi                     ;
	mov	eax,ebx                 ; Get source address
	add	esi,04h			;
	call	getlogicalblock		;
	cmp	ecx,eax			; Limit to smallest size
	jc	short mgu1		;
	mov	ecx,eax			;
mgu1:
	mov	eax,[esp+4]		; Get orig size
	cmp	ecx,eax 		; Limit to this
	jc	short mgu2		;
	mov	ecx,eax			;
mgu2:
	sub	eax,ecx			; Get new size
	add	ebx,ecx			; Get new block poses
	add	edx,ecx			;
	rep	movsb			; move block
	mov	ecx,eax			; Get new size
	pop	esi			; Restore table
	pop	eax			; Discard old size
	or	ecx,ecx			; Loop till done
	jnz	moveregionup		;
	ret
moveregionup	endp

;
; XCHG two regions
;
excgregion	proc
	cld         			; Direction = up
	push	ecx			; Save regs
	push	esi
	mov	eax,edx			; Get dest address
	add	esi,0bh			;
	call	getlogicalblock		;
	mov	ecx,eax			;
	mov	edi,esi			; to edi
	pop	esi			;
	push	esi			;
	mov	eax,ebx			; Get source address
	add	esi,04h			;
	call	getlogicalblock		;
	cmp	ecx,eax			; Limit to smallest size
	jc	short xg1		;
	mov	ecx,eax			;
xg1:
	mov	eax,[esp+4]		; Limit to orig len
	cmp	ecx,eax			;
	jc	short xg2
	mov	ecx,eax
xg2:
	sub	eax,ecx			; New len
	add	ebx,ecx			; New positions
	add	edx,ecx			;
	push	eax			; Save new size
xg3:
	mov	al,[edi]		; Xchg a byte
	movsb				;
	mov	[esi-1],al		;
	loop	xg3			;
	pop	ecx			; Restore new size
	pop	esi			; restore table
	pop	eax			; Discare old size
	or	ecx,ecx			; Continue till done
	jnz	moveregionup		;
	ret
excgregion	endp
	
;
; Move,xchng memory - 24
;
ems_24	proc
	mov	al,[GFEAX]		; Get function
	cmp	al,2			; Error if too big
	jnc	EMS15_ERR		;
	GETFRAME GFESI,GFDS,esi		; Get parameter block
	mov	eax,fs:[esi]		; Get size
	cmp	eax,100000h		; Must be 1MB or less
	jbe	sizeok			;
	mov	ah,EMSC_REGIONTOOBIG	; Else error
ems24out:
	ret
sizeok:
	mov	bl,[esi+4]		; Get source type
	cmp	bl,2			; Error if too big
	mov	ah,EMSC_UNDEFMEMTYPE	;
	jnc	ems24out		;
	or	bl,bl			;
	jz	short mto1		; Branch if conventional source
	movzx	eax,word ptr fs:[esi+7]	; Get init offset
	cmp	eax,EMS_PAGESIZE	; Error if greater than page size
	mov	ah,EMSC_OUTSIDEPAGE	;
	jnc	ems24out		;
	mov	ax,fs:[esi+5]		; Get source handle
	call	gethandleaddr		;
	jc	ems24out		; Err if none
	movzx	eax,word ptr fs:[esi+9]	; Get source page
	mov	ebx,fs:[esi]		; Bytes to be moved
	movzx	ecx,word ptr fs:[esi+7]	; Source offset
	add	ebx,ecx			; Final offset in last page
	dec	ebx
	shr	ebx,14			; Page number of last page
	add	eax,ebx			; 
mto1ok:
	btr	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED
	cmp	ax,fs:[edi+HANDLE.PAGECOUNT]
	pushfd
	bts	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED
	popfd
	mov	ah,EMSC_NOLOGICALPAGE
	jnc	ems24out
mto1:
	mov	bl,[esi+0bh]		; Get dest type	
	cmp	bl,2			; Error if too big
	mov	ah,EMSC_UNDEFMEMTYPE
	jnc	ems24out
	or	bl,bl			; Branch if conventional
	jz	short memtypeok
	movzx	eax,word ptr fs:[esi+0eh]; Get init offset
	cmp	eax,EMS_PAGESIZE	; See if outside page size
	mov	ah,EMSC_OUTSIDEPAGE	; Get out if so
	jnc	ems24out		;
	mov	ax,fs:[esi+0ch]         ; Verify dest handle
	call	gethandleaddr		;
	jc	ems24out		;
	movzx	eax,word ptr fs:[esi+10h]; Get dest page
	mov	ebx,fs:[esi]		; Get bytes to move
	movzx	ecx,word ptr fs:[esi+0eh]; Get dest offset
	add	ebx,ecx			; Last byte in last page
	dec	ebx			;
	shr	ebx,14			; Calculate last page
	add	eax,ebx			;
	btr	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED
	cmp	ax,fs:[edi+HANDLE.PAGECOUNT]
	pushfd
	bts	fs:[edi+HANDLE.PAGECOUNT],EMS_ALLOCATED
	popfd
	mov	ah,EMSC_NOLOGICALPAGE
	jnc	ems24out
memtypeok:	
	mov	al,[GFEAX]		; Check for move/xchange
	cmp	al,2			;
	jnc	EMS15_ERR		; Err if neither
	or	al,al			;
	jnz	exchange		; branch if exchange
	push	ds
	push	es
	push	fs			; Switch to abs data
	pop	es
	push	fs
	pop	ds
	push	esi			; Get source
	add	esi,4
	call	getregionaddress
	mov	ebx,eax
	pop	esi
	push	esi			; Get dest address
	add	esi,11
	call	getregionaddress
	pop	esi
	mov	edx,eax
	mov	ecx,[esi]		; Get len
	mov	al,[esi+4]		; if different mem types
	cmp	al,[esi+0bh]		;
	jnz	moveadd			; Do a move up
	or	al,al			; See if mode is handle to handle
	jz	short overlapmove	; Nope, do overlap move in conv mem
	mov	ax,[esi+5]		; Else see if handles are same
	cmp	ax,[esi+0ch]		;
	jnz	moveadd			; then branch if not
overlapmove:
	cmp	ebx,edx			; If source >= dest
	jnc	moveadd			; Branch to move up routine
	push	ebx
	push	edx
	add	ebx,ecx			; Calculate end of move
	dec	ebx			;
	add	edx,ecx			;
	dec	edx			;
	call	moveregiondown		; Do downward move
checkover:
	pop	edx
	pop	ebx
	cmp	ebx,edx			; Check for overlap
	mov	ah,EMSC_CEREGIONOVERLAP	; Err if so
	ja	noverlap		;
	sub	ah,ah			; Else no error
noverlap:
	pop	es
	pop	ds
	ret
; If we get here, we have conventional access or different handles
moveadd:
	push	edx
	push	ebx
	call	moveregionup
	jmp	checkover
exchange:
	push	esi			; Get source
	add	esi,4
	call	getregionaddress
	mov	ebx,eax
	pop	esi
	push	esi			; Get dest address
	add	esi,11
	call	getregionaddress
	pop	esi
	mov	edx,eax
	mov	ecx,fs:[esi]		; Get len
	mov	al,fs:[esi+4]		; If differnt mem types
	cmp	al,fs:[esi+0bh]    	;
	jnz	short xchgok		; Do exchange
	or	al,al			; Else check for conv
	jz	short xchgover		; If so, check for overlap
	mov	ax,fs:[esi+5]		; Else if different handles
	cmp	ax,fs:[esi+0ch]		;
	jnz	short xchgok		; Do exchange
xchgover:
	push	ebx
	add	ebx,fs:[esi]		; See if source + len < dest
	dec	ebx
	cmp	ebx,ecx			;
	pop	ebx			; Restore source
	jbe	short xchgok		; Ok to move if dest > source + len
	push	ecx
	add	ecx,fs:[esi]		; Else see if dest + len < source
	dec	ecx
	cmp	ecx,ebx
	pop	ecx
	jc	short xchgok		; ok if dest + len < source
	mov	ah,EMSC_CEREGIONOVERLAP	; Else overlap, no exchange
	ret
xchgok:
	push	es			; Switch to abs
	push	ds
	push	fs
	pop	es
	push	fs
	pop	ds
	call	excgregion		; Exchange
	sub	ah,ah			; No errors
	pop	ds
	pop	es
	ret
	
ems_24	endp
;
; Get mappable address array -25
;
ems_25	proc
	mov	al,[GFEAX]		; Get function
	cmp	al,2
	jnc	EMS15_ERR		; Error if too big
	or	al,al			; Gheck for size func
	jnz	getmapsize		; branch if so
	GETFRAME GFEDI,GFES,edi		; Get table address
	mov	esi,[segtab]		; Get seg table
	mov	ecx,BACKFILLPAGES	; Move all backfill pages
	rep	movsd			;
	mov	ecx,STDENTRIES		; Number of entries in standard table
ems25lp:
	mov	eax,fs:[esi]		; Get next entry
	add	esi,4
	or	eax,eax			; Loop while 0
	jnz	short ems25lp		;
	mov	fs:[edi],eax		; Else save to dest
	add	edi,4
	loop	ems25lp			; Loop till all got
	sub	ah,ah			; no errors
	ret	
getmapsize:
	mov	ecx,[segentries]	; Get entries in table
	mov	[GFECX],ecx		; to ECX
	sub	ah,ah			; no errors
	ret
ems_25	endp
;
; Hardware & raw pages - 26
;
ems_26	proc
	mov	al,[GFEAX]		; Get function
	cmp	al,2			; Err if too big
	jnc	EMS15_ERR		;
	or	al,al			; Check for raw page alloc
	jnz	ems_03			; Do page alloc if so
	GETFRAME GFEDI,GFES,EDI		; Get hardware table
	mov	word ptr fs:[edi],EMS_PAGESIZE*400h/16 ; Size of page in paragraphs
	mov	word ptr fs:[edi+2],EMS_MAPS-1 ; Alternate map sets available
	mov	word ptr fs:[edi + 4],(MAPSIZE)/EMS_MAPS ; Bytes to save map
	mov	word ptr fs:[edi+6],0	; DMA not supported
	mov	word ptr fs:[edi+8],0	; DMA not supported
	sub	ah,ah
	ret
ems_26	endp
;
; Allocate pages -27
;
ems_27	proc
	mov	al,[GFEAX]		; Get function
	cmp	al,2			; See if standard/raw
	jnc	EMS15_ERR		; Error if not
	jmp	ems_04			; Else allocate the pages
ems_27	endp
;
; Read a map
;
readmap	proc
	mov	esi,[segtab]		; Get seg tab
	mov	edi,[maptabs]		; Get map tabs
	mov	ebx,[PageTables]	; Get page tables
	add	ebx,1000h		; Bump past system table
	push	ds 			; Switch to abs seg
	push	es
	push	DSABS
	pop	es
	push	DSABS
	pop	ds
	movzx	eax,al
	mov	ecx,MAPENTRIES
	mul	ecx
	shl	eax,4
iml:
	mov	dword ptr [edi],0	; Assume unmapped
	test	word ptr [esi + MAPABLE.MSEG],-1 ; See if mapped
	jz	notmapped2		; Skip if not
	movzx	eax,word ptr [esi + MAPABLE.MSEG] ; Get segment
	shr	eax,8			; Translate to page table entry
	mov	eax,[ebx+eax*4]		; Get entry
	mov	[edi],eax		; Save map value
notmapped2:
	add	esi,type(MAPABLE)	; Point to next table location
	add	edi,4			;
	loop	iml			;
	pop	es
	pop	ds
	ret
readmap	endp
;
; Write a map
;
writemap	proc
	mov	esi,[segtab]		; Get seg tab
	mov	edi,[maptabs]		; Get map tabs
	mov	ebx,[PageTables]	; Get page tables
	add	ebx,1000h		; Bump past system table
	push	ds 			; Switch to abs seg
	push	es
	push	DSABS
	pop	es
	push	DSABS
	pop	ds
	movzx	eax,al
	mov	ecx,MAPENTRIES
	mul	ecx
	shl	eax,4
iml2:
	test	word ptr [esi + MAPABLE.MSEG],-1 ; See if mapped
	jz	notmapped3		; Skip if not
	movzx	eax,word ptr [esi + MAPABLE.MSEG] ; Get segment
	shr	eax,8			; Translate to page table entry
	mov	edx,[edi]		; Get map value
	mov	[ebx+eax*4],edx		; Save entry
notmapped3:
	add	esi,type(MAPABLE)	; Point to next table location
	add	edi,4			;
	loop	iml2			;
	pop	es
	pop	ds
	ret
writemap	endp
;
; Get Alternate map registers
;
ems_28	proc
	bt	[mapflags],OS_DENIED	; See if os denied
	jnc	altmapok		; branch if not
	mov	ah,EMSC_OSDENIED	; Else return error
	ret
altmapok:
	movzx	eax,byte ptr [GFEAX]	; Get function
	cmp	al,5			; Err if too big
	jnc	EMS15_ERR		;
	jmp	cs:[eax*4+func28tab]	; branch on function
ems_2800:
	mov	eax,[mapnum]		; Get map number
	or	al,al			;
	jnz	noxfer			; If != 0 no context returned
	call	readmap			; Read the map
	GETFRAME GFEDI,GFES,edi		; Get dest frame
	mov	esi,[maptabs]		; Get map table 0
	mov	ecx,MAPENTRIES		; Count to xfer
	push	ds			; Switch to abs
	push	es
	push	fs
	pop	es
	push	fs
	pop	ds
	rep	movsd			; do move
	pop	es
	pop	ds
noxfer:
	mov	ebx,[mapnum]		; Return map number
	mov	[GFEBX],bl		;
	sub	ah,ah			; no error
	ret
ems_2801:
	movzx	eax,byte ptr [GFEBX]	; Get set number
	or	al,al			;
	jnz	short justset		; if nz, just to xfer
	GETFRAME GFEDI,GFES, esi	; Else get source
	mov	edi,[maptabs]		; Map table 0
	mov	ecx,MAPENTRIES		; Entries
	push	ds			; Switch to abs
	push	es
	push	fs
	pop	es
	push	fs
	pop	ds
	rep	movsd			; do move
	pop	es
	pop	ds
justset:
	cmp	al,EMS_MAPS		; See if new map in range
	jc	short jsok		; OK if so
udmp:
	mov	ah,EMSC_UNDEFMAP	; Else undefined
	ret
jsok:
	bt	[mapflags],eax		; See if allocated
	xchg	eax,[mapnum]		; Switch to new map in case not
	jc	udmp			; Error if not allocated
	xchg	eax,[mapnum]		; Else get new map back
	push	eax			;
	mov	eax,[mapnum]		; Get old map number
	or	eax,eax			; if is 0 don't read it
	jz	short noread		;
	call	readmap			; Read it
noread:
	pop	eax
	mov	[mapnum],eax		; Write new map
	call	writemap		;
	sub	ah,ah			; No errors
	ret
ems_2802:
	mov	eax,MAPENTRIES*4	; Size of a map table
	mov	word ptr [GFEDX],ax	; in dx
	sub	ah,ah			; no errors
	ret
ems_2803:
	bsf	eax,[mapflags]		; See if any sets left
	cmp	al,8			;
	jc	short gotone		; Yes, got it
	mov	ah,EMSC_ALLOCMAP	;
	ret
gotone:
	btr	[mapflags],eax		; Clear the bit
	mov	[GFEBX],al		; Save the number for caller
	call	readmap			; Init the map
	sub	ah,ah			; no errors
	ret
ems_2804:
	movzx	eax,byte ptr [GFEBX]	; Get map number
	cmp	al,EMS_MAPS		; See if valid
	jnc	udmp			; Err if not
	or	al,al			; See if 0
	jz	udmp			; Err if so
	bts	[mapflags],eax		; Deallocate
	jc	udmp			; Error if already deallocated
	sub	ah,ah			; no errors
	ret
ems_28	endp
;
; Warm boot - 29
;
ems_29	proc
	sub	ah,ah			; warm boot done automatically
lastret:
	ret
ems_29	endp
;
; OS functions - 30
;
ems_30	proc
	bt	[mapflags],OS_INPROGRESS	; See if OS in progress
	jnc	short funcok			; branch if not
	movzx	eax,word ptr [GFEBX]		; Else get key
	shl	eax,16
	mov	ax,word ptr [GFECX]
	cmp	eax,[oskey]			; Check key
	mov	ah,EMSC_OSDENIED		; Err if invalid
	jnz	short lastret			;
funcok:
	movzx	eax,byte ptr [GFEAX]		; Get function
	cmp	al,3				;
	jnc	EMS15_ERR			; Err if too big
	jmp	cs:[eax*4 + func30tab]		; branch to function
ems_3000:
	btr	[mapflags],OS_DENIED		; os enable
	jmp	short retkey			;
ems_3001:
	bts	[mapflags],OS_DENIED		; os disable
retkey:
	bts	[MAPFLAGS],OS_INPROGRESS	; in progress
	jc	short nokey			; exit if already in progress
	mov	eax,fs:[TIMER]			; Get new key (from sys timer)
	mov	[oskey],eax			; save key
	mov	[GFECX],ax			; Give it to caller
	shr	ax,16				;
	mov	[GFEBX],ax			;
nokey:
	sub	ah,ah				; no errors
	ret
	
ems_3002:
	btr	[mapflags],OS_INPROGRESS
	btr	[mapflags],OS_DENIED
	sub	ah,ah
	ret
ems_30	endp
seg386	ends
	end