;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; Boot.asm
;
; Function: Put us in protected mode with paging enabled
;   Also run us back to real mode if necessary
;

    .386P

include gdt.asi
include segs.asi
include tss.asi

	public MemBase, MemFree, TSSBase, tGDT, endprotection, TOS
	public ProtectedMode, PageTables,TssBase,MapBase,MemBase,MemFree
	public tGDT, pGDT, zero

SEG8086 segment
	extrn xmsrundown: PROC
	extrn init386regs: PROC
	extrn ReleaseEMSMem: PROC
	extrn RebootCheck : PROC
SEG8086 ends
DiscardSeg segment
	extrn checksys : PROC
DiscardSeg ends
SEG386	segment
	extrn bootv86: proc, pic386: proc, pic8086: proc
	extrn int15hinit: PROC, int15hrundown: PROC
	extrn mapa20: PROC, initReboot : PROC, ems_init : PROC
SEG386	ends
;---------------------------------------------------------------------
; Various symbols used to make things more readable.
;
;---------------------------------------------------------------------

NUMGDT  = 8     ; Number of entries in GDT.

IDTSIZE = 800h
GDTSIZE = NUMGDT*8
;---------------------------------------------------------------------
; Define a 1K entry stack.
;
;---------------------------------------------------------------------

StackSeg	SEGMENT
	db	2048 DUP (?)
tos LABEL   BYTE
StackSeg	ENDS


;---------------------------------------------------------------------
; IDT and GDT are first so they will be DWORD aligned
;
;---------------------------------------------------------------------
SEG386data SEGMENT
	extrn	emuIDT : fword
message	db	"emu86 unloaded",13,10,'$'
	align
	
;
; The constructed GDT
;
tGDT    db  8 DUP(-1)   ; Protected mode GDT
    db  GDTSIZE-8 DUP(0)
;
; The value to load with the lgdt reg
; 
pGDT    dw  GDTSIZE-1   ; Protected mode GDT register
gdtadr  dd  offset dgroup:tGDT
;
;
; The Real mode idt
;
rIDT	dw	3ffh
	dd	0
;
zero        dd  0   ; Offset of Protected mode from absolute zero
;
;
	align
PageTables	dd	00000h
TSSBase		dd	PTSIZE
MapBase		dd	PTSIZE + TSSSIZE
MemBase		dd	PTSIZE + TSSSIZE + MAPSIZE
MemFree		dd	PTSIZE + TSSSIZE + MAPSIZE
;
;---------------------------------------------------------------------
;
; GDT entry definitions
;
;---------------------------------------------------------------------
iGDT    LABEL   WORD
;
; First two entries: base = physical start of program.
;    limit = entire address range ( 4G)
;    These are 32 bit segments
;    They are present, memory class descriptors
;    one is a read-exec code seg, the other a read-write data seg
;
    GDTENTRY    0,0fffffh,0c09Ah,gdtZeroOffset  ; 386 code
    GDTENTRY    0,0fffffh,0c092H,gdtZeroOffset  ; 386 data
;
; Next two entries: base = physical start of program
;    limit = 64K
;    These are 16-bit segments
;    One is a read-exec code seg, the other a read-write data seg
;
    GDTENTRY    0,00ffffh,9Ah,gdtZeroOffset ; 8086 code
    GDTENTRY    0,00ffffh,92h,gdtZeroOffset ; 8086 data
;
; Next entrie: base = physical 0
;   Limit = 4G
;   It's a 32-bit segment
;   It's a read-write data segment
;   Note that zer0-offsetting is not applied
    GDTENTRY    0,0fffffh,0c092h,0	   ; Absolute
;
; Next entry: Task data segment
;   Limit = TSSSIZE
;   It's a read/write data seg
;   zero-offsetting is not applied, address relative to ABSDATA
;   will be filled in via startupcode
;
    GDTENTRY	0,TSSSIZE,0089h, gdtLastEntry
SEG386data ends

;---------------------------------------------------------------------
; Main program entry point. The first thing we do is switch to 
; protected mode. Then we call the main control program. If and when 
; the control program returns, then we return to real mode and 
; return to our caller.
;
;---------------------------------------------------------------------

seg8086 SEGMENT
    assume cs:DGROUP,ds:DGROUP, ss:StackSeg
bootstrap:
    cld
    cli                         ; Interrupts clear throughout

    mov bx,DGROUP                   ; Set ES=DS=CS=DGROUP
    mov ds,bx
    mov es,bx
    mov [word ptr zero],bx
    shl [zero],4                ; Fix ZERO address
    ;
    ; Make sure it is a 386 with XMS, NO EMS, not in protected mode
    ; Doesn't return if there are any errs
    ; This function gets discarded, don't branch back to the entry point!!!
    ;
    call checksys
    ;
    ; Save user 386 regs
    ;
    call init386regs
    ;
    ; Fixup the GDT with our current location in memory.
    ;
    mov ebx,[zero]              ; Load zero address
    mov dl,[byte ptr zero + 2]  ; Load 64K segment
    add [gdtadr],ebx		; GDT and IDT regs must have a physical value

    mov esi,offset DGROUP:iGDT         ; Load GDT table pointers
    mov edi,offset DGROUP:tGDT + 8

    ;
    ; Create the GDT
    ;
    mov cx,NUMGDT-1
gdtinit:
    lodsw                       ; Get flags
    movsd                       ; Move GDT entry to table
    movsd
    test    ax,gdtZeroOffset    ; Adjust this entry?
    jz  short nooffset          ; No, continue
    add [word ptr di+2-8],bx    ; Else add in the ZERO offset
    add [byte ptr di+4-8],dl    ; to make the segment base address (seg addr 0)
				; be the physical offset of the program
nooffset:
    test    ax,gdtLastEntry
    jnz short endGDT
    loop    gdtinit             ; But don't overflow table
endGDT:

    ; Load the GDT descriptor
    lgdt    [fword ptr pGDT]

    ;
    ; Switch to protected mode.
    ;
    mov ebx,CR0     ; Set protected mode
    inc ebx
    mov CR0,ebx

    ;
    ; Perform an inter-segment jump to our protected mode code. This 
    ; is necessary to ensure that CS is reloaded with a protected 
    ; mode selector. This jump has to be 'hand coded' as it is not 
    ; supported by the assembler because its a very dangerous thing 
    ; to do unless you know what your doing.
    ;
    db  066h        ; Far jump into protected mode
    db  0eah
    dw  SMALL DGROUP:ProtectedMode
    dw  0
    dw  CS386        ; Here we tell it to switch to prot mode seg
seg8086 ends         ; Exit real mode code segment


seg386 SEGMENT
;---------------------------------------------------------------------
; Protected mode start point. When we get here we have to reload all 
; of the selectors to ensure we do not get any protection faults 
; when we use them.
;
;---------------------------------------------------------------------
    assume cs:dgroup,ds:dgroup, ss:dgroup
ProtectedMode   LABEL BYTE
    mov ebx,ss          ; Readjust stack for protected mode
    shl ebx,4
    movzx   esp,sp
    add esp,ebx
    mov bx,DS386        ; Protected mode stack segments
    mov ss,bx
    sub esp,ss:[zero]
    mov ds,bx           ; DS,ES = primary data segment
    mov es,bx
    mov bx,DSABS        ; FS,GS = Absolute zero data segment
    mov fs,bx
    mov gs,bx
    call initpagetables	; Set up page tables
    call pic386		; Set PIC interrupt bases to protected mode vals
    call int15hinit	; Init for int 15h emulation
    call mapa20		; Map the HMA pages appropriately
    call initReboot	; Patch the bios for reboots
    call ems_init	; Init the EMS tables
    ;
    ; Turn paging on
    ; This assumes linear and physical addresses for this program segment
    ; match, i.e. that paging is see-through at these addresses
    ;
    mov eax,[PageTables] ; Set the page directory base register
    mov CR3, eax
    mov ebx,CR0		; Set the paging enable bit to turn paging on
    or ebx,80000000h	;
    mov CR0,ebx
;    mov CR3,eax

    ;
    ; Here we are in protected mode, with a sensible environment
    ; set up in the selectors.
    ;

protection:
    jmp bootv86
endprotection:
    cli
    push DSABS
    pop fs
    push DS386
    pop ds
    push DS386
    pop es
    call pic8086	; Set PIC interrupt bases back to BIOS vals
    call int15hrundown	; Rundown int 15h emulation
    ; 
    ; Turn paging off by resetting the page enable bit
    ; Again, physical and linear addresses must be the same for
    ; this segment of code
    ;
    mov eax,cr0
    and eax,7fffffffh
    mov cr0,eax

    ;
    ; Prepare to return to real mode.
    ;

    ;
    ; Reload our selectors with real mode compatible segment values.
    ;
    mov esp,offset DGROUP:TOS
    mov ebx,DS8086      ; Real mode compatible data segments
    mov ds,ebx
    mov es,ebx
    mov fs,ebx
    mov gs,ebx
    mov ss,ebx

    ;
    ; Perform an inter-segment jump to our 16 bit protected mode 
    ; code. This is necessary to ensure that CS is reloaded with 
    ; a 16 bit segment selector. This jump has to be 'hand coded' as 
    ; it is not supported by the assembler because its a very 
    ; dangerous thing to do unless you know what your doing.
    ;
    db  0eah        ; Jump to 8086 compatible segment
    dw  SMALL DGROUP:RealMode1
    dw  0
    dw  CS8086      ; Switch to real mode compatible seg
    ;
    ; Switch to Real mode.
    ;
RealMode1:
    mov ebx,CR0     ; Back to real mode
    dec ebx
    mov CR0,ebx

    ;
    ; Perform an inter-segment jump to our real mode code. This is
    ; necessary to ensure that CS is reloaded with a real mode 
    ; segment value. This jump has to be 'hand coded' as it is 
    ; not supported by the assembler because its a very dangerous 
    ; thing to do unless you know what your doing.
    ;
    db  0eah        ; Load CS with real mode segment value
    dw  DGROUP:RealMode2
    dw  dgroup
seg386 ends

seg8086 segment
    assume cs:dgroup,ds:dgroup, ss:StackSeg

RealMode2:
    ;
    ; Restore our segment registers to GS=FS=ES=DS=CS=DGROUP
    ;
    mov bx,dgroup
    mov ds,bx
    mov es,bx
    mov fs,bx
    mov gs,bx
    mov ss,bx
    lidt fword ptr [rIDT]
    sti
    ;
    ; Here we are back in Real mode with our segment registers set 
    ; back to something sensible.
    ;
    ; Rundown the XMS compatibility
    ;
    call rebootcheck
    call xmsrundown
    call ReleaseEMSMem
    mov edx,offset dgroup:message
    mov ah,9
    int 21h
    mov ah,04ch
    int 21h
endprog:
seg8086 ends
seg386 segment
;
; Create all page tables
; We are mapping lower 16MB on a see-through basis.  You really only have
; to make sure that the routine that turns paging on and off is see-through
; although it is convenient to leave more than that see-through so you
; can access common data.  This paging routine is going to leave the
; video memory mapped in two places; you can access it either at 0a0000h
; or at 80000000h.
;
initpagetables proc
    push [PageTables]	; Page table addr on stack
    mov ebp,esp
    assume ds:absdata, es:absdata
    push ds
    push es
    push fs
    pop ds 		; Switch to the absolute data segment
    push fs
    pop es
    ;
    ; First create the page tables that will allow 'see-through'
    ; access to the lower MB
    ;
    mov edi,[ebp]
    add edi,4096
    ; The lower three bits of each page table entry are:
    ;  bit 0 = 1 means the table is accessible
    ;  bit 2 = 1 means it is a writable page
    ;  bit 3 = 1 means it is accessable at any priviledge level
    mov eax, 16 * 1024 * 1024 + 7-4096; Physical address 16MB-4096
                                      ; + lower 3 bits set
    mov ecx, 1024 * 4	; 4 tables of 1024 entries each of which
			; allocates 4096 bytes is 16 MB
fill16mb:
    mov [edi+ecx*4-4],eax; Fill in the table entry
    sub eax,4096	; Move to offset of next lower page
    loop fill16mb
    ;
    ; Now create the page directory.
    ;  The first 4 entries will refer to the 4 pages which hold our
    ;  16MB see-through paging.
    ;
    ; Before we fill it in we are going to invalidate everything in it
    ;
    mov edi,[ebp]
    mov ecx,1024
    mov eax, 0fffffffeh
    rep stosd
    ;
    mov eax,[ebp]
    mov edi,eax
    add eax,4096
    or al,7		; Add in the page table mode bits
    mov [edi],eax
    add eax,4096
    mov [edi+4],eax
    add eax,4096
    mov [edi+8],eax
    add eax,4096
    mov [edi+12],eax
    pop es
    pop ds
    pop eax
    ret
    
initpagetables endp
seg386 ends

    end bootstrap