;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
;
; xmsctl.asm
;
; function: to fix the XMS system to be EMS compatible
;   Currently only overrides the a20 line support
;
;   This module does NOT check XMS return vals for validity.  Maybe later
;
	.386p

include segs.asi
include xmsctl.asi
include emuinter.asi
include tss.asi

	public	xmsboot,xmsrundown, mapa20, xmsctl
	public	GrabEMSMem, ReleaseEMSMem

seg386data	SEGMENT
	extrn PageTables : DWORD,TSSBase : DWORD, MemBase : DWORD
	extrn MapBase: DWORD, MemFree: DWORD
xmsovrptr	dd	0		; Pointer to the place we put our jmp
xmsvector	dd	0		; Place to jump to
xmsbase		dd	0		; Call here to activate entire XMS chain
xmsoldjmp	dw	0		; old jump value
a20state	dw	A20_GLBL	; Assume A20 global enable
					; We are assuming HMA not allocated!
embhandle	dw	0		; XMS handle
seg386data	ENDS


seg8086	SEGMENT
	assume	cs:DGROUP, ds: DGROUP
;
; Table of XMS functions we hook
;
xmstab	label	word
	dw	dgroup:g_hma_alloc,dgroup:g_hma_free
	dw	dgroup:g_a20on, dgroup:g_a20off
	dw	dgroup:l_a20on, dgroup:l_a20off, dgroup:q_a20
;
; New XMS control func
;
xmsctl	proc	far
	jmp	short silly		; These next few lines are for XMS
	nop				; compability
	nop
	nop
silly:
	pushf
	push	ds			; Save regs
	push	ax
	push	bx
	push	DGROUP			; DS = our dgroup
	pop	ds
	mov	bl,ah			; Bx = function num
	sub	bh,bh			;
	sub	bl,XMS_HMAALLOC		; See if has at least min func
	jc	short chain		; chain to old handler if not
	cmp	bl,XMS_QUERYA20-XMS_HMAALLOC	; See if in function set
	ja	short chain		; Chain if not
	shl	bx,1			; Else make function a word
	jmp	[bx+xmstab]		; Take function
chain:
	pop	bx			; Come here to chain to old XMS handler
	pop	ax			;
	pop	ds			;
	popf
	jmp	cs:[xmsvector]		;
g_hma_alloc:
	bts	[a20state],HMA_ALLOC	; Mark HMA as allocated
	jmp	chain			; Chain to old handler
g_hma_free:
	btr	[a20state],HMA_ALLOC	; Mark HMA as deallocated
	jmp	chain			; Chain to old handler
newa20:
	mov	al,EMU_MAPA20		; Tell protected mode to remap A20
	out	CONTROLPORT,al		;
	mov	al,EMUP_GENERAL		;
	out	DATAPORT,al		;
	mov	ax,XMS_NOERR		; Get out, no errs
	pop	bx			; Restore BX
	sub	bl,bl			; bl = no error
	add	sp,2			; Returning AX
	pop	ds			; restore DS
	popf
	ret
g_a20on:
	bts	[A20state],A20_GLBL	; Else enable
	jmp	newa20
l_a20on:
	bts	[a20state],A20_LOCAL	; Local enable, just enable
	jmp	newa20
g_a20off:
	btr	[A20state],A20_GLBL	; Else disable
	jmp	newa20
l_a20off:
	btr	[a20state],A20_LOCAL	; Local disable, just disable
	jmp	newa20
q_a20:
	sub	ax,ax			; Assume not
	sub	bl,bl			; No errors
	test	[a20state],(1 shl a20_GLBL) or (1 shl A20_LOCAL) ; Check for enable
	jz	q_a20ok			; No, proceed
	inc	ah			; Oops, enabled
q_a20ok:
	add	sp,4			; Returning AX & BX
	pop	ds			; pop regs
	popf
	ret				; return to caller
xmsctl	endp
;
; Chain us into the XMS chain if it exists, and global enable the A20
; We will fake A20 support with paging.  Note that the HMA area is
; assumed to be free at execution of this routine.  We will sync
; with HMA usage at the next HMA free or alloc command.
;
xmsboot	proc
	push	es
	mov	ax,XMSGETHOOK		; Get base XMS vector
	int	MULTIPLEX
	mov	word ptr [xmsbase],bx  	; Save XMS base address for calling
	mov	word ptr [xmsbase+2],es	;
	push	bx
	mov	ah,XMS_QUERYA20		; Get A20 state.  There's no provision
	call	[xmsbase]		; for telling whether this is global
	or	ah,ah			; or local so we assume global
	jnz	short a20on			;
	btr	[a20state],A20_GLBL	; Not enabled
a20on:
	pop	bx
lp:
	cmp	byte ptr es:[BX],SJUMP	; If is a short jump we install here
	jz	short dohook			;
	les	bx,es:[BX+1]		; Else check next in vector list
	jmp	lp
dohook:
	push	bx
	mov	ah,XMS_A20GLBLEN	; Enable the A20 line
	call	[xmsbase]		; 
	pop	bx
	dec	ax
	jnz	bada20			; Get out if error
	mov	word ptr [xmsovrptr],bx	; Save a pointer to this place for rundown
	mov	word ptr [xmsovrptr+2],es ;
	mov	ax,es:[bx]		; Get the jump for rundown
	mov	[xmsoldjmp],ax		;
	mov	al,ah			; Now calculate absolute value
	cbw				; of address from offset
	add	ax,bx			;
	inc	ax
	inc	ax
	mov	word ptr [xmsvector],ax   ; Save address of old XMS vector
	mov	word ptr [xmsvector+2],es ;
	mov	byte ptr es:[bx],LJUMP		; Hook into the chain
	mov	word ptr es:[bx+1],offset xmsctl;
	mov	word ptr es:[bx+3],cs		;
	pop	es
	clc				; No errors
	ret
bada20:
	pop	es
	stc
	ret
xmsboot	endp
;
; Allocate the EMS mem from XMS and map the varius data structs we need in
;
GrabEMSMem	proc
	mov	edx,MEMSIZE		; Memsize, a constant for now
	shr	edx,10			; In KB
	mov	ah,XMS_ALLOCATEBLOCK	; Allocate the block
	call	[xmsbase]		; 
	dec	ax			; Get out on error
	jnz	badalloc		;
	mov	[embhandle],dx		; Save handle
	mov	ah,XMS_LOCKBLOCK	; Lock the block
	call	[xmsbase]		;
	dec	ax			; Get out on error
	jnz	badalloc		;
	mov	ax,dx			; Calculate physical address
	shl	eax,16			;
	or	ax,bx			;
	add	[PageTables],eax	; Set up our data tables
	add	[TSSbase],eax		;
	add	[MapBase],eax		;
	add	[MemBase],eax		;
	mov	eax,MEMSIZE		; Set up our memsize var
	sub	eax,[memfree]		;
	mov	[memfree],eax		;
	clc
	ret
badalloc:
	stc
	ret

GrabEMSMem	endp
;
; Deallocate the EMS memory from XMS
;
ReleaseEMSMem	proc
	mov	dx,[embhandle]		; Unlock the block
	mov	ah,XMS_UNLOCKBLOCK	;
	call	[xmsbase]		;
	mov	dx,[embhandle]		; Free the block
	mov	ah,XMS_FREEBLOCK	;
	call	[xmsbase]		;
	ret
ReleaseEMSMem	endp

;
; Unchain us from the XMS chain and reset the global enable
; to its current state
;
xmsrundown	proc

	les	bx,[xmsovrptr]		; Unhook us from the chain
	mov	ax,[xmsoldjmp]		;
	mov	es:[bx],ax		;
	mov	byte ptr es:[bx+2],NNOP		;
	mov	byte ptr es:[bx+3],NNOP		;
	mov	byte ptr es:[bx+4],NNOP		;
	mov	ah,XMS_A20GLBLEN	; Assume global enable
	bt	[a20state],A20_GLBL
	jz	short setglobal
	mov	ah,XMS_A20GLBLDIS	; Nop, disabled
setglobal:
	call	[xmsbase]		; Set it
	mov	ah,XMS_A20LOCALEN	; Assume local enable
	bt	[a20state],A20_GLBL
	jz	short setlocal
	mov	ah,XMS_A20LOCALDIS	; Nop, disabled
setlocal:
	call	[xmsbase]		; Set it
	ret
xmsrundown	endp	
seg8086	ENDS
seg386	SEGMENT
;
; Map the HMA area either to 1MB extended memory or back
; around to the 8086 zero area.  This is how we do A20 compatibility,
; since technically we leave the a20 line on all the time.
; Note that there are 16 bytes at the end which can't be accessed by
; the vm86 program and the EMS system
; cannot use it because it can sometimes be mapped out
;
mapa20	proc
	push	es
	push	DSABS			; ES = absdata
	pop	es
	
	mov	edi,[PageTables]	; Point to first user page table
	mov	esi,edi
	add	edi,1000h		;
	add	edi,400h		; Point to 1 MB mark
	mov	ecx,65536/1000h		; Number of entries to fix
	sub	eax,eax			; Assume a20 off, we map
					; the 1MB mark back around to 0
	test	[a20state],(1 shl a20_GLBL) or (1 shl A20_LOCAL) ; Check for enable
	jz	remap			; Not enabled, do wraparound
	mov	eax,100000h		; Else map to 1MB mark
remap:
	or	al,7			; Make it read/write at any priv level
remap2:
	stosd				; Store an entry
	add	eax,1000h		; Point to next page
	loop	remap2			; Loop till all entries are complete
	mov	CR3,esi			; Flush the TLBs
	pop	es			; Restore es
	ret
mapa20	endp
seg386	ENDS
	end