;
; EMS system implemented by
;
; David Lindauer
;
; gclind01@ulkyvx.louisville.edu
;
; August, 1995 
;
; As part of the FREE-DOS project
;
; emsinit.asm
;   function : initialize EMS and VCPI data structures
;      Note that this implementation of EMS only allows for 31MB extended memory
;      This file ASSUMES structure sizes for SEGTAB
	.386
include segs.asi
include ems.asi
include vcpi.asi

	public	logdir, handtab, segtab, maptabs, firstfree, segentries
	public	freelist, maxpages, freepages, pageframe, ems_init
seg386data	SEGMENT
	extrn 	membase:dword, memfree:dword, PageTables : DWORD
logdir	dd	0				; Logical directory (FAT)
handtab	dd	LOGDIRSIZE			; Handle directory
segtab	dd	LOGDIRSIZE+HANDTABSIZE		; Segment map table
maptabs	dd	LOGDIRSIZE+HANDTABSIZE+SEGTABSIZE ; Alternate maps
firstfree dd	LOGDIRSIZE+HANDTABSIZE+SEGTABSIZE+MAPSIZE ; First free
segentries dd	0				; Number of mapable pages

freelist dd	0				; List of free logical pages
maxpages dd	0				; Max logical pages
freepages dd	0
pageframe dw	0d000h
seg386data	ENDS

seg386	segment
	extrn	readmap : PROC
seg386	ends
seg386discard	segment
	assume	cs:dgroup,ds:dgroup
;
; Init the handle directory
;
init_handles	proc
	mov	edi,[handtab]		; Get position
	assume	ds: DSABS		; Switch to DSABS
	push	ds
	push	DSABS
	pop	ds
	push	edi	
	mov	ecx,EMS_HANDLES		; Number of handles
	sub	eax,eax
ihl:
	mov	[EDI + HANDLE.PAGELIST],0ffffh	; No pagelist
	mov	[EDI + HANDLE.PAGECOUNT],0	; No pages
	mov	dword ptr [edi + HANDLE.hname],eax	; Name = nulls
	mov	dword ptr [edi + HANDLE.hname+4],eax
	mov	dword ptr [edi + HANDLE.MAPS],eax	; Page frame map = nulls
	add	edi,type(HANDLE)			; Next entry
	loop	ihl
	pop	edi
	mov	[edi + HANDLE.PAGELIST],BACKFILLSTART/16	; Set handle 0 to backfill
	mov	[edi + HANDLE.PAGECOUNT],BACKFILLPAGES	;
	bts	[edi + HANDLE.PAGECOUNT],EMS_ALLOCATED	; Allocate the OS handle
	pop	ds
	assume	ds:DS386
	ret
init_handles	endp
;
; Init the logical directory
;   This operates like a FAT
;
init_logdir	proc
	mov	edi,[logdir]		; Get logical dir
	mov	esi,[memfree]		; Get freemem
	mov	edx,[firstfree]		; Get first free page
	mov	eax,esi			; Calculate max pages
	sub	eax,edx			;
	shr	eax,14			;
	mov	[maxpages],eax		;
	mov	[freepages],eax
	push	ds			; Switch to FS
	push	es
	push	DSABS
	pop	es
	push	DSABS
	pop	ds
	push	edi
	sub	eax,eax			; Clear the logdir to 0
	mov	ecx,LOGDIRSIZE/2
	rep	stosw
	mov	ecx,BACKFILLPAGES-1	; Make the backfill pages a linked list
	add	edi,BACKFILLSTART*2	;
	mov	eax,BACKFILLSTART+1     ;
ild1:
	stosw				;
	inc	eax			;
	loop	ild1			;
	pop	edi			;
	mov	ecx,esi			; Get free pages less 1
	shr	ecx,12			;
	dec	ecx			;
	shr	edx,11			; Start = First free page * 2
	add	edi,edx                 ;
	shr	edx,1			; Freelist = first free page
	mov	esi,edx                 ;
	inc	edx			; Make linked list out of free mem
	mov	eax,edx			;
ild2:
	stosw      			;
	inc	eax			;
	loop	ild2			;
	sub	eax,eax
	dec	eax
	stosw
	pop	es			; Restpre segs
	pop	ds			;
	mov	[freelist],esi		; Set free list
	ret
init_logdir	endp
;
; Invalidate a position in the seg map tab
;
invmap	proc
	mov	eax,esi			; Get position
	shr	eax,14			;
	mov	dword ptr [edi+eax*4],0	; Invalidate
	
	ret
invmap	endp
;
; Init the segment to physcial map table
; Look for ROMs in the standard paging area
;
init_segtab	proc
	mov	edi,[segtab]		; Get seg tab
	push	ds			; Switch to abs segment
	push	es
	push	DSABS
	pop	ds
	push	DSABS
	pop	es
	push	edi
	mov	ecx,BACKFILLPAGES	; Set the back fill entry segs
	mov	eax,BACKFILLSTART*400h	;
isl0:
	stosd
	add	eax,400h
	loop	isl0
	rep	stosd
	push	edi
	mov	ecx,STDENTRIES		; Init the standard entry segs
	mov	eax,0c000h      	;
isl0a:
	stosd
	add	eax,400h
	loop	isl0a
	pop	edi  			; Recover ptr to standard entries
	push	edi	
	mov	esi,0c0000h		; Address to start ROM search
isl:	
	cmp	word ptr [esi],ROMTAG	; Check for a rom tag
	jnz	nextrom			; None here, skip over 2K
	call	invmap                  ; Invalidate the page for mapping
	movzx	eax,byte ptr [esi + 2]	; Else get len
	shl	eax,9			; In bytes
	add	esi,eax			; Skip over it
	add	esi,2047		; Skip to next 2K boundary
	and	esi,0fffff800h		;
	call	invmap			; Invalidate the new page for mapping
	jmp	short nextrom2		; Continue
nextrom:
	add	esi,2048		; Skip to next 2K check point
nextrom2:
	cmp	esi,0e0000h		; See if hit system rom area
	jc	isl			; Nope, continue
	mov	esi,0e0000h		; Check for system rom
	cmp	word ptr [esi],ROMTAG	;
	jnz	freee000		; Nope, seg at E000 is free
	mov	ecx,4			; Else invalidate 4 pages
isl2:	
	call	invmap		;
	add	esi,4000h		;
	loop	isl2			;
freee000:
	pop	edi			; Restore ptr to standard entries
	sub	eax,eax			; 1st standard entrie is page 0
	mov	ecx,STDENTRIES		;
isl3:
	test	word ptr [edi+MAPABLE.MSEG],0ffffh	; Check if mapable
	jz	noentry			; No, continue
	mov	word ptr [edi+MAPABLE.MPAGE],ax ; Else number this entry
	inc	eax			; Next number
noentry:
	add	edi,type(mapable)	; Continue
	loop	isl3			;
	pop	edi			; Get pointer to backfill pages
	mov	ecx,BACKFILLPAGES	; Number of backfill pages
isl4:
	mov	word ptr [edi+MAPABLE.MPAGE],ax ; These are all mapable,
	inc	eax			; Just number them
	add	edi,type(mapable)	;
	loop	isl4			;
	mov	[segentries],eax	; Save number of mapable entries
	pop	es
	pop	ds
	ret
init_segtab	endp
;
; Init the alternate maps
;   These have physical paging info in them
;
init_maps	proc
	sub	al,al
	push	eax
	call	readmap
	pop	eax
	inc	al
	cmp	al,EMS_MAPS
	jc	init_maps
	ret
init_maps	endp
;
; Main EMS init routine
;
ems_init	proc
	cld
	mov	eax,[membase]		; Calculate local memory areas
	add	[logdir],eax		;
	add	[handtab],eax		;
	add	[maptabs],eax		;

	add	[firstfree],eax		; Bump firstfree up to first usable page
	add	[firstfree],3fffh	;
	and	[firstfree],0ffffc000h
	sub	[memfree],LOGDIRSIZE + HANDTABSIZE+ SEGTABSIZE + MAPSIZE + VCPIMAPSIZE
	and	[memfree],0ffffc000h	; Adjust total size

	call	init_handles		; Init handle dir
	call	init_logdir		; Init log page dir
	call	init_segtab		; Init seg-physical tab
	call	init_maps		; Init alternate map sets
	ret
ems_init	endp
seg386discard	ends
	end