#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include "cmdline.h"
#include "umem.h"


long memory_left;

static long total_memory;
static long mem_used;
static uint memptr,memend,questart;
void MemoryInit(uint size)
{
	union REGS regs;
	uint *p = (void *)malloc(16384);
	regs.x.ax = 0x4800;
	regs.x.bx = 0xffff;
	int86(0x21,&regs,&regs);
	total_memory = (regs.x.bx> size ? size : regs.x.bx) * 16L;
	if (total_memory == 0 || !p)
		fatal("Can't allocate any memory");
	memory_left = total_memory;
	regs.x.ax = 0x4800;
	int86(0x21,&regs,&regs);
	free(p);
	memptr = questart = regs.x.ax;
	memend = regs.x.ax + total_memory/16;
	mem_used = 0;
	p = MK_FP(memptr,0);
	p[0] = memend;
	p[1] = total_memory/16;
}
void MemoryRundown(void)
{
	struct SREGS sr;
	union REGS regs;
	regs.x.ax = 0x4900;
	sr.es = memptr;
	int86x(0x21,&regs,&regs, &sr);
}
static void release (void *buf)
{
	uint para = FP_SEG(buf);
  uint *last = &questart;
	uint *q = MK_FP(para,0), size;
	
	if (FP_OFF(buf) != 2)
		fatal("Internal deallocation error");
	size = q[0];
	mem_used-= size*16L;
	memory_left += size*16L;
	
  while (TRUE) {
		if (last[0] > para)
			break;
		last = MK_FP(last[0],0);
	}
	if (last == &questart) {
		q[0] = last[0];
		q[1] = size;
		last[0] = para;
	}
	else {
		if (last[1] + FP_SEG(last) == para)
			last[1] += size;
		else {
			uint temp = last[0];
			last[0] = para;
			last = q;
			last[0] = temp;
			last[1] = size;
		}
	}
	if (last[1] + FP_SEG(last) == last[0] && last[0] < memend) {
		uint *next = MK_FP(last[0],0);
		last[0] = next[0];
		last[1] += next[1];
	}
}
static void *allocate(long size)
{
	uint current = questart,*last;
	size = (size + 2 + 15)/16;
	if (size >0x1000L)
		fatal("Internal allocation error");
	last = &questart;
	while (current < memend) {
		uint *q = MK_FP(current,0);
		if (q[1] >= size) {
			mem_used += size *16L;
			if (total_memory - mem_used < memory_left )
				memory_left = total_memory - mem_used;
			if (q[1] != size) {
				uint next = current + size;
				uint *p = MK_FP(next,0);
				p[1] = q[1]-size;
				p[0] = q[0];
				last[0] = next; 
			}
			else {
				last[0] = q[0];
			}
			q[0] = size;
			return(q+1);
		}
		last = q;
		current = q[0];
	}
	return(0);
}
void *ReallocateMemory(void *buf, uint size)
{
	void *rv;
	if (!size)
		return(0);
	rv = allocate(size);

  if (!rv)
    fatal("Out of memory\n");

	if (buf) {
		memcpy(rv,buf,size);
		release(buf);
	}
	
  return(rv);
}
/*
 * Allocate memory.  Dump out if none
 */
void *AllocateMemory(uint size)
{
	return(ReallocateMemory(0,size));
}
/*
 * Deallocate memory.  Synonomous to FREE
 */
void DeallocateMemory(void *pos)
{
	if (pos == 0)
		return;
	release(pos);
}