/************************ cfs Character File Stream *************************/

#define DefChar   0x4070007F
#define FileMode  0
#define MemMode   1
#define ScanMode  2

#define er  short            /* Error Status Return Value */
#define us  unsigned char    /* Unsigned Single-byte */
#define ud  unsigned short   /* Unsigned Double-Byte */
#define uq  unsigned long    /* Unsigned Quad-Byte */
#define sd  short /* Signed Double-Byte */
#define ss  char  /* Signed Single-Byte */

/* Character Stream Data Structure */
typedef struct
 {
  FILE *fp;   /* File Pointer */
  uq curch;   /* Current Character */
  uq def;     /* Default Value */
  uq msk;     /* Default Mask */
  uq tot;     /* Total Characters Processed so far */
  uq size;    /* Size of Byte Stream */
  us mode;    /* 0=Scan Only,1=Memory,2=File */
  us cnt;     /* Number of Pending Displayable Characters */
  us clm;     /* Current Column */
  us mag;     /* Current Magnitude */
  us phi;     /* 0=ASCII, 1=PhiText */
  us len;     /* Number of Bytes in Buffer */
  us ix;      /* Index of Next Byte in Buffer */
  us buf[33]; /* Buffer */
 }CFS;

/* Read Functions */
void cfs_Rini(CFS *Crec,uq msk,sd phi);
void cfs_Rclose(CFS *Crec);
er cfs_Rbyte(CFS *Crec,us *byt);
er cfs_Rchar(CFS *Crec,uq *val);

/* Open for File Input */
er cfs_Ropen(CFS *Crec,char *name,uq msk);

/* Open for Memory Read */
er cfs_Rmem(CFS *Crec,us *adr,uq msk,sd phi);

/* Write Functions */
void cfs_Wini(CFS *Crec,uq msk,sd phi);
void cfs_Wclose(CFS *Crec);
void cfs_Wbyte(CFS *Crec,us byt);
void cfs_Wflush(CFS *Crec);
void cfs_Wchar(CFS *Crec,uq val);

/* Open for File Output */
er cfs_Wopen(CFS *Crec,char *name,uq msk,sd phi);

/* Open for Memory Write */
er cfs_Wmem(CFS *Crec,us *adr,uq msk,sd phi);

/* Open for Memory Write for Size Computation only: No Actual Writing */
er cfs_Smem(CFS *Crec,uq msk,sd phi);
