/*
 * Assembler core
 *
 * Copyright (c) 1996 LADSOFT
 *
 * David Lindauer, camille@bluegrass.net
 *
 * Core for a retargetable assembler
 *
 * This program may be freely used and redistributed, as long as the 
 * copyright notice remains intact.  The author holds no liabilty;
 * all risks, both direct and consequential, are the responsibilty of
 * the user.  You use this program at your own risk!
 *
 */
/*
 * if.c
 *
 * if-then handling
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "utype.h"
#include "umem.h"
#include "asm.h"
#include "input.h"
#include "Expr.h"
#include "gencode.h"
#include "if.h"
#include "macros.h"

extern int ifstyle,macstyle;
extern int macrolevel;
extern int pass;
extern char *bufptr;
extern HASHREC **hashtable;
extern BOOL newline;

BOOL ifskip;
static LIST *iflist;

/* list function for if lines */
void doiflist(void)
{
	if (macrolevel) {
		if (macstyle == 2 && ifstyle)
			dolist();
		else
			if (macstyle == 4)
				dolist2();
	}
	else
		if (ifstyle)
			dolist2();
}
/*
 * init function
 */
void ReinitIf(void)
{
  while (iflist)
		UnlinkIf();
	ifskip = FALSE;
	ifstyle = 0;
}
/*
 * set the skip value */
static void setskip(BOOL newskip)
{
	if ((BOOL)(iflist->data))
		ifskip = TRUE;
	else
		ifskip = newskip;
}
/* drop a nesting level */
static void UnlinkIf(void)
{
	LIST *q = iflist;
	
	ifskip = ((BOOL)q->data);
	iflist = q->link;
	DeallocateMemory(q);
}
/* main if handler */
static void commonif(int type, long comparison)
{
	LIST *newlist;
	int newskip = FALSE;
	switch (type) {
		case IF_C:
		case IF_EQ:
		case IF_B:
			newskip = !comparison;
			break;
		case IF_NC:
		case IF_NE:
		case IF_NB:
			newskip = !!comparison;
			break;
		case IF_GT:
			newskip = comparison > 0;
			break;
		case IF_LT:
			newskip = comparison < 0;
			break;
		case IF_GE:
			newskip = comparison >= 0;
			break;
		case IF_LE:
			newskip = comparison <= 0;
			break;
	}
	/* add a nesting level */
	newlist = AllocateMemory(sizeof(LIST));
	newlist->link = iflist;
	newlist->data = (void *) ifskip;
	iflist = newlist;
	setskip(!newskip);
}
/* MASM style if statements */
void setifblank(int type)
{
	char buf[100],buf2[100];
	short curchar;
	int comp;
	curchar = skipSpace(&bufptr);
	curchar = getmacroarg(buf,curchar,FALSE);
	switch (type) {
		case IF_B:
		case IF_NB:
			commonif(type,buf[0]);
			break;
		case IF_IDN:
		case IF_IDNI:
		case IF_DIF:
		case IF_DIFI:
			if (curchar != ',')
				Error("Ill formed IF argument");
			curchar = getmacroarg(buf2,curchar,FALSE);
			if (type == IF_IDNI || type == IF_DIFI) {
				int i;
				for (i=0; i < strlen(buf); i++)
					buf[i] = toupper(buf[i]);
				for (i=0; i < strlen(buf2); i++)
					buf2[i] = toupper(buf2[i]);
			}
			comp = !strcmp(buf,buf2);
			if (type == IF_DIF || type == IF_DIFI)
				commonif(IF_NE,comp);
			else 
				commonif(IF_EQ,comp);
			break;
		case IF_DEF:
		case IF_NDEF: {
				EXPRESSION *p,**q =LookupHash(hashtable, buf);
				if (q)
					p = *q;
				else
					p = 0;
				if (p) 
					comp = ((pass == p->defpass || pass == 100 ) && p->isdef);
				else comp = 0;
				if (type == IF_DEF)
					commonif(IF_NE,comp);
				else
					commonif(IF_EQ,comp);
			}
			break;
	}
	newline = TRUE;
	doiflist();
}
void setif(int type, EXPRESSION *exp)
{
	if (!numericExpression(exp)  || !exp->isdef || exp->isextern || exp->relmode)
		Error("Invalid if parameter");
	else
		if (type == IF_NC || type == IF_C)
			Error("Can't use string comparison in this context");
		else
			commonif(type,exp->x.value);
	delexpr(exp,0);
	doiflist();
}
void setifc(int type, char *str1, char *str2)
{
	if (type != IF_NC && type != IF_C)
		Error("Must use string comparison in this context");
	else
		commonif(type, strcmp(str1, str2));
	doiflist();
}
void setelse(void)
{
	if (!iflist)
		Error("Else Without If");
	else
		setskip(!ifskip);
	doiflist();
}
void setelseif(EXPRESSION *exp)
{
	if (!iflist)
		Error("Elseif Without If");
	else {
		UnlinkIf();
		setif(IF_NE, exp);
	}
	delexpr(exp,0);
	doiflist();
}
void setendif(void)
{
	if (!iflist)
		Error("Endif Without If");
	else {
		UnlinkIf();
	}
	doiflist();
}