#include <stdio.h>
#include <memory.h>
#include <dos.h>
#include "cmdline.h"
#include "umem.h"

EMSMEM *AllocateEMSMemory(long size, BYTE fill)
{
  EMSMEM *rv = AllocateMemory(sizeof(EMSMEM));
	if (size > 65530L)
		fatal("EMS Image capacity exceeded");
	rv->size = size;
	rv->address = AllocateMemory(size);
	memset(rv->address,fill,size);
	return(rv);
}
void DeallocateEMSMemory(EMSMEM *mem)
{
	DeallocateMemory(mem->address);
	DeallocateMemory(mem);
}
void ResizeEMSMemory(EMSMEM *mem, long size)
{
	BYTE *p = AllocateMemory(size);
	if (size > 65530L)
		fatal("EMS Image capacity exceeded");
	memcpy(p,mem->address,size);
	DeallocateMemory(mem->address);
	mem->address = p;
	mem->size = size;
}

BYTE *PtrToEMSMem(EMSMEM *mem, long offset)
{
  BYTE *a = mem->address;
	uint t = offset/16/1024/16;
	uint q = offset % (16*1024);
	a = MK_FP(FP_SEG(a)+t, FP_OFF(a) + q);
	return(mem->address + offset);
}