/************************ cfs Character File Stream *************************/
#include <stdio.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "cfs.h"

/************************** READ STREAM FUNCTIONS ***************************/

/* Initialize Character Stream Data Structure for Read */
void cfs_Rini
 (
  CFS *Crec,
  uq msk,
  sd phi
 )
 {
  Crec->fp = 0;
  Crec->curch = DefChar;
  Crec->def = DefChar;
  Crec->msk = msk;
  Crec->tot = 0;
  Crec->size = 0;
  Crec->mode = 0;
  Crec->cnt = 0;
  Crec->clm = 0;
  Crec->mag = 0;
  Crec->phi = phi;
  Crec->len = sizeof(Crec->buf);
  Crec->ix = sizeof(Crec->buf);
 }

/* Open File for Read */
er cfs_Ropen(CFS *Crec,char *name,uq msk)
 {
  er st=0;

  cfs_Rini(Crec,msk,0);
  Crec->fp = fopen(name,"rb");
  if (Crec->fp)
   {
    Crec->mode = FileMode;
    st = 1;
   }
  return(st);
 }

/* Open CFS for Memory Read */
er cfs_Rmem(CFS *Crec,us *adr,uq msk,sd phi)
 {
  er st=0;

  cfs_Rini(Crec,msk,phi);
  (us *)Crec->fp = adr;
  if (Crec->fp)
   {
    Crec->mode = MemMode;
    st = 1;
   }
  return(st);
 }

/* Close for Read */
void cfs_Rclose(CFS *Crec)
 {
  if (Crec->mode == FileMode && Crec->fp)
   {
    fclose(Crec->fp);
    Crec->fp = 0;
   }
 }

/* Read a Byte */
er cfs_Rbyte
 (
  CFS *Crec,
  us *byt
 )
 {
  er st=0;
  us *src;
  us *dst;

  if (Crec->ix >= Crec->len)
   {
    if (Crec->mode == FileMode)
      Crec->len=fread(Crec->buf,1,sizeof(Crec->buf),Crec->fp);
    else
     {
      Crec->len = 0;
      src = (us *)Crec->fp;
      dst = Crec->buf;
      while (*src && Crec->len < sizeof(Crec->buf))
       {
        *dst++ = *src++;
        Crec->len += 1;
       }
      (us *)Crec->fp = src;
     }

    Crec->ix = 0;
   }
  if (Crec->ix < Crec->len)
   {
    *byt = Crec->buf[Crec->ix];
    Crec->size += 1;
    Crec->ix += 1;
    st = 1;
   }

  return(st);
 }

/* Read a Character */
er cfs_Rchar
 (
  CFS *Crec,
  uq *val
 )
 {
  er st;
  us cont=1;
  us byt;
  us grp;
  us rep;
  us tmp;

  while (cont)
   {
    /* Any Left from Repeat? */
    if (Crec->cnt)
     {
      *val = Crec->curch & Crec->msk;
      Crec->cnt -= 1;
      Crec->clm += 1;
      cont = 0;
     }
    else
     {
      rep = 0;
      st = cfs_Rbyte(Crec,&byt);
      if (!st) return(0);

      /* Special */
      if (byt & 0x80)
       {
        grp = byt & 0x70;

        /* Repeat */
        if (grp == 0x00)
         {
          if (!Crec->mag) Crec->cnt = 2;
          Crec->cnt += ((byt & 0x0F) << Crec->mag);
          Crec->mag += 4;
          rep = 1;
         }

        /* New Bank */
        else if (grp == 0x10)
         {
          Crec->curch &= 0xFFFFF87F;
          Crec->curch |= ((uq)(byt & 0x0F)) << 7;
         }

        /* New Attributes */
        else if ((grp & 0x60) == 0x20)
         {
          Crec->curch &= 0xFFFF07FF;
          Crec->curch |= ((uq)(byt & 0x1F)) << 11;
         }

        /* New Foreground Color */
        else if (grp == 0x40)
         {
          Crec->curch &= 0xFFF0FFFF;
          Crec->curch |= ((uq)(byt & 0x0F)) << 16;
         }

        /* New Background Color */
        else if (grp == 0x50)
         {
          Crec->curch &= 0xFF0FFFFF;
          Crec->curch |= ((uq)(byt & 0x0F)) << 20;
         }

        /* New Style Code */
        else if (grp == 0x60)
         {
          Crec->curch &= 0xF0FFFFFF;
          Crec->curch |= ((uq)(byt & 0x0F)) << 24;
         }

        /* New Size Code */
        else if (grp == 0x70)
         {
          Crec->curch &= 0x0FFFFFFF;
          Crec->curch |= ((uq)(byt & 0x0F)) << 28;
         }
       }

      /* Displayable */
      else if (byt & 0x60)
       {
        Crec->curch &= 0xFFFFFF80;
        Crec->curch |= byt;
        Crec->cnt = 1;
       }

      /* Terminator? */
      else
       {
        switch (byt)
         {
          case 10: /* New Paragraph Left Justified */
          case 20: /* New Paragraph Right Justified */
          case 21: /* New Paragraph Center Justified */
          case 22: /* New Paragraph Fully Justified */
            Crec->clm = 0;
          case 15: /* Stationary Terminator */
            Crec->curch = Crec->def;
          case 11: /* New Line */
          case 12: /* Hard Form Feed */
          case 14: /* Soft Form Feed */
            *val = byt;
            cont = 0;
            break;
          case 30:
            Crec->phi = 0;
            break;
          case 31:
            Crec->phi = 1;
            break;
          case 9:  /* Tab */
            tmp = Crec->clm;
            while (1)
             {
              tmp += 1;
              Crec->cnt += 1;
              if (!(tmp & 0x07)) break;
             }
            Crec->curch &= 0xFFFFFF80;
            Crec->curch |= ' ';
            break;
         }
       }

      if (!rep) Crec->mag = 0;
     }
   }
  Crec->tot += 1;
  return(1);
 }

/************************* WRITE STREAM FUNCTIONS ***************************/

/* Initialize Character Stream Data Structure for Write */
void cfs_Wini
 (
  CFS *Crec,
  uq msk,
  sd phi
 )
 {
  Crec->fp = 0;
  Crec->curch = DefChar;
  Crec->def = DefChar;
  Crec->msk = msk;
  Crec->tot = 0;
  Crec->size = 0;
  Crec->mode = 0;
  Crec->cnt = 0;
  Crec->clm = 0;
  Crec->mag = 0;
  Crec->phi = phi;
  Crec->len = sizeof(Crec->buf);
  Crec->ix = 0;
 }

/* Write a Byte */
void cfs_Wbyte
 (
  CFS *Crec,
  us byt
 )
 {
  us *src;
  us *dst;
  sd ix=0;

  Crec->buf[Crec->ix] = byt;
  Crec->size += 1;
  Crec->ix += 1;
  if (Crec->ix >= Crec->len)
   {
    if (Crec->mode == FileMode)
      fwrite(Crec->buf,1,Crec->ix,Crec->fp);
    else if (Crec->mode == MemMode)
     {
      src = Crec->buf;
      dst = (us *)Crec->fp;
      while (ix < Crec->len)
       {
        *dst++ = *src++;
        ix += 1;
       }
      (us *)Crec->fp = dst;
     }
    Crec->ix = 0;
   }
 }

/* Open File for Write */
er cfs_Wopen(CFS *Crec,char *name,uq msk,sd phi)
 {
  er st=0;

  cfs_Wini(Crec,msk,phi);
  Crec->fp = fopen(name,"wb");
  if (Crec->fp)
   {
    Crec->mode = FileMode;
    if (Crec->phi) cfs_Wbyte(Crec,31);
    st = 1;
   }
  return(st);
 }

/* Open CFS for Memory Write */
er cfs_Wmem(CFS *Crec,us *adr,uq msk,sd phi)
 {
  er st=0;

  cfs_Wini(Crec,msk,phi);
  (us *)Crec->fp = adr;
  if (Crec->fp)
   {
    Crec->mode = MemMode;
    st = 1;
   }
  return(st);
 }

/* Open CFS for Memory Write for Size Computation Only: No Actual Writes */
er cfs_Smem(CFS *Crec,uq msk,sd phi)
 {
  er st=0;

  cfs_Wini(Crec,msk,phi);
  Crec->mode = ScanMode;
  st = 1;
  return(st);
 }

/* Close for Write */
void cfs_Wclose(CFS *Crec)
 {
  if (Crec->mode == FileMode && Crec->fp)
   {
    cfs_Wflush(Crec);
    if (Crec->ix)
     {
      fwrite(Crec->buf,1,Crec->ix,Crec->fp);
      Crec->ix = 0;
     }
    fclose(Crec->fp);
    Crec->fp = 0;
   }
 }

/* Flush Output */
void cfs_Wflush(CFS *Crec)
 {

  if (!Crec->phi || Crec->cnt == 1)
   {
    while (Crec->cnt)
     {
      cfs_Wbyte(Crec,Crec->curch & 0x7F);
      Crec->cnt -= 1;
     }
   }
  else if (Crec->cnt)
   {
    Crec->cnt -= 2;
    while (1)
     {
      cfs_Wbyte(Crec,0x80 | (Crec->cnt & 0x0F));
      Crec->cnt >>= 4;
      if (!Crec->cnt) break;
     }
   }
 }

/* Write Character */
void cfs_Wchar
 (
  CFS *Crec,
  uq val
 )
 {
  uq tmp;
  us byt;

  /* Displayable Character */
  if (0x00000060 & val)
   {
    val = (val & Crec->msk) | (Crec->def & ~Crec->msk);

    /* Flush if Necesssary */
    if (!Crec->phi)
     {
      Crec->curch = val;
      Crec->cnt += 1;
      cfs_Wflush(Crec);
     }
    else if (Crec->curch == val)
      Crec->cnt += 1;
    else
     {
      cfs_Wflush(Crec);

      /* New Size Code */
      if ((val ^ Crec->curch) & 0xF0000000)
       {
        tmp = val & 0xF0000000;
        byt = 0xF0 | (tmp >> 28);
        cfs_Wbyte(Crec,byt);
       }

      /* New Style Code */
      if ((val ^ Crec->curch) & 0x0F000000)
       {
        tmp = val & 0x0F000000;
        byt = 0xE0 | (tmp >> 24);
        cfs_Wbyte(Crec,byt);
       }

      /* New Background Color Code */
      if ((val ^ Crec->curch) & 0x00F00000)
       {
        tmp = val & 0x00F00000;
        byt = 0xD0 | (tmp >> 20);
        cfs_Wbyte(Crec,byt);
       }

      /* New Foreground Color Code */
      if ((val ^ Crec->curch) & 0x000F0000)
       {
        tmp = val & 0x000F0000;
        byt = 0xC0 | (tmp >> 16);
        cfs_Wbyte(Crec,byt);
       }

      /* New Attributes Code */
      if ((val ^ Crec->curch) & 0x0000F800)
       {
        tmp = val & 0x0000F800;
        byt = 0xA0 | (tmp >> 11);
        cfs_Wbyte(Crec,byt);
       }

      /* New Bank Code */
      if ((val ^ Crec->curch) & 0x00000780)
       {
        tmp = val & 0x00000780;
        byt = 0x90 | (tmp >> 7);
        cfs_Wbyte(Crec,byt);
       }

      /* Send Displayable Code */
      byt = val & 0x0000007F;
      cfs_Wbyte(Crec,byt);

      /* Update Current Character */
      Crec->curch = val;
     }
   }

  /* End of Paragraph Terminators */
  else if (val == 10 || val == 15 || val == 20 || val == 21 || val == 22)
   {
    cfs_Wflush(Crec);
    if (Crec->phi)
      cfs_Wbyte(Crec,val);
    else
     {
      if (Crec->mode == FileMode) cfs_Wbyte(Crec,13);
      cfs_Wbyte(Crec,10);
     }
    Crec->curch = Crec->def;
   }

  /* Other Terminators */
  else if (val == 11 || val == 12 || val == 13 || val == 14)
   {
    cfs_Wflush(Crec);
    cfs_Wbyte(Crec,val);
   }
  Crec->tot += 1;
 }
