#define HASH_TABLE_SIZE 4093

#define TBYTE 1
#define TWORD 2
#define TLONG 3
#define TSINGLE 4
#define TDOUBLE 5
#define TEXTENDED 6
#define TPACKED 7
#define TA11BJMP  0x1000
#define TA11BCALL 0x1001
#define TEVEN 0x1100
#define TCOP8JMP 0x1200
#define TCOP8JSR 0x1201
#define TINPAGE 0x1202

#define IF_EQ	0
#define IF_NE	1
#define IF_GT	2
#define IF_LT   3
#define IF_GE   4
#define IF_LE   5
#define IF_C	6
#define IF_NC   7

#define IF_B 10
#define IF_NB 11
#define IF_DIF 12
#define IF_DIFI 13
#define IF_IDN 14
#define IF_IDNI 15
#define IF_DEF 16
#define IF_NDEF 17

#define INCLUDELEVELS 24

typedef struct _expression
{
	struct _expression *link;
	char *name;
	struct _expression *loclablink;
	struct _expression *ext;
	long *xrefs;
	int xrefcount;
	union {
		long value;
		void *xdata;
		unsigned mregs;
		BYTE floatptr[12];
	} x;
	unsigned isfp:1;
	unsigned floatspec:1;
	unsigned isdef:1;
	unsigned isintermed:1;
	unsigned islabel:1;
	unsigned ismacro:1;
	unsigned isopcode:1;
	unsigned isextern:1;
	unsigned ispublic:1;
	unsigned islocalpub:1;
	unsigned isbitdef:1;		/* obsoleted in 8051... */
	unsigned ismovemreg: 1;
	unsigned ischangeable: 1;
	unsigned isoperand: 1;
	unsigned isstruct: 1;
	unsigned relpc: 1;
	unsigned rel:1;
	unsigned reg1:1;
	unsigned reg2:1;
	unsigned type;
	unsigned swapper;
	unsigned id;
	unsigned relmode;
	long size;
	BYTE defpass;
	BYTE section;
} EXPRESSION;

#define RM_NONE 0
#define RM_PEXT	1
#define RM_MEXT 2
#define RM_PPUB 3
#define RM_MPUB 4

typedef struct
{
  char *text;
  long type;
  unsigned op1,op2,op3;
  unsigned size;
} OPCODEDATA;

typedef struct
{
  unsigned reg;
  unsigned adrtype;
  unsigned type;
  unsigned size;
} BASE;

typedef struct
{
  unsigned type;
  long reg;
  BASE *basereg;
  EXPRESSION *basedisp;
  EXPRESSION *outerdisp;
} OPERANDDATA;