;
; LSD os library for use with C compilers
;
; Copyright(c) 1996 LADsoft
;
; David Lindauer, gclind01@starbase.spd.louisville.edu
;
	.386
	MODEL USE32 SMALL

include lib.asi

	PUBLIC	_OSRunProgram,_OSRunProgramAndWait,_OSSpawnChild
	PUBLIC	_OSSpawnChildAndWait,_OSPause,_OSEndTask,_OSRundownOS

_TEXT	SEGMENT	
;
;* int OSRunProgram(char *name);
;
_OSRunProgram	PROC	
	ARG	FILENAME : DWORD
	ENTER	0,0
	push	esi
	push	edi
	sub	esi,esi
	sub	edi,edi
	mov	ebx,[FILENAME]
	OS	TA_NEW
	jc	short getout
okrun:
    	sub	eax,eax
getout:
	pop	edi
	pop	esi
	LEAVE
	ret
_OSRunProgram	ENDP	
	
;
;* int OSRunProgramAndWait(char *name);
;
_OSRunProgramAndWait	PROC	
	ARG	FILENAME : DWORD
	ENTER	0,0
	push	esi
	push	edi
	push	ebx
	sub	esi,esi
	sub	edi,edi
	mov	ebx,[FILENAME]
	OS	TA_NEWWAIT
	pop	ebx
	jnc	okrun
	pop	edi
	pop	esi
	LEAVE
	ret
_OSRunProgramAndWait	ENDP	
;
;* int OSSpawnChild(int address);
;
_OSSpawnChild	PROC	
	ARG	ADDRESS : DWORD
	ENTER	0,0
	push	esi
	push	edi
	sub	esi,esi
	sub	edi,edi
	push	ebx
	mov	ebx,[ADDRESS]
	OS	TA_SPAWN
	pop	ebx
	jnc	okrun
	pop	edi
	pop	esi
	LEAVE
	ret
_OSSpawnChild	ENDP	
;
;* int OSSpawnChildAndWait(int address);
;
_OSSpawnChildAndWait	PROC	
	ARG	ADDRESS : DWORD
	ENTER	0,0
	push	esi
	push	edi
	sub	esi,esi
	sub	edi,edi
	push	ebx
	mov	ebx,[ADDRESS]
	OS	TA_SPAWNWAIT
	pop	ebx
	jnc	okrun
	pop	edi
	pop	esi
	LEAVE
	ret
_OSSpawnChildAndWait	ENDP	
;
;* void OSPause(void);
;
_OSPause	PROC	
	OS	TA_PAUSE
	ret
_OSPause	ENDP	
;
;
;* void OSEndTask(int endval);
;
_OSEndTask	PROC	
	OS	TA_END
	ret
_OSEndTask	ENDP	
;
;* void OSRundownOS(void);
;
_OSRundownOS	PROC	
	OS	TA_EXIT
	ret
_OSRundownOS	ENDP	

_TEXT	ENDS	
END