;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; XSTACK.ASM
;
; Function: automatic stack extension for an expand-down stack
;   Handles checking for user or system mode
;   Handles extending user stack if not too big already
;
	;MASM MODE
	.386p

include  segs.asi 
include  tss.asi 
include  page.asi 
include  pageall.asi 
include  traps.ase 
include  descript.ase 
include  page.ase 
include  pageall.ase 
include  sys.mac 
include  boot.ase 
include  tss.ase 

	PUBLIC	InitExtendStack, ExtendStack, UnAllocStack
	extrn trap12 : PROC
	ifdef MONITOR
	extrn	entry12 : PROC
	endif

seg386	SEGMENT	
; 
; Set up a routine to extend stack if trap 12 occurs
;
InitExtendStack	PROC	
	mov	edi,12
	mov	ebx,offset cgroup:ExtendStack	; dx:ebx = stack overflow routine
	mov	edx,cs			;
	call	SetTrapVect		; Set it
	ret
InitExtendStack	ENDP	
;
; Routine to extend the stack
;
ExtendStack	PROC	
	push	eax			; EAX is scrtacth
	push	edi			; and edi
	push	ds
	push	DS386
	pop	ds
	mov	eax,[esp + 32]		; MAke sure we are on the user stack
	cmp	ax,LDT_USERSTACK	;
	jnz	short report		; No, a system stack so report it
	call	DescriptorAddress	; Get address of descriptor
	call	GetDescriptorLimit	; Get the limit
	cmp	eax,SYSTEMSTACK		; See if any more space available
	jb	short report		; No, report
	sub	eax,PG_SIZE		; MAke it a page longer
	push	eax
	call	SetDescriptorLimit	;
	pop	eax
	mov	edi,CR3			; Get Page Table
	ZA	edi                     ;
	mov	edi,[edi + 4]		; Get user code/data page
	and	edi,NOT (PG_SIZE - 1)	; Get rid of spurious bits
	ZA	edi			;
	inc	eax			; Get bottom of page to alloc
	push	ebx			; EBX is scratch
	push	eax			; Save page to alloc
	ALLOCEXT
	call	PageAlloc		; Alloc an extended memory page
	jc	short report2		; Failure, go report
	mov	ebx,eax			; EBX is allocated page
	or	ebx,PG_WRITEABLE OR PG_USERMODE ; Writeable and user page
	pop	eax			; EAX is bottom of position to alloc at
	shr	eax,PG_SHIFTSIZE	; Find the page table entry
	call	PageTableEnTerAddress	; Enter the address in the page table
	pop	ebx			; Clear stack
	pop	ds
	pop	edi			;
	pop	eax			;
	add	esp,4			; Clear error number
	iretd				; Give program another chance
report2:
	pop	eax			; Clear stack
	pop	ebx			;
report:
	pop	ds
	pop	edi			; Clear stack
	pop	eax			;
ifdef 	MONITOR
	jmp	entry12			; Monitor entry point
else
	jmp	trap12			; Normal trap entry point
endif
ExtendStack	ENDP	
;
; Deallocate an extended stack
;
UnAllocStack	PROC	
	push	edi			; Save page dir address
	mov	edi,[edi + 4]		; Get Code/data page table
	and	edi,NOT (PG_SIZE - 1)	; Get rid of spurious bits
	ZA	edi			; Make it segment offset
	mov	ebx,SYSTACKPAGEOFS + 1	; First stack entry
	mov	ecx,USERSTACKPAGES -1	; Number of stack entries,
					; excluding top Page
uas_loop:
	mov	eax,[edi + 4 * ebx]	; Get entry
 	test	al,PG_PRESENT		; See if present
	jz	short uas_notpresent	; Not, no action
	call	PageDealloc		; Else deallocate
	mov	DWORD PTR [edi + 4 * ebx],PG_DISABLE; Mark absent
uas_notpresent:
	inc	ebx			; Next page
	loop	uas_loop		; Continue till done
	pop	edi			; restore page dir address
	ret
UnAllocStack	ENDP	
seg386	ENDS	
END