;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Timer.asm
;
; Function: Timed interrupt functions come through here
;   Handles keeping BIOS up to date
;   Handles high-speed (72.8Hz) interrupts
;
	;MASM MODE              
	.386p

include  sys.mac 
include  segs.asi 

include  pic.asi 
include  ints.asi 
include  ints.ase 
include  tss.ase 
include  beep.ase 
include  kb.ase 
include  floppy.ase 
include  mouse.ase 
include  iodelay.asi 

	PUBLIC	_timerenable, _timerdisable, _timerisr, _tickcount
TIMER0CTL = 34h
TIMERCTLPORT = 43h
TIMER0DATAPORT = 40h

seg386data	SEGMENT	
_tickcount dd	0	; Total number of ticks
seg386data	ENDS	

absdata	SEGMENT	
	org	46ch
biosticks dd	?
biosoverrun db	?
absdata	ENDS	
seg386	SEGMENT	
;
; Interrupt subroutine
;
_timerisr	PROC	
	push	eax	; Save regs
	push	ds
	push	DS386	; Switch to OS data
	pop	ds
	inc	[_tickcount]	; Int tickcount
	test	[_tickcount],3	; Every fourth tick call BIOS
	jnz	short noreal		;
	call	kb_timer	; Resend if kb timeout
	call	beepint		; Do any beeps
	call	floppyTimerInt	; Handle floppy timeouts
	call	MouseIntr	; Mouse interrupt
	push	fs
	push	dsabs
	pop	fs
	inc	[biosticks]
	cmp	[biosticks],1800b0h
	jc	short nooverrun
	inc	[biosoverrun]
	mov	[biosticks],0
nooverrun:
	pop	fs
noreal:
	PICACK			; Acknowledge int if not calling BIOS
quit:
	call	TaskSwitch
	pop	ds
	pop	eax
	iretd
_timerisr	ENDP	
;
; Set the speed of the interrupt timer
;
_timerintinit	PROC	
	push	eax
	mov	al,34h		; Select timer 0
	out	TIMERCTLPORT,al	;
	pop	eax
	out	TIMER0DATAPORT,al	; Put out low byte of speed
	IODELAY
	mov	al,ah
	out	TIMER0DATAPORT,al	; Put out hi byte of speed
	ret
_timerintinit	ENDP	
;
; Set high freq timer (72.8 Hz)
;
_timerenable	PROC	
	mov	ax,4000h     		; Multiply timer freq by 4 (10000 / 4000)
	call	_timerintinit		; Init it
	ret
_timerenable	ENDP	
;
; Set lo freq timer (18.2 Hz)
;
_timerdisable	PROC	
	pushfd				; Set interrupts
	sti
lp1:
	test	[_tickcount],3		; Wait till odd count
	jz	lp1
lp2:
	test	[_tickcount],3		; Wait till even count
	jnz	lp2
	popfd
	mov	ax,0			; Multiply timer freq by 1 (10000 / 10000)
	call	_timerintinit
	ret
_timerdisable	ENDP	
seg386	ENDS	
END