;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Sems.asm
;
; Function: Waiting tasks on semaphores
;
	;MASM MODE
	.386p

include  segs.asi 
include  os.asi 
include  descript.ase 
include  page.asi 
include  tss.asi 
include  sems.asi 
include  sys.mac 
include  boot.ase 

	PUBLIC	WaitSem, UnwaitSem, SemBlock

seg386	SEGMENT	
;
; Set to wait on a semaphore
;
WaitSem	PROC	
	str	ax			; Get task TSS
	call	DescriptorAddress	;
	call	GetDescriptorBase	;
	ZA	edi			;
	mov	[edi + TSS.RESOURCE] , ebx	; Bool to wait on
	mov	[edi + TSS.STATE],SEM_WAITRUE	; Wait condition
	ret
WaitSem	ENDP	
;
; Stop waiting on a semaphore
;
UnwaitSem	PROC	
	str	ax			; Get task TSS
	call	DescriptorAddress	;
	call	GetDescriptorBase	;
	ZA	edi			;
	mov	[edi + TSS.STATE], SEM_NOWAIT ; No waiting
	ret
UnwaitSem	ENDP	
;
; Block if a resource in use
;
SBP_RESOURCE = ebp + 8
SemBlock	PROC	
	ENTER	0,0
	push	eax			; Save regs
	push	ebx			;
	push	edi			;
	mov	ebx,[SBP_RESOURCE]	; Get resource
chkblock:
	btr	DWORD PTR [ebx],0	; Mark resource in use and get old state
	jc	short blocked		; Get out if blocked
	call	WaitSem			; Else set up to wait on sem
	os	TA_PAUSE		; Return to task handler
	jmp	chkblock		;
blocked:
	pop	edi			; Restore regs
	pop	ebx			;
	pop	eax			;
	leave
	ret	04
SemBlock	ENDP	

	
seg386	ENDS	
END