;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Misc.asm
;
; Function: Miscellaneous OS functions
;

	;MASM MODE
	.386p

include  segs.asi 
include  os.asi 
include	 vidisr.ase 
include  dispatch.ase 
include	 cmos.ase 
include  boot.asi 

	PUBLIC	_mischandler
TIMER_MUL = 10000
TIMER_DIV = 728

seg386	SEGMENT	
;
; Handles miscellaneous OS functions
;
GetVersion	PROC	
	mov	al,VERID / 100
	mov	ah,VERID MOD 100
	ret
GetVersion	ENDP	
toms	PROC	
	push	edx
	push	ecx
	mov	ecx,TIMER_MUL
	mul	ecx
	mov	ecx,TIMER_DIV
	idiv	ecx
	pop	ecx
	pop	edx
	clc
	ret
toms	ENDP	
fromms	PROC	
	push	edx
	push	ecx
	mov	ecx,TIMER_DIV
	mul	ecx
	mov	ecx,TIMER_MUL
	idiv	ecx
	pop	ecx
	pop	edx
	clc
	ret
fromms	ENDP	
reticks	PROC	
	mov	eax,[_tickcount]
	clc
	ret
reticks	ENDP	
EnableWatchDog	PROC	
	ret
EnableWatchDog	ENDP	
DisableWatchDog	PROC	
	cmp	ebx,WATCHDOGVERIFY
	jnz	short nodisable
nodisable:
	ret
DisableWatchDog	ENDP	
KickWatchDog	PROC	
	ret
KickWatchDog	ENDP	
_mischandler	PROC	
	assume	ds:nothing,es:nothing
	push	ds
	push	ds386
	pop	ds
	push	edx
	call	TableDispatch
	dd	11
	dd	reticks
	dd	reticks
	dd	toms
	dd	fromms
	dd	SetDate
	dd	GetDate
	dd	SetTime
	dd	GetTime
	dd	EnableWatchDog
	dd	DisableWatchDog
	dd	KickWatchDog
	dd	GetVersion
	pop	ds
	ret
_mischandler	ENDP	
seg386	ENDS	
END