;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; glbltss.am
;   Handles allocating the global TSS pages page
;   Handles allocating a TSS and putting it in table
;   Handles deallocating a TSS and removing from table
;
;   Note that TSS pages are doubly mapped, once as a physical page
;     (system paging only) and once in the global TSS page
	
	;MASM MODE
	.386p

include  segs.asi 
include  page.asi 
include  glbltss.asi 
include  pageall.asi 
include  page.ase 
include  pageall.ase 
include  sys.mac 
include  boot.ase 
include  prints.ase 

	PUBLIC	init_glbl_tss_page, AddTSSPage, RemoveTSSPage
;
; Initialize  system memory map with a global TSS page pointer page
; Call from process with system page tables!!!
;
seg386	SEGMENT	
init_glbl_tss_page	PROC	
	ALLOCEXT
	call	PageAlloc	; Allocate a page
				; Assume succeed, if not we have no memory!
	push	eax
	or	eax,PG_WRITEABLE; Make it writeable
	mov	ebx,eax		; Getting set to initialize system page table
	mov	edi,CR3		; System page dir
	ZA	edi		;
	mov	eax,TSSPAGE	; Highest possible block of 4MB
	call	PageTableEnterAddress	; Mapped it
				; This will stay mapped for life of OS
	pop	edi
	ZA	edi
	call	PageTableDisable; No entries in it yet
	ret
init_glbl_tss_page	ENDP	
;
; Allocate a TSS page and add it to the global directory
;
AddTSSPage	PROC	
	call	PageAlloc	; Allocate the TSS page
	jc	short nopage	; Get out if none
	push	eax		; Save address
	mov	edi,CR3		; Get system page dir
	ZA	edi		;
	mov	edi,[edi+TSSPAGE*4]; Get TSS pages table
	and	edi,NOT (PG_SIZE - 1)
	ZA	edi		;
	mov	ecx,PG_ITEMSPERTABLE;Items to loop through
checkforpage:
	dec	ecx		; Always look at next lowest item
	bt	DWORD PTR [edi+ecx*4],0 ; See if free
	jnc	short gotpage	; Low bit not set- is free
	inc	ecx		; Else look at next entry
	loop	checkforpage	;
	pop	eax		; We should never run out of entries so this is extra
	call	PageDealloc	; Deallocate the page
	stc			; Error
nopage:
	ret
gotpage:
	mov	eax,ecx		; Got a page, get index to eax
	pop	ebx		; ebx = physical address of TSS
	or	ebx,PG_WRITEABLE; We want it writeable
	call	PageTableEnterAddress ;Enter it
	shl	eax,PG_SHIFTSIZE; Now calculate the linear address
	add	eax,TSSBASE	;
	clc			; No errors
	ret
AddTSSPage	ENDP	
;
; Deallocate  a TSS page and remove from global directory
;
RemoveTSSPage	PROC	
	sub	eax,TSSBASE
	shr	eax, PG_SHIFTSIZE; Offset into a page table
	mov	edi,CR3		; Get system page table
	ZA	edi		;
	mov	edi,[edi + TSSPAGE * 4]; Get TSS pages table
	and	edi,NOT (PG_SIZE-1);
	ZA	edi		;  
	mov	ebx,[edi + eax * 4]; Get selected page entry
	mov	DWORD PTR [edi + eax * 4],PG_DISABLE; Mark it disabled
	bt	ebx,0		; See if was enabled
	jnc	short notthere	; No, get out
	and	ebx,NOT (PG_SIZE -1) ;Else get physical address
	mov	eax,ebx		;
	call	PageDeAlloc	; Deallocate the page
notthere:
	ret
RemoveTSSPage	ENDP	
seg386	ENDS	
END