;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;                                               
; Dirs.asm
;
; Function: Directory manipulation
;   Handles the B-TREE directory structure
;   Handles inserts, deletes, balancing
;
       	;MASM MODE
	.386p

include  errors.asi 
include  segs.asi 
include  floppy.asi 
include  fs.asi 
include  fs.ase 
include  buffers.ase 
include  prints.ase 

	PUBLIC	CompareName,FindEntry,InsertEntry,DeleteEntry
	PUBLIC	SplitSector,ConcatSector,RollRightSector
	PUBLIC	RollLeftSector
	PUBLIC  InsertFileName,DeleteFileName,SearchForFileName
	extrn roots : DWORD

seg386	SEGMENT	
;
; Compare two names
;
CompareName	PROC	
	push	ecx		; Save regs
	push	edi		;
	push	esi		;
	mov	ecx,FILENAMELEN	; Name length
	mov	esi,edx		; File to compare in edx
	mov	edi,eax		; Buffered file name in eax
	cld			; Set direction up
	repe	cmpsb		; Compare
	pop	esi		; Restore regs
	pop	edi		;
	pop	ecx		;
	ret
CompareName	ENDP	
;
; Find the position an entry would be inserted into in this block
; Binary search
;
FindEntry	PROC	
	push	edi		; Save edi
	movzx	ecx,[esi + DIRPAGE.ITEMS]	; Get total items
	add	esi,FIRSTDIRENTRY		; Point at first entry
	or	ecx,ecx				; Quit if no items
	jz	short fe_err			;
	mov	edi,esi				; edi point beyond last entry
	shl	ecx,DIRENTRYSHIFT		;
	add	edi,ecx				;
fe_lp:
	mov	eax,edi				; Find out if converged
	sub	eax,esi				;
	cmp	eax,DIRENTRYSIZE		; Quit if no midpoint
	jz	short fe_GotEntry		;
	bt	eax,DIRENTRYSHIFT		;
	mov	eax,0				; 
	jnc	short fe_iseven                 ; Else make sure we are
	mov	al,DIRENTRYSIZE			; Going to be on an even
fe_iseven:					; boundary when divide by 2
	add	eax,esi				; Find midpoint				
	add	eax,edi				;
	shr	eax,1				;
	call	CompareName			; Compare
	jz	short fe_IsEqual		; If equal, get out
	jl	short fe_movedown		; Else decide which way to go
	mov	esi,eax				; Move bottom up
	jmp	short fe_lp			; Next test
fe_movedown:
	mov	edi,eax				; Move bottom down
	jmp	short fe_lp			; Next test
fe_IsEqual:
	mov	esi,eax				; Found it, get out
	clc
	pop	edi
	ret
fe_GotEntry:
	mov	eax,esi				; Not in block,
	call	CompareName			; See which is bigger
	clc
	jle	short fe_nmarrange		; Leave ESI pointing above
	mov	esi,edi				;
fe_nmarrange:
	pop	edi				; Get out
	ret
fe_err:
	stc
	pop	edi
	ret
FindEntry	ENDP	
;
; Insert an entry in this block
;
InsertEntry	PROC	
	cmp	[edi + DIRPAGE.ITEMS],MAXDIRITEMS	; See if full
	jz	short ie_cantinsert		; Get out if so
	push	ecx				; Save regs
	push	edi				;
	push	esi				;
	add	edi,SECTORSIZE			; Find top
	mov	ecx,edi				; Get len to move
	sub	ecx,esi				;
	sub	ecx,DIRENTRYSIZE		;
	shr	ecx,2				; 4 bytes / move
	sub	edi,4				; Point at first word to move
	mov	esi,edi				; Find source of move
	sub	esi,DIRENTRYSIZE		;
	std					; Move down
	rep	movsd				;
	cld					;
	pop	edi				; Get position to insert
	push	edi				;
	mov	esi,edx				; Data to move in
	mov	ecx,DIRENTRYSIZE		; Length of data
	shr	ecx,2				; Moving words
	rep	movsd				; Move
	pop	esi				; Restore regs
	pop	edi				;
	pop	ecx				;
	inc	[edi + DIRPAGE.ITEMS]		; Inc count
	clc					; Get out
	ret
ie_cantinsert:
	stc					; Error
	ret
InsertEntry	ENDP	
;
; Delete an entry in this block
;
DeleteEntry	PROC	
	dec	[edi + DIRPAGE.ITEMS]		; Decrement items
	pushfd					; Save regs
	push	ecx				;
	push	esi				;
	push	edi				;
	mov	ecx,edi				; ECX will have len to move
	add	ecx,SECTORSIZE			;
	mov	edi,esi				; Find source
	add	esi,DIRENTRYSIZE		;
	sub	ecx,esi				; Calculate len
	shr	ecx,2				; Moving words
	rep	movsd				;
	pop	edi				; Get buffer
	push	edi				;
	add	edi,SECTORSIZE - DIRENTRYSIZE	; Point at last entry in buffer
	mov	ecx,DIRENTRYSIZE/4		; Fill it with FFs
	sub	eax,eax				;
	dec	eax				;
	rep	stosd				;
	pop	edi				; Restore regs
	pop	esi				;
	pop	ecx				;
	popfd					; Get status of decrement
	clc					; Get out
	ret
DeleteEntry	ENDP	
;
; Split a sector into two sectors if an insert overflows
;

SSP_NEWDIR	= ebp+8				; Directory to add
SSP_OLDSECTOR	= ebp-4				; Original sector
SSP_BUFFEROFS	= ebp-8				; Offset to insertion pt
SSP_BUFFER	= ebp-12			; Original buffer
SSP_NEWSECTOR	= ebp-16			; New sector
SSP_NEWBUFFER	= ebp-20			; New buffer
SSP_MOVELEN	= ebp-24			; Amount to move
SSP_INSERTSECTOR = ebp-28			; Place to insert overflow entry
SSP_OLDCOUNT	= ebp - 32			; Items in orig sector
SSP_NEWCOUNT	= ebp - 36			; Items in new sector
SSP_INSERTDATA  = ebp-36-DIRENTRYSIZE		; Data to insert
SplitSector	PROC	
	ENTER	36+DIRENTRYSIZE,0		; Space for params
	sub	esi,edi				; Get buffer offset
	mov	[SSP_BUFFEROFS],esi		; Save offset
	mov	[SSP_OLDSECTOR],edx		; Save orig sector
	call	AllocDirSector			; Allocate a new sector
	jc	short ss_err			; Err if cant
	call	DirtyBuffer			; Make it dirty
	mov	[SSP_NEWSECTOR],eax		; Save sector number
	mov	[SSP_NEWBUFFER],esi		; And new buffer address
	mov	edx,[SSP_OLDSECTOR]		; Read the original sector
	call	ReadSector			;
	jc	short ss_err			;
	call	DirtyBuffer			; Make it dirty
	mov	[SSP_BUFFER],esi		; Save buffer
	mov	edi,[SSP_NEWBUFFER]		;
	mov	ecx,FIRSTDIRENTRY/4             ; Copy the block header
	cld					;
	rep	movsd				;
	cmp	DWORD PTR [SSP_BUFFEROFS],FIRSTDIRENTRY + (SECTORSIZE - FIRSTDIRENTRY)/2 ; See if inserting right at middle
	je	ss_promotenewdir		; Yep, promote it
	pushfd
	
	mov	esi,[SSP_NEWDIR]		; Move the new directory
	lea	edi,[SSP_INSERTDATA]		; To local area
	mov	ecx,DIRENTRYSIZE / 4		;
	rep	movsd				;
	popfd
	jc	short ss_insertinold		; Branch if it goes in orig dir
ss_insertinnew:
     	mov	DWORD PTR [SSP_MOVELEN],DIRENTRYSIZE*(DIRORDER-1)/4	; amount to move
	mov	DWORD PTR [SSP_NEWCOUNT],DIRORDER-1	; Items in new after copy
	mov	DWORD PTR [SSP_OLDCOUNT],DIRORDER	; Items in old after copy
	mov	eax,[SSP_NEWSECTOR]		; Get Sector to insert in
	mov	esi,[SSP_BUFFER]		; Source buffer
	add	esi,FIRSTDIRENTRY + DIRENTRYSIZE * DIRORDER ; Point at what to move up
	jmp	short ss_insertcommon
ss_err:
	jmp	ss_out
ss_insertinold:
	mov	DWORD PTR [SSP_MOVELEN],DIRENTRYSIZE*DIRORDER/4	; Amount to move
	mov	DWORD PTR [SSP_NEWCOUNT],DIRORDER	; Items in new after copy
	mov	DWORD PTR [SSP_OLDCOUNT],DIRORDER-1	; Items in old after copy
	mov	eax,[SSP_OLDSECTOR]		; Sector to insert in
	mov	esi,[SSP_BUFFER]		; Source buffer
	add	esi,FIRSTDIRENTRY + DIRENTRYSIZE *(DIRORDER-1) ; Point at what to move up
ss_insertcommon:
	mov	[SSP_INSERTSECTOR],eax		; Save insert sector
	mov	edi,[SSP_NEWDIR]		; Copy move up name to callers param
	mov	ecx,DIRENTRYSIZE/4		;
	cld					;
	push	edi				;
	rep	movsd				;
	push	esi				; Starting position to move from
	sub	esi,[SSP_BUFFER]		; Save buffer offset
	mov	[SSP_BUFFEROFS],esi		;
	pop	esi				;
	mov	eax,[esi + LESS] 		; NEWPAGE.PAGELESS is the
	mov	edi,[SSP_NEWBUFFER]		; MOVEDUP.MORE
	mov	[edi + DIRPAGE.PAGELESS],eax	;
	pop	edi				;
	mov	eax,[SSP_NEWSECTOR]		; Movedup.MORE is the new sector
	mov	[edi + DIRENTRY.MORE],eax	;  just created
	jmp	short ss_copy
ss_promotenewdir:
	mov	edi,[SSP_NEWDIR]		; EDI = new directory
	mov	esi,[SSP_NEWBUFFER]		; ESI = new buffer
	mov	eax,[edi + DIRENTRY.MORE]	; NEWPAAGE.PAGELESS is 
	mov	[esi + DIRPAGE.PAGELESS],eax	;   NEWENTRY.MORE
	mov	eax,[SSP_NEWSECTOR]		; NEWENTRY.MORE is our newsector
	mov	[edi + DIRENTRY.MORE],eax	;
	mov	DWORD PTR [SSP_MOVELEN],DIRENTRYSIZE*DIRORDER/4 ;Amount to move
	mov	DWORD PTR [SSP_NEWCOUNT],DIRORDER	; New counts after move
	mov	DWORD PTR [SSP_OLDCOUNT],DIRORDER	;
	mov	DWORD PTR [SSP_INSERTSECTOR],0	; Nothing to insert
	mov	DWORD PTR [SSP_BUFFEROFS],FIRSTDIRENTRY +DIRENTRYSIZE*DIRORDER ; Position to move from
ss_copy:
	mov	esi,[SSP_BUFFER]		; Original buffer
	mov	eax,[DWORD ptr SSP_OLDCOUNT]	; Count to put in it
	mov	[BYTE PTR esi + DIRPAGE.ITEMS],al;
	add	esi,[SSP_BUFFEROFS]		; Position to move from
	mov	edi,[SSP_NEWBUFFER]		; New buffer
	mov	eax,[DWORD ptr SSP_NEWCOUNT]	; Count to put in it
	mov	BYTE PTR [edi + DIRPAGE.ITEMS],al;
	add	edi,FIRSTDIRENTRY		; Position to move to
	mov	ecx,[SSP_MOVELEN]		; Amount to move
	cld					; Do move
	rep	movsd				;
	mov	edi,[SSP_BUFFER]                ; Position to wipe at
	add	edi,[SSP_BUFFEROFS]		;
	mov	ecx,[SSP_MOVELEN]		; Amount to wipe	
	test	DWORD PTR [SSP_INSERTSECTOR],-1	; See if promoting New entry
	jz	short ss_nodiradj		; Yes, don't wipe promoted
	sub	edi,DIRENTRYSIZE		; Else wipe promoted entry
	add	ecx,DIRENTRYSIZE/4		;
ss_nodiradj:
	sub	eax,eax				; Value to wipe with = -1
	dec	eax				;
	rep	stosd				; Do wipe
	test	DWORD PTR [SSP_INSERTSECTOR],-1	; See if promoting New entry
	jz	short ss_checkroot		; Yep, see if root
	mov	eax,[SSP_INSERTSECTOR]          ; Else find out where to insert it
	cmp	eax,[SSP_OLDSECTOR]		; Old sector?
	mov	esi,[SSP_BUFFER]		; Assume so
	jz	short ss_insold			; Yes!
	mov	esi,[SSP_NEWBUFFER]		; Else new sector
ss_insold:
	mov	edi,esi				; EDI = buffer
	lea	edx,[SSP_INSERTDATA]		; Data to insert
	call	FindEntry			; Find insert position
	call	InsertEntry			; Do insert
ss_checkroot:
	mov	eax,[SSP_OLDSECTOR]		; Now see if original sector wsa root
	cmp	eax,[roots + ebx * 4]		;
	jnz	short ss_out			; No, get out
	call	AllocDirSector			; Yes, allocate a new root
	jc	ss_err
	mov	[esi + DIRPAGE.ITEMS],1		; With one item
	mov	eax,[SSP_OLDSECTOR]		; PAGELESS is old root
	mov	[esi + DIRPAGE.PAGELESS],eax	;
	mov	edi,esi				; Copy new entry to root dir
	mov	esi,[SSP_NEWDIR]		;
	add	edi,FIRSTDIRENTRY		;
	mov	ecx,DIRENTRYSIZE		;
	cld					;
	rep	movsb				;
	push	edx				; Read BOOT sector
	sub	edx,edx				;
	call	ReadSector			;
	pop	edx				;
	jc	ss_err				;
	call	DirtyBuffer			; Dirty it
	mov	[esi + FSPAGE.ROOTDIR],edx	; New root
	mov	[roots + ebx * 4],edx		;
ss_out:
	mov	eax,[SSP_NEWDIR]		; Return new directory
	LEAVE					; Get out
	ret	04
SplitSector	ENDP	
;
; Deleting, concatenate two sectors
;
CSP_NEWDIR	= ebp + 8
ConCatSector	PROC	
	Enter	0,0
	push	eax				; Read the left sector
	call	ReadSector			;
	jc	short csp_error			;
	call	DirtyBuffer			; Make it dirty
	mov	edi,esi				; EDI = left
	pop	edx				;
	push	edx				; Read the right sector
	call	ReadSector			;
	jc	short csp_error			;
	call	DirtyBuffer			; Make it dirty
	push	edi				;
	push	esi
	movzx	ecx,[edi + DIRPAGE.ITEMS]	; Point after data of left
	shl	ecx,DIRENTRYSHIFT		;
	add	edi,ecx				;
	add	edi,FIRSTDIRENTRY               ;
	movzx	ecx,[esi + DIRPAGE.ITEMS]	; Get amount to move in DWORDS
	shl	ecx,DIRENTRYSHIFT-2		;
	add	esi,FIRSTDIRENTRY		; Get start position
	cld					;
	rep	movsd				; Do move
	pop	esi				;
	mov	eax,[esi + DIRPAGE.PAGELESS]    ; CENTERENTRY.MORE = RIGHT.PAGELESS
	mov	edi,[CSP_NEWDIR]		;
	mov	[edi + DIRENTRY.MORE],eax	;
	mov	edi,esi				; Wipe out right sector
	mov	ecx,SECTORSIZE / 4		;
	sub	eax,eax				;
	dec	eax				;
	rep	stosd				;
	pop	edi                             ; Get left buffer
	mov	[edi + DIRPAGE.ITEMS],MAXDIRITEMS-1 ; Almost full
	mov	esi,edi				; ESI = EDI
	mov	edx,[CSP_NEWDIR]		; Data to insert is in DX
	call	FindEntry			; Find entry
	call	InsertEntry			; Insert entry
	pop	eax				; Deallocate right sector
	call	DeallocSector			;
	jc	short csp_error2			;
csp_out:
	LEAVE
	ret	04
csp_error:
	pop	eax				; Clear stack
csp_error2:
	jmp	short csp_out			; Get out
ConcatSector	ENDP	

;
; Delete underflow : Roll data right
;
RSP_DIR	=	ebp + 8				; Rolling entry
RSP_DIRBUF = 	ebp - 4				; Buffer rolling entry is in
RSP_DEST =	ebp-8				; Right buffer
RollRightSector	PROC	
	ENTER	8,0
	mov	[RSP_DIRBUF],edi
	mov	[RSP_DEST],eax
	push	eax				; Read left              	
	call	ReadSector			;
	pop	edx				;
	jc	short rrs_error			;
	call	DirtyBuffer			; Dirty it
	mov	edi,esi				;
	call	ReadSector			; Read right
	jc	short rrs_error			;
	call	DirtyBuffer			; Dirty it
	xchg	esi,edi				; LEFT in ESI, RIGHT in EDI
	mov	edx,[RSP_DIR]			; Rolling.MORE = RIGHT.PAGELESS
	mov	eax,[edi + DIRPAGE.PAGELESS]	;
	mov	[edx + DIRENTRY.MORE],eax	;
	push	edi				;
	push	esi				; Insert ROLLING in RIGHT
	mov	esi,edi				;
	add	esi,FIRSTDIRENTRY		;
	call	InsertEntry			;
	mov	edi,[RSP_DIRBUF]		; Delete ROLLING
	mov	esi,edx				;
	call	DeleteEntry			;
	pop	esi				;
	mov	edi,esi				; Point to last entry in left
	movzx	ecx,[esi + DIRPAGE.ITEMS]	;
	dec	ecx				;
	shl	ecx,DIRENTRYSHIFT               ;
	add	edi,ecx				;
	add	edi,FIRSTDIRENTRY		;
	mov	eax,[edi + DIRENTRY.MORE]	; MOVUP.MORE->RIGHT.PAGELESS
	xchg	[esp],edi			;
	mov	[edi + DIRPAGE.PAGELESS],eax	;
	mov	edi,[esp]			;
	mov	eax,[RSP_DEST]			; RIGHT->MOVEUP.MORE
	mov	[edi + DIRENTRY.MORE],eax	;
	mov	edx,edi				;
	push	esi                             ; Insert Moveup where ROLLING was
	mov	esi,[RSP_DIR]			;
	mov	edi,[RSP_DIRBUF]		;
	xchg	esi,edi				;
	call	DirtyBuffer			; Dirty buffer
	xchg	esi,edi				;
	call	InsertEntry			;
	pop	edi				; Now delete it from left
	pop	esi                             ;
	call	DeleteEntry			;
rrs_out:
	LEAVE
	ret	04
rrs_error:
	jmp short rrs_out
RollRightSector	ENDP	
;
; Delete underflow: Roll left
;
RollLeftSector	PROC	
	ENTER	8,0
	mov	[RSP_DIRBUF],edi		; Save Rolling buffer
	mov	[RSP_DEST],eax			; And right sector
	push	eax				; Read left
	call	ReadSector			;
	pop	edx				;
	jc	short rls_error			;
	call	DirtyBuffer			; Dirty it
	mov	edi,esi				;
	call	ReadSector			; Read right
	jc	short rls_error			;
	call	DirtyBuffer			; Dirty it
	mov	edx,[RSP_DIR]			; RIGHT.PAGELESS->ROLLING.MORE
	mov	eax,[esi + DIRPAGE.PAGELESS]	;
	mov	[edx + DIRENTRY.MORE],eax	;
	push	esi				;
	mov	esi,edi				; Move to end of left
	movzx	ecx,[esi + DIRPAGE.ITEMS]	;
	shl	ecx,DIRENTRYSHIFT		;
	add	esi,ecx				;
	add	esi,FIRSTDIRENTRY		;
	call	InsertEntry			; Move rolling to left
	mov	edi,[RSP_DIRBUF]		;
	mov	esi,edx				;
	call	DeleteEntry			; Delete rolling from its buffer
	pop	esi				;
	mov	edi,esi				;
	add	edi,FIRSTDIRENTRY		;
	push	edi				; FIRSTRIGHT.MORE->RIGHT.PAGELESS
	mov	eax,[edi + DIRENTRY.MORE]	;
	mov	[esi + DIRPAGE.PAGELESS],eax	;
	mov	eax,[RSP_DEST]			; RIGHT-> FIRSTRIGHT.MORE
	mov	[edi + DIRENTRY.MORE],eax	;
	mov	edx,edi				;
	push	esi				;
	mov	esi,[RSP_DIR]			; Insert Firstright where rolling was
	mov	edi,[RSP_DIRBUF]		;
	xchg	esi,edi				;
	call	DirtyBuffer			; Dirty rolling buffer
	xchg	esi,edi				;
	call	InsertEntry			;
	pop	edi				;
	pop	esi				;
	call	DeleteEntry			; Delete firstright from orig pos
rls_out:
	LEAVE
	ret	04
rls_error:
	jmp short rls_out
RollLeftSector	ENDP	
;
; Delete from middle : Roll bottom up
;
MBEP_DEST =	ebp + 8
MoveBottomEntry	PROC	
	enter	0,0
	push	edx				; Save sector and offset
	sub	esi,edi				; to move into
	push	esi				;
	add	esi,edi				;
mbe_getlp:
	mov	edx,[esi + LESS]		; Grab what is less
	call	ReadSector			; Read the sector
	jc	short mbe_error			;
	mov	edi,esi				;
	movzx	eax,[esi + DIRPAGE.ITEMS]	; Point at end
      	shl	eax,DIRENTRYSHIFT		;
	add	eax,FIRSTDIRENTRY		;
	add	esi,eax				;
	bt	DWORD PTR [edi + DIRPAGE.DPFLAGS],DFL_LEAF ; See if bottom
	jnc	short mbe_getlp			; Loop if not
	sub	esi,DIRENTRYSIZE		; Point at last entry
	mov	ecx,esi				;
	pop	edi				; Restore sector and offset
	pop	edx				; to move into
	call	ReadSector			;
	jc	short mbe_error2		;
	push	esi				;
	push	edi				;
	add	edi,esi				; Move the entry there,
	mov	esi,ecx				; Keeping MORE intact
	push	esi				;
	mov	ecx,(DIRENTRYSIZE / 4) -1	;
	rep	movsd				;
	pop	esi				;
	mov	edi,[MBEP_DEST]			; Move the entry into caller's
	mov	ecx,DIRENTRYSIZE / 4		; Buffer for recursive delete
	rep	movsd				;
	pop	edi				;
	pop	esi				;
	add	edi,esi				; Restore esi and edi
	xchg	esi,edi				;
mbe_out:
	leave
	ret	04
mbe_error:
	pop	edi
	pop	edx
mbe_error2:
	jmp	mbe_out
MoveBottomEntry	ENDP	
;
; Insert a file name
;
IFP_NEWDIR = 	ebp + 8				; What to insert
IFP_SECTOR =	ebp-4				; Sector we are analyzing
IFP_NAME =	ebp -4- DIRENTRYSIZE		; Current name for recursion
InsertFileName	PROC	
	ENTER	4+DIRENTRYSIZE,0		; Save space for vars
	mov	esi,[IFP_NEWDIR]		; Copy name to local area
	lea	edi,[IFP_NAME]			;
	mov	[IFP_NEWDIR],edi		; Pointing param at local
	mov	ecx,DIRENTRYSIZE / 4		;
	cld					;
	rep	movsd				;
	call	LoadRootDir			; Start with the root
	jc	short if_error			;
	mov	eax,edx				; In EAX
	jmp	short if_2			;
if_entry2:
	ENTER	4,0				; Come here for recursion
if_2:
	mov	edx,eax				; Get this sector
	mov	[IFP_SECTOR],eax		; Save it
	call	ReadSector			; Read it
	jc	short if_error			;
	mov	edi,esi				; Find the entry
	mov	edx,[IFP_NEWDIR]		;
	call	FindEntry			;
	jc	short if_insert			; Empty root, just insert
	jz	short if_gotentry		; Exists, go proclaim error
	bt	DWORD PTR [edi + DIRPAGE.DPFLAGS],DFL_LEAF ; See if bottom
	jc	short if_insert			; Yes, just insert
	mov	eax,[esi + LESS]		; Else recurse on less
	push	DWORD PTR [IFP_NEWDIR]		;
	call	if_entry2			;
	jc	short if_error			;
	mov	edi,[IFP_NEWDIR]		; See if to recurse
	test	BYTE PTR [edi],-1		;
	jz	short if_done			; No, get out
	mov	edx,[IFP_SECTOR]		; Else reread sector
	call	ReadSector			;
	jc	short if_error			;
	mov	edi,esi				; Find the entry
	mov	edx,[IFP_NEWDIR]		;
	call	FindEntry			;
if_insert:                       
	call	InsertEntry			; Insert here
	jc	short if_split			; Split if too full
	mov	esi,edi				;
	call	DirtyBuffer			; Else just dirty buffer
	mov	edi,[IFP_NEWDIR]		; And mark done
	mov	BYTE PTR [edi],0		;
	jmp	short if_done			;
if_split:
	mov	edx,[IFP_SECTOR]		; Splitting, call splitter
	push	DWORD PTR [IFP_NEWDIR]		;
	call	SplitSector                     ;
	jc	short if_error
if_done:
	leave
	ret	04
if_error:
	jmp	short if_done
if_gotentry:
	stc
	mov	al,ERR_FILEXISTS
	jmp	short if_done
InsertFileName	ENDP	
;
; Delete file name
;
DFP_SHIFT =	ebp + 12			; Location of flag for recursion: 0 for top level
DFP_DIR   =	ebp + 8				; Name to delete
DFP_TOSHIFT = ebp - 4				; Set true if recursion necessary
DFP_NAME   =	ebp - 4- DIRENTRYSIZE		; Local buffer for recursion
DeleteFileName	PROC	
	ENTER	4+DIRENTRYSIZE,0		; Save space
	mov	esi,[DFP_DIR]			; Move file name to local buffer
	lea	edi,[DFP_NAME]			;
	mov	[DFP_DIR],edi			;
	mov	ecx,DIRENTRYSIZE / 4		;
	cld					;
	rep	movsd				;
	call	LoadRootDir			; Start with root dir
	jc	df_error			;
	mov	eax,edx				; in EAX
	jmp	short df_2			;
df_entry2:
	enter	4,0				; Recursion comes here
df_2:
	mov	DWORD PTR [DFP_TOSHIFT],0	; Assume no upward shift
	call	ReadSector			; Read current sector
	jc	df_error			;
	mov	edi,esi				; Find entry in sector
	push	edx				;
	mov	edx,[DFP_DIR]			;
	call	FindEntry			;
	pop	edx				;
	jne	short df_notfound		; No match, possibly recurse
	push	esi				; Else dirty the buffer
	mov	esi,edi				;
	call	DirtyBuffer			;
	pop	esi				;
	bt	DWORD PTR [edi + DIRPAGE.DPFLAGS],DFL_LEAF ; If this is not a leaf
	jnc	short df_movetomiddle		; Move to middle
	call	DeleteEntry			; Delete leaf entry
	jz	df_cleardir			; Killed root, get out
	cmp	BYTE PTR [edi + DIRPAGE.ITEMS],DIRORDER; See if underflow
	jnc	short df_nounderflow		; No, get out
	mov	edi,[DFP_SHIFT]			; See if top level
	or	edi,edi				;
	jz	short df_nounderflow		; Allowed to underflow root
	inc	BYTE PTR [edi]			; Else there will be a higher-level
df_nounderflow:					;   concatenation or roll
	jmp	df_out
df_movetomiddle:
	mov	eax,[DFP_DIR]			; Move bottom entry to middle
	push	eax				;  Leaves name of bottom entry in buffer
	call	MoveBottomEntry			;
	jc	df_error			;
df_notfound:
	bt	DWORD PTR [edi + DIRPAGE.DPFLAGS],DFL_LEAF ; IF a leaf, file doesn't exist
	jc	df_none
	push	esi				; Else recurse on less
	push	edi				;
	push	edx				;
	mov	edx,[esi + LESS]		;
	lea	edi,[DFP_TOSHIFT]		;
	push	edi				;
	push	DWORD PTR [DFP_DIR]		;
	call	df_entry2			;
	pop	edx				;
	pop	edi				;
	pop	esi				;
	jc	df_error			;
	test	DWORD PTR [DFP_TOSHIFT],-1	; See if there was an underflow
	jz	df_out				; Quit if not
	sub	esi,edi				; Else read current sector
	mov	edi,esi				;
	call	ReadSector			;
	jc	df_error			;
	xchg	esi,edi				; See if pointing past last entry
	mov	eax,esi				;
	add	esi,edi				;
	sub	eax,FIRSTDIRENTRY		;
	shr	eax,DIRENTRYSHIFT		;
	cmp	al,[edi + DIRPAGE.ITEMS]	;
	jc	df_noadjust			;
	sub	esi,DIRENTRYSIZE                ; Yes, point to last entry
df_noadjust:
	mov	edx,[esi + LESS]		; Load LESS sector
	push	esi				;
	call	ReadSector			;
	movzx	ecx,[esi + DIRPAGE.ITEMS]	; Get items in it
	pop	esi				;
	jc	df_error2			;
	mov	edx,[esi + DIRENTRY.MORE]	; Load MORE sector
	push	esi				;
	push	ecx				;
	call	ReadSector			;
	pop	ecx				;
	pushfd					;
	movzx	eax,[esi + DIRPAGE.ITEMS]	; Get items in it
	add	cl,[esi + DIRPAGE.ITEMS]	; Get total items
	popfd					;
	pop	esi				;
	jc	df_error2			;
	cmp	cl,MAXDIRITEMS			; If can't be concatted we roll
	jnc	df_roll			;
	mov	edx,[esi + LESS]		; Get params for concat
	mov	eax,[esi + DIRENTRY.MORE]	;
	push	edi				; Central dir entry goes in buffer
	push	esi				;
	mov	edi,[DFP_DIR]			;
	cld					;
	mov	ecx,DIRENTRYSIZE /4		;
	rep	movsd				;
	pop	esi				;
	push	esi				;
	mov	edi,[DFP_DIR]			;
	push	edi				;
	call	ConcatSector			; Do concat
	pop	esi				;
	pop	edi				;
	jc	df_error			;
	mov	eax,[DFP_SHIFT]			; Now if this isn't top level
	or	eax,eax				;
	jz	short df_conctop		;
	inc	DWORD PTR [eax]			; We have to delete the central entry
	jmp	short df_out			;   recursively
df_conctop:
	cmp	BYTE PTR [edi + DIRPAGE.ITEMS],1; Else see if we will empty it
	jz	short df_NewRoot		; Yeah, new root
df_delrootent:
	call	DeleteEntry			; Else just delete root entry
	mov	esi,edi				;
	call	DirtyBuffer			; Mark dirty
	jmp	short df_out			; Get out
df_NewRoot:
	bts	DWORD PTR [edi + DIRPAGE.DPFLAGS],DFL_LEAF ; See if it is a leaf
	jc	short df_delrootent		; Yeah, just delete the last file
	mov	esi,edi				; Else dirty buffer
	call	DirtyBuffer			;
	mov	eax,[edi + DIRPAGE.PAGELESS]	; Get the pageless entry
	push	eax				; Wipe the sector out
	sub	eax,eax				;
	dec	eax				;
	mov	ecx,SECTORSIZE / 4		;
	rep	stosb				;
	sub	edx,edx				; Read Boot sector
	call	ReadSector			;
	pop	eax				;
	jc	short df_error			;
	call	DirtyBuffer			; Dirty it
	mov	[roots + ebx * 4],eax		; Mark a new root
	xchg	[esi + FSPAGE.ROOTDIR],eax	;
	call	DeallocSector			;
	jc	short df_error			;
	jmp	short df_out			; Get out
df_roll:
	cmp	al,DIRORDER			; See which way to roll
	mov	edx,[esi + LESS]		; Roll params
	mov	eax,[esi + DIRENTRY.MORE]	;
	jc	short df_doright                ;
	push	esi				;
	call	RollLeftSector                  ; Left roll
	jc	short df_error			;
	jmp	short df_out			; Get out
df_doright:
	push	esi				; Right roll
	call	RollRightSector			;
	jc	short df_error			;
df_cleardir:					; Get out
df_out:						;
	leave					;
	ret	08				; Rid params
df_none:
	stc
	mov	al,ERR_FILENOTFOUND
	jmp	short df_out
df_error2:
	pop	esi
df_error:
	jmp	short df_out
DeleteFileName	ENDP	
;
; Search for file name
;
SFP_NAME = ebp - 4				; Name to search for
SearchForFileName	PROC	
	ENTER	4,0
	mov	[SFP_NAME],edx			; Save name
	call	LoadRootDir			; Start at root
	jc	short sff_error			;
sff_2:
	call	ReadSector			; Read sector
	jc	short sff_error			;
	mov	edi,esi				; Find entry
	mov	edx,[SFP_NAME]			;
	call	FindEntry			;
	jc	short sff_noentry		; Empty root, no entry
	jz	short sff_gotentry		; Else got it if match
	bt	DWORD PTR [edi + DIRPAGE.DPFLAGS],DFL_LEAF ; Check for leaf
	jc	short sff_noentry		; No entry if it is
	mov	edx,[esi + LESS]		; Else recurse on the less
	jmp	sff_2				;
sff_noentry:
	stc					; Error - file not found
	mov	al,ERR_FILENOTFOUND		;
sff_error:
	leave					;
	ret
sff_gotentry:
	mov	eax,[esi + DIRENTRY.ENTRY]	; Pull file block entry
	clc
	leave
	ret
SearchForFileName	ENDP	
seg386	ENDS	
END