/*
 * Find the next lowest prime value given a number
 *
 * David Lindauer, Feb 1993
 */
#include <stdio.h>
/*
 * Should be equal to MAXPRIME
 */
#define MAXTABLE 128
/* We need to know all primes up to the square root of the max input
 * so this will allow prime checking up to 32K
 */
#define MAXPRIME 128

int primetable[MAXTABLE];
int numprimes = 0;

void AppendPrime(int prime)
/*
 * Put a prime into the table
 */
{
  primetable[numprimes++] = prime;
}
int CheckPrime(int number)
/*
 * See if the number is prime
 */
{
  int i;
  for (i=0; i < numprimes; i++) {
		if (number == primetable[i])
			return (1);
    if ((number % primetable[i]) == 0)
      return(0);
	}

  return(1);
}
void main(int argc, char *argv[])
{
  int i,max;
	max = atoi(argv[1]);
	if (argc != 2 || max < 2) {
		printf("Put maximum value for prime on command line\n");
		exit(1);
	}

	/* Enter primes into the prime table */
  AppendPrime(2);
  for (i=3; i< MAXPRIME; i++)
    if (CheckPrime(i)) {
      AppendPrime(i);
    }

  printf("\n");
  /* Find the next lowest prime */
  for (i=max; i > max-200; i--)
    if (CheckPrime(i)) {
			printf("Answer: %d\n",i);
      break;
    }
}