;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Vga.asm
;
; Function: VGA graphics mode functionality
;   Handles text output to VGA subsystem
;
	;MASM MODE
	.386p
LBLACK	= 7

include  segs.asi 
include  vga.asi 
include  vga.mac 

	PUBLIC _VertBar, _HorizBar, _FillCorner
	PUBLIC _DrawTextChar, _Underline
	PUBLIC _DrawWideChar, _DrawTallChar

seg386data	SEGMENT	
	; These are specific to one black line
select	dw	0
right	db	2,6,0eh,1eh,3eh,7eh,0feh
left	db	07fh,7eh,7ch,78h,70h,60h,40h
seg386data	ENDS	

seg386	SEGMENT	
_HorizBar	PROC	
	push	es
	GETGCR
	GETSEG
	WRMODE2
	add	edi,GRAPHBASE
	mov	al,bl
@@bllp2:
	PUTCOLOR
	LOOP	@@bllp2
	WRMODE0
	pop	es
	ret
_HorizBar	ENDP	
_VertBar	PROC	
	push	es
	GETGCR
	WRMODE2
	GETSEG
	add	edi,GRAPHBASE
	SETMASK	bh

	mov	al,bl

@@bllp3:
	PUTCOLOR	LATCH
	add	edi,79
	LOOP	@@bllp3
	SETMASK	0ffh
	WRMODE0
	pop	es
	ret
_VertBar	ENDP	
_FillCorner	PROC	
	push	es
	add	edi,GRAPHBASE
	mov	esi,offset dgroup:right
	and	dl,0ffh
	test	dl,-1
	jz	@@right
	mov	esi,offset dgroup:left
	add	esi,edx
@@right:
	GETGCR
	GETSEG
	WRMODE3
	SETCOLOR bl
	SETMASK	0ffh
@@lp:
	mov	al,es:[edi]
	movsb
	add	edi,79
	loop	@@lp
	WRMODE0
	pop	edi
	pop	esi
	pop	ebp
	ret
_FillCorner	ENDP	

_DrawTextChar	PROC	
	push	es
	GETGCR					; put is in write mode 3
	WRMODE3
	GETSEG
	add	edi,GRAPHBASE
	SETCOLOR bl
	PUTBG
	SETCOLOR bh
	mov	ecx,16
@@lp1:
	movsb
	add	edi,79
	loop	@@lp1

	WRMODE0
	pop	es
	ret
_DrawTextChar	ENDP	
_DrawWideChar	PROC	
	push	es
	GETGCR					; put is in write mode 3
	WRMODE3
	GETSEG
	add	edi,GRAPHBASE
	SETCOLOR bl
	PUTBG
	SETCOLOR bh
	mov	ebx,16
@@lp2:
	push	ebx
	lodsb
	mov	ecx,8
@@lp3:
	shr	al,1
	pushf
	rcr	bx,1
	popf
	rcr	bx,1
	loop	@@lp3
	mov	al,bh
	stosb
	mov	al,bl
	stosb
	add	edi,78
	pop	ebx
	dec	ebx
	jnz	@@lp2

	WRMODE0
	pop	es
	ret
_DrawWideChar	ENDP	
_DrawTallChar	PROC	
	push	es
	GETGCR					; put is in write mode 3
	WRMODE3
	GETSEG
	add	edi,GRAPHBASE
	SETCOLOR bl
	PUTBG
	SETCOLOR bh
	mov	ebx,16
@@lp4:
	push	ebx
	lodsb
	mov	ecx,8
@@lp5:
	shr	al,1
	pushf
	rcr	bx,1
	popf
	rcr	bx,1
	loop	@@lp5
	mov	al,bh
	stosb
	mov	al,bl
	stosb
	add	edi,78
	mov	al,bh
	stosb
	mov	al,bl
	stosb
	add	edi,78
	pop	ebx
	dec	ebx
	jnz	@@lp4

	WRMODE0
	pop	es
	ret
_DrawTallChar	ENDP	
_Underline	PROC	
	ret
_Underline	ENDP	
;
seg386	ENDS	

END