;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Pageall.asm
;
; Function: Allocate/deallocate a page of physical memory
;   Handles managing the page allocation map
;   Handles counting base memory
;
	;MASM MODE
	.386p

include  segs.asi 
include  sys.mac 
include  ints.asi 
include  os.asi 
include  ints.ase 
include  page.asi 
include  page.ase 
include  pageall.asi 
include  boot.ase 
include  prints.ase 

	PUBLIC	PageAllocInit,PageAlloc,PageDealloc, CountBaseMem
	PUBLIC memmap
seg386data	SEGMENT	
memmap	db	PG_MB * (PG_MEMSIZE SHR 12) / 8 DUP (0) ; Map of used pages
seg386data	ENDS	

seg386	SEGMENT	
;
; Count amount of base memory available
;
CountBaseMem	PROC	
	sub	edx,edx			; Count = 0
	mov	esi,offset dgroup:memmap	; Get memory map and count
	mov	ecx,(PG_STARTOFEXTMEM SHR PG_SHIFTSIZE) / 8 / PG_MBPERTABLE
cblp:
	lodsd				; Get 32 bits
	push	ecx			; Set to count through these
	mov	ecx,32			;
cblp2:
	shr	eax,1			; This bit set?
	jnc	short nobit		; No, continue
	inc	edx			; Yes, inc count
nobit:
	loop	cblp2			; Loop through 32 bits
	pop	ecx			;
	loop	cblp			; Loop through lower 1MB
	ret
CountBaseMem	ENDP	
;
; Alocate a page
;   entry: ax = TRUE do system pages as well
;   exit : ax = page address
;
PageAlloc	PROC	
	push	esi
	push	ecx
	push	ebx
	mov	esi,offset dgroup:memmap - 4	; Start at beginning
	mov	ecx,PG_MB * (PG_MEMSIZE SHR PG_SHIFTSIZE) / 8 /PG_MBPERTABLE / 4
	or	al,al			; If NZ
	jnz	short anymem			; search lower 640K first
	add	esi,(PG_STARTOFEXTMEM SHR PG_SHIFTSIZE) / 8	; Else only search ext
	sub	ecx,(PG_STARTOFEXTMEM SHR PG_SHIFTSIZE) / 8 / PG_MBPERTABLE
anymem:
	add	esi,4			; Next word
	bsf	eax,DWORD PTR [esi]	; See if any bits set
	loopz	anymem			; Loop while not
	or	ecx,ecx			; Quit if nothing found
	jz	short notfound		;
	btr	[esi],eax		; Else reset the bit
	sub	esi,offset dgroup:memmap	; Find the dword address
	mov	ebx,esi			; Make it a relative bit #
	shl	ebx,3			; ebx is 32 * WORD #			;
	add	eax,ebx			; Add the bit within the word
	shl	eax,PG_SHIFTSIZE	; Make it  an address
	clc
	pop	ebx
	pop	ecx
	pop	esi
	ret
notfound:
	pop	ebx
	pop	ecx	
	pop	esi
	sub	eax,eax 		; Nothing found
	stc
	ret		
PageAlloc	ENDP	
;
; Deallocate a page
;
PageDealloc	PROC	
	shr	eax,PG_SHIFTSIZE	; Get the page number
	bts	DWORD PTR [memmap],eax	; Set the bit of this page
	ret				; Done
PageDealloc	ENDP	
;
; Initialize the page alloc scheme
;
PageAllocInit	PROC	
	mov	eax,offset dgroup:dgroup:eom	; Get end of program space
	add	eax,[zero]		; Make absolute
	add	eax,PG_SIZE -1		; Index to next whole page
	shr	eax,PG_SHIFTSIZE	; Make it a page address
	shl	eax,PG_SHIFTSIZE	;
$$lp:
	cmp	eax,PT_SYSTEMDIR	; Quit when we hit system page dir
	jz	short $$dn2		;
	push	eax			; Else dealloc the page
	call	PageDealloc		;
	pop	eax			;
	add	eax,PG_SIZE		; Next page
	jmp	$$lp			; Loop
$$dn2:
	mov	ecx,[mempages]		; Now get number of ext pages
	mov	eax,PG_STARTOFEXTMEM	; Get address of ext pages
$$lp3:
	push	eax			;Dealloc the page
	call	PageDealloc		;
	pop	eax			;
	add	eax,PG_SIZE		; Next page
	loop	$$lp3			; Continue till done
	ret
PageAllocInit	ENDP	
seg386	ENDS	
end