;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
; Page.asm
;
; Function: Rudimenatary paging support, also system page table creation
;   Handle finding extended memory length
;   Handle creating system page tables
;   Handle rudimentary page table functions
	;MASM MODE
	.386p

include  segs.asi 
include  page.asi 
include  sys.mac 
include  boot.ase 
	PUBLIC PageTableDisable, SetSystemPageTables
	PUBLIC PageTableEnterAddress, GetMultiplePages
	PUBLIC	syspagetab, mempages

segpagetables	SEGMENT	public at (PT_SYSTEMDIR ) SHR 4
dirtable dd PG_ITEMSPERTABLE * (PG_MB/ PG_MBPERTABLE+1) DUP (?)
segpagetables	ENDS	

seg386data	SEGMENT	
syspagetab dd	PT_SYSTEMDIR	; Pointer to page table
mempages   dd	0		; Total extended memory pages found
seg386data	ENDS	
seg386	SEGMENT	
;
; Find ouot how much memory we have
;
FindMemPages	PROC	
	sub	eax,eax		; Clear page count
	mov	[mempages],eax
	mov	esi,PG_STARTOFEXTMEM	; Get start of ext mem
	ZA	esi			; Make it segment offset
$$lp1:
	mov	ah,[esi]		; Get byte
	mov	BYTE PTR [esi],0aah	; Replace it with this
	cmp	BYTE PTR [esi],0aah	; Make sure it stuck
	mov	[esi],ah		; Restore byte
	jnz	short failed		; Quit if failed
	mov	BYTE PTR [esi],055h	; Otherwise replace it with this
	cmp	BYTE PTR [esi],055h	; Make sure it stuck
	mov	[esi],ah		; Restore original value
	jnz	short failed		; Quit if failed
	inc	[mempages]		; Found a page
	add	esi,PG_SIZE		; Go to next page
	jmp	$$lp1
failed:
	ret
FindMemPages	ENDP	
;
; Disable a page table
;
PageTableDisable	PROC	
	mov	eax,PG_DISABLE		; Value for disable
	mov	ecx,PG_ITEMSPERTABLE	; Items per table
	cld
	rep	stosd			; Wipe table
	ret
PageTableDisable	ENDP	
;
; Enter an address into page table
;
PageTableEnterAddress	PROC	
	and	ebx,0ffffffffh- (PG_SIZE - 1) + PG_ATTRIBUTES ; Wipe unused attributes
	or	ebx,PG_PRESENT		; Mark page present
	mov	[edi+eax*4],ebx		; Save it
	ret
PageTableEnterAddress	ENDP	
;
; Fill part of a table with linearly successive addresses
;
GetMultiplePages	PROC	
$$lp2:
	call	PageTableEnterAddress	; Enter the first address
	add	ebx,PG_SIZE		; Up to next page
	inc	eax			; Entry number
	LOOP	$$lp2			; Loop
	ret
GetMultiplePages	ENDP	
;
; Initialize the system page tables
;
; table 0 : dir
; table 1 : page 0 - mapping for DOS memory
; table 2-5 : extended memory mapping (16 M)
; 
SetSystemPageTables	PROC	
	; Find out how much memory we have
	call	FindMemPages

	;Make page tables DS relative
	mov	eax,[syspagetab]
	ZA	eax
	mov	[syspagetab],eax

	; Disable all directory and page table entries
	mov	edi,[syspagetab]
	mov	ecx,  PG_MB/PG_MBPERTABLE+1
$$lp:
	push	ecx
	call	PageTableDisable
	pop	ecx
	loop	$$lp

	; Make a directory which handles all the page tables required
	mov	edi,[syspagetab]	; Directory address
	sub	eax,eax			; Entry # = 0
	mov	ebx,PT_SYSTEMDIR	; Physical address of table 1
	add	ebx,PG_SIZE		;
	mov	ecx, PG_MB/ PG_MBPERTABLE ; Number of tables
	call	GetMultiplePages	; Allocate tables in dir

	; Map the first megabyte in
	mov	edi,[syspagetab]	; Get table 1
	add	edi,PG_SIZE		;
	sub	eax,eax			; entry # 0
	mov	ebx,0 OR PG_WRITEABLE	; address 0, writeable entry
	mov	ecx,PG_SYSTEMPAGES	; Number of pages in the system
	call	GetMultiplePages	; Allocate them as system pages

	or	ebx,PG_USERMODE		; From A0000 on is user read/write
	mov	ecx,PG_IOPAGES		;
	call	GetMultiplePages        ;

	; Map extended memory in so that physical = linear
	mov	edi,[syspagetab]        ; Dir page table
	add	edi,PG_SIZE ;	        ; First page table
	mov	eax,PG_STARTOFEXTMEM	; Offset to ext mem
	shr	eax,PG_SHIFTSIZE-2	;
	add	edi,eax			; 
	sub	eax,eax                 ; Entry # 0
	mov	ebx,PG_STARTOFEXTMEM OR PG_WRITEABLE ; Maps to extended mem
	mov	ecx,[mempages]		; Get number pages found
	call	GetMultiplePages	; And get them
	ret
SetSystemPageTables	ENDP	

seg386	ENDS	
end