;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
; Memory.asm
;
; Function : Memory Allocation and deallocation
;   Handles Arena allocation/deallocation
;   Handles Commit/decommit allocation deallocation
;   Don't use both in the same program
;
	;MASM MODE
	.386p

include  segs.asi 
include  page.asi 
include  pageall.asi 
include  pageall.ase 
include  page.ase 
include  memory.asi 
include  errors.asi 
include  sys.mac 
include  dispatch.ase 
include  boot.ase 
include  tss.ase 
include  descript.ase 
include  sems.ase 
include  remaps.ase 

	PUBLIC	memoryhandler
	PUBLIC 	allocpages


seg386data	SEGMENT	
SemMemory dd	1		; Block here if in use
seg386data	ENDS	

	assume	ds:dgroup, es:nothing
seg386	SEGMENT	
;
; Allocate enough pages to hold the data
;
allocPages	PROC	
	push	ds			; Save regs
	push	ecx			;
	push	edi			;
	add	eax,PG_SIZE - 1		; Calculate number of pages
	shr	eax,PG_SHIFTSIZE	;
	push	eax			; Save for exit
	push	DS386			; System data seg
	pop	ds			;
	call	MapStackToSystem	; Map stack to system space
	mov	edi,cr3			; Get user pages dir
	mov	ecx,PT_SYSTEMDIR	; System pages dir
	mov	cr3,ecx                 ; Set system pages dir
	push	edi			; Save user pages dir
	ZA	edi			; Get seg offset
	mov	edi,[edi+ARENATABLEENTRY*4]; Get memory page table
	and	edi,NOT (PG_SIZE -1)	;
	ZA	edi			; Make seg offset
	push	edi			; Save page table
	mov	ecx,PG_ITEMSPERTABLE	; Max entries of allocated mem
findlp:
	bt	DWORD PTR [edi],0	; Scan to find first unused entry
	jnc	short goalloc		;
	add	edi,4			; Not found, next entry
	loop	findlp			;
	stc                     	; Nothing free, exit
	jmp	short noneleft		;

goalloc:
	xchg	eax,ecx    		; Found space
	cmp	ecx,eax			; Is amount desired > amount left
	stc				;
	jg	noneleft		; Yes, exit
	push	edi			; Save page table offset of first unused
alloclp:
	ALLOCEXT			; Allocate a page
	call	pagealloc		;
	jc	deallocall		; Deallocate all if out of pages
	mov	ebx,eax			; 
	or	ebx,PG_WRITEABLE OR PG_USERMODE ; Allow user mode access
	sub	eax,eax			; EDI has entry offset so number = 0
	call	PageTableEnterAddress	; Entry in page table
	add	edi,4			; Next page table
	loop	alloclp			; Get next page
	clc				; No errors
	pop	edi			; Pull page table
noneleft:
	pop	edi			; User page table
	pop	edi			; User page dir
	mov	cr3,edi                 ; Restore user page dir
	call	UnmapStack		; Map stack back to user
	pop	eax			; Restore allocated size
	pushfd				; Save return flags
	shl	eax,PG_SHIFTSIZE	; Make it bytes
	popfd				;
	pop	edi			; Pop regs
	pop	ecx			;
	pop	ds			;
	ret
deallocall:
	pop	edi                     ; Get offset in page table to dealloc from
dealloop:
	mov	eax,[edi]               ; Disable an entry
	mov	DWORD PTR [edi],PG_DISABLE;
	xor	al,1 			; Invert enable flag
	bt	eax,0			; Set carry when done
	jc	noneleft		; Exit with carry set when done
	call	PageDealloc		; Deallocate this page
	add	edi,4			; Next entry
	jmp	dealloop		; Loop around
	
allocPages	ENDP	
	assume	ds:nothing,es:nothing
MemAlloc	PROC	
	push	eax			; Save allocation size
	push	eax
	mov	ax,ds
	push	ds			; Switch to system seg
	push	DS386			;
	pop	ds			;
	mov	edi,CR3			; Get user page dir
	mov	ebx,edi			; To ebx
	mov	ecx,PT_SYSTEMDIR	; System page dir
	cli				; Disable ints while paging is wrong
	mov	CR3,ecx			; System pages
	ZA	edi			; Segment offset of user page dir
	mov	edi,[edi+ARENATABLEENTRY*4]; Get allocation page table
	and	edi,NOT (PG_SIZE -1)	;
	ZA	edi			; Point at first entry
	bt	DWORD PTR [edi],0	; see if any in arena
	mov	cr3,ebx			; Reset paging
	sti				;
	pushfd				; Save flags
	call	DescriptorAddress	;
	call	GetDescriptorBase	;
	mov	eax,ARENASTART		; Subtract it from arenastart
	sub	eax,edi			;
	mov	edi,eax			; This is the offset to the arena
	popfd                   	; Restore flags
	pop	ds
	pop	eax			; Restore allocation size
	jc	short notfirstblock	; If there is an arena, go play with it
	add	eax,MEMIDSIZE		; Make sure enough space for ID field
	call	blockalloc		; Else make one
	jc	nomemory		; Error if can't
	jmp	short allocspace
notfirstblock:
	cmp	[edi + MEMARENA.ID],MEMID ; Error if not pointint at ID block
	jnz	badarena		;
	test	[edi +MEMARENA.INUSE],-1; If inuse, jump to next
	jnz	short linuse		;
	cmp	eax,[edi + MEMARENA.MSIZE]; Else see if enough space here
	jbe	allocspace		; Yes, go alloc
linuse:
	test	[edi + MEMARENA.MLINK],-1; Else see if there is more
	jz	short addspace		; No, add some space at end
	mov	edi,[edi + MEMARENA.MLINK]; Point at next mem block
	jmp	short notfirstblock	; Loop around
addspace:
	test	[edi + MEMARENA.INUSE],-1; See if last is inuse
	jnz	short newblock		; Get a new block if so
	sub	eax,[edi + MEMARENA.MSIZE]; Else subtract size
	call	allocpages		; Alloc some pages
	jc	nomemory		;
	add	[edi + MEMARENA.MSIZE],eax; Add size in
	jmp	short allocspace	; Allocaet space
newblock:
	mov	edx,edi			; Get pointer to last mem block
	add	edx,PG_SIZE		; Point to start of next page
	and	edx,NOT (PG_SIZE -1)	;
	xchg	edx,edi			; Start of next page
	call	blockalloc		; Allocate new block
	jc	short nomemory		; Err if no memory
	xchg	edx,edi			; Get old block
	mov	[edi + MEMARENA.MLINK],edx; Link it in
	mov	edi,edx			; Get new block
	add	[edi + MEMARENA.MSIZE],MEMIDSIZE ; Add in memory block size
allocspace:
	pop	eax			; Get space to allocate
	mov	edx,[edi + MEMARENA.MSIZE]; Get size
	sub	edx,eax			; See if enough space for another block
	cmp	edx,MEMIDSIZE		;
	jbe	short allocall		; No, allocate everything
	mov	edx,eax         	; Else get size
	add	edx,MEMIDSIZE		; EDX gets link offset
	push	edi			; save block
	add	edx,edi			; Get link address
	mov	ecx,[edi + MEMARENA.MLINK]; get old link
	mov	[edi + MEMARENA.MLINK],edx; save new link
	xchg	[edi + MEMARENA.MSIZE],eax; Swap old & new sizes
	sub	eax,[edi + MEMARENA.MSIZE]; Calculate size of following block
	mov	[edi + MEMARENA.INUSE],1; Mark inuse
	push	eax			; Save size
	str	ax			; Mark block with task name
	mov	[edi + MEMARENA.TASK],ax;
	pop	eax			; Get size
	mov	edi,edx			; EDI is following block
	mov	[edi + MEMARENA.ID],MEMID; Mark it
	mov	[edi + MEMARENA.MLINK],ecx; Put the link
	sub	eax,MEMIDSIZE		; Size without MEMID
	mov	[edi + MEMARENA.MSIZE],eax; Save size
	mov	[edi + MEMARENA.TASK],0	; No task
	mov	[edi + MEMARENA.INUSE],0; Not used
	pop	eax			; Pop address of memory for user
	jmp	short exit
allocall:
	mov	[edi + MEMARENA.INUSE],1; Mark block used
	str	ax			; Mark task
	mov	[edi + MEMARENA.TASK],ax;
	mov	eax,edi                 ; Get address of mem
exit:
	add	eax,MEMIDSIZE		; Point to actual memory
	clc
	ret
nomemory:
	pop	eax			; Clear stac
	mov	al,ERR_NOMEM		; No memory available
	stc				;
	ret
badarena2:
	pop	esi			; Clear stack
badarena:
	pop	eax			;
	mov	al,ERR_BADARENA		; Arena is trashed
	stc
	ret
MemAlloc	ENDP	
;
; Allocate a new block of memory
;
blockalloc	PROC	
	add	eax,MEMIDSIZE		; Has to have nough space for block
	call	allocpages		; Alloc pages
	jc	short baerr		; Get out if error here
	mov	[edi + MEMARENA.ID],MEMID; Else set up the block
	mov	[edi + MEMARENA.MLINK],0	;
	sub	eax,MEMIDSIZE		;
	mov	[edi + MEMARENA.MSIZE],eax;
	push	eax			;
	str	ax			;
	mov	[edi + MEMARENA.TASK],ax;
	mov	[edi + MEMARENA.INUSE],0;
	pop	eax			;
baerr:
	ret
blockalloc	ENDP	
;
; Deallocate a memory block
;
MemDealloc	PROC	
	push	eax			; Save address
	push	esi			; and SI
	sub	eax,MEMIDSIZE		; Get pointer to block
	mov	edi,eax			;
	cmp	[edi + MEMARENA.ID],MEMID; Make sure is valid
	jc	badarena2		; Invalid, get out
	mov	[edi + MEMARENA.INUSE],0; Mark unused
	mov	esi,[edi + MEMARENA.MLINK]; Find next block
	or	esi,esi			; See if this is last
	jz	short checkbefore	; Yes, check preceding block
	test	[esi + MEMARENA.INUSE],-1; See if next block is inuse
	jnz	short checkbefore	; Yes, check preceding block
	mov	[esi + MEMARENA.ID],0	; Clear next block
	mov	esi,[esi + MEMARENA.MSIZE]; Get size
	add	esi,MEMIDSIZE		; Plus block size
	add	[edi + MEMARENA.MSIZE],esi; Concatenate blocks
checkbefore:
	mov	esi,ARENASTART		; Start at beginning
findlp2:
	cmp	[esi + MEMARENA.ID],MEMID ; Error if not a valid block
	jnz	badarena2		;
	cmp	esi,edi			; See if this is the current block
	jz	short nonebefore	; Yeah, there's none preceding
	cmp	[esi + MEMARENA.MLINK],edi; Else see if is preceding
	jz	short gotbefore		; Yes, see if to concat
	mov	esi,[esi + MEMARENA.MLINK]; Else traverse the link
	jmp	findlp2 		;
gotbefore:		
	test	[esi + MEMARENA.INUSE],-1; See if preceding is inuse
	jnz	short nonebefore	; Yeah, just get out
	mov	[edi + MEMARENA.ID],0	; Else mark us not so
	mov	edi,[edi + MEMARENA.MSIZE]; Concat the two blocks
	add	edi,MEMIDSIZE		;
	add	[esi + MEMARENA.MSIZE],edi;
nonebefore:
	clc
	pop	esi			; Clean stack
	pop	eax			;
	ret
MemDeAlloc	ENDP	
;
; Calculate parameters for commit/decommit
;
commit_params	PROC	
	mov	edx,PT_SYSTEMDIR	; System pages dir
	mov	cr3,edx                 ; Set system pages dir
	ZA	edi			; Get seg offset
	mov	edi,[edi+ARENATABLEENTRY*4]; Get memory page table
	and	edi,NOT (PG_SIZE -1)	;
	ZA	edi			; Make seg offset
	sub	eax,PG_USERPAGES
	jc	short ccp_badparms
	cmp	eax,PG_USERSIZE
	jnc	short ccp_badparms
	shr	eax,PG_SHIFTSIZE-2
	add	ecx,PG_SIZE-1
	shr	ecx,PG_SHIFTSIZE
	add	edi,eax
	shr	eax,2
	mov	edx,PG_ITEMSPERTABLE	; Max entries of allocated mem
	sub	edx,eax
	cmp	edx,ecx
	jnc	short ccp_all
	mov	ecx,edx
ccp_all:
	ret
ccp_badparms:
	sub	ecx,ecx
	stc
	mov	al,ERR_NOMEM
	ret
commit_params	ENDP	
;
; Commit a section of memory
;   Used by C run-time library.  Has some bugs, errgo it's possible to
;   allocate space the OS won't deallocate at rundown and it's possible to
;   deallocate memory from a previous allocate if sections overlap and it
;   fails
;
MemCommit	PROC	
	push	ds			; Save regs
	push	DS386			; System data seg
	pop	ds			;
	call	MapStackToSystem	; Map stack to system space
	mov	edi,CR3                 ; Save user CR3
	push	edi			;
	call	commit_params		; Get params: ECX = len, EDI = pos
	jc	short mc_noneleft
	push	edi
	push	ecx
mc_alloclp:
	bt	DWORD PTR [edi],0  	; See if already alloced
	jc	short mc_noalloc
	ALLOCEXT			; Allocate a page
	call	pagealloc		;
	jc	mc_deallocall		; Deallocate all if out of pages
	mov	ebx,eax			; 
	or	ebx,PG_WRITEABLE OR PG_USERMODE ; Allow user mode access
	sub	eax,eax			; EDI has entry offset so number = 0
	call	PageTableEnterAddress	; Entry in page table
mc_noalloc:
	add	edi,4			; Next page table
	loop	mc_alloclp		; Get next page
	clc				; No errors
	pop	ecx
	pop	edi
mc_noneleft:
	pushfd
	shl	ecx,PG_SHIFTSIZE
	mov	eax,ecx
	popfd
	pop	edi			; Pull page table
	mov	cr3,edi                 ; Restore user page dir
	call	UnmapStack		; Map stack back to user
	pop	ds			;
	ret
mc_deallocall:
	pop	ecx			; Size to dealloc
	pop	edi                     ; Get offset in page table to dealloc from
	push	ecx
mc_dealloop:
	mov	eax,[edi]               ; Disable an entry
	mov	DWORD PTR [edi],PG_DISABLE;
	bt	eax,0			; Set carry when done
	jnc	mc_deallok		; Exit with carry set when done
	call	PageDealloc		; Deallocate this page
mc_deallok:
	add	edi,4			; Next entry
	loop	mc_dealloop		; Loop around
	pop	ecx
	stc
	mov	al,ERR_NOMEM
	jmp	mc_noneleft
	
MemCommit	ENDP	
;
; Decommit memory
;
MemDeCommit	PROC	
	push	ds			; Save regs
	push	DS386			; System data seg
	pop	ds			;
	call	MapStackToSystem	; Map stack to system space
	mov	edi,CR3                 ; Save user CR3
	push	edi			;
	call	commit_params		; Get params: ECX = len, EDI = pos
	jc	short mdc_badparms
	push	edi
	push	ecx
mdc_dealloclp:
	bt	DWORD PTR [edi],0   	; See if already alloced
	jnc	short mdc_nodealloc
	mov	eax,[edi]
	mov	DWORD PTR [edi],PG_DISABLE;
	call	pagedealloc		;
mdc_nodealloc:
	add	edi,4			; Next page table
	loop	mdc_dealloclp  		; Get next page
	pop	ecx
	pop	edi
	shl	ecx,PG_SHIFTSIZE
	mov	eax,ecx
	clc
mdc_badparms:
	pop	edi			; Pull page table
	mov	cr3,edi                 ; Restore user page dir
	call	UnmapStack		; Map stack back to user
	pop	ds			;
	ret
MemDeCommit	ENDP	
	assume ds:nothing, ds:nothing, gs:dgroup
;
; Memory handling procedure
;
MemoryHandler	PROC	
	push	ebx			; Push used regs
	push	ecx			;
	push	edx			;
	push	edi			;
	push	gs			;

	push	DS386			; Get system data seg
	pop	gs			;


	push	ds			; DS = data seg
	push	DS386			;
	pop	ds			;
	push	offset dgroup:SemMemory	; Block if code inuse
	call	SemBlock		;
	pop	ds			; Restore DS

	inc	[canmultitask]		; Disable multitasking throughout
	push	ebx			;
	call	TableDispatch		; Dispatch
	dd	3
	dd	MemAlloc
	dd	MemDealloc
	dd	MemCommit
	dd	MemDeCommit

	pushfd				; Save retcode
	dec	[canmultitask]		; Enable multitasking
	bts	[SemMemory],0		; Mark done
	popfd				; Restore retcode
	pop	gs			; And regs
	pop	edi			;
	pop	edx			;
	pop	ecx			;
	pop	ebx			;
	ret

MemoryHandler	ENDP	
seg386	ENDS	
END