;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; Descript.asm
;
; Function: subroutines for descriptor handling
;   Handles descriptor field setting\retrieving
;   Handles descriptor allocation table for global descriptors.
;     Local descriptors are statically allocated by the TSS routines
;
	;MASM MODE
	.386p

include  gdt.asi 
include  boot.asi 
include  segs.asi 
include  page.asi 
include  boot.ase 
	PUBLIC DescriptorInit, GrabDescriptor, ReleaseDescriptor
	PUBLIC GrabGDTDescriptor, ReleaseGDTDescriptor
	PUBLIC DescriptorAddress,FindFreeDescriptor
	PUBLIC SetDescriptorBase, SetDescriptorLimit
	PUBLIC GetDescriptorBase, GetDescriptorLimit
	PUBLIC SetGateOffset, SetGateSelector
	PUBLIC GetGateOffset, GetGateSelector
	PUBLIC GetDescriptorType
	PUBLIC desctable

seg386data	SEGMENT	
desctable dd	(NUMGDT+31) SHR 5 DUP (-1) ; Table of in-use GDT entries
seg386data	ENDS	

seg386	SEGMENT	
;
; Initialize the descriptor allocation table
;
DescriptorInit	PROC	
	mov	edi,offset dgroup:tGDT	; Find GDT
	mov	ecx,NUMGDT	; Get number of entries
	mov	ebx,0		; At entry 0
idl:
	test	[edi + DESCRIPTOR.DTYPE],DT_PRESENT ; See if something there
	jz	short noset	; No, next entry
	btr	[desctable],ebx	; Yes clear the bit to mark present
noset:
	inc	ebx		; Next entry
	add	edi,8		;
	loop	idl		; Loop
	mov	eax,ebx		; Find out if extra bits at end of table
	add	eax,31          ;
	and	eax,0ffffffe0h  ;
lp:
	cmp	eax,ebx		; 
	jz	short done      ; No more
	btr	[desctable],ebx ; Reset all extra bits to mark used
	inc	ebx		;
	jmp	lp              ;

done:
	ret
DescriptorInit	ENDP	
;
; Set type bytes for descriptor
;
GrabDescriptor	PROC	
	mov	[edi + DESCRIPTOR.HILIM],DT_HIDEF
	or	al, DT_PRESENT
	mov	[edi + DESCRIPTOR.DTYPE],al
	ret
GrabDescriptor	ENDP	
;
; Mark descriptor not present
;
ReleaseDescriptor	PROC	
	and	[edi + DESCRIPTOR.DTYPE], not DT_PRESENT
	ret
ReleaseDescriptor	ENDP	
;
; Allocate a GDT descriptor
;
GrabGDTDescriptor	PROC	
	call	GrabDescriptor	; Set type bytes
	mov	eax,edi		; Find descriptor number
	sub	eax,offset dgroup:tGDT	;
	shr	eax,3           ;
	btr	[desctable],eax ; Mark unavailable
	ret
GrabGDTDescriptor	ENDP	
;
; Deallocate a GDT descriptor
;
ReleaseGDTDescriptor	PROC	
	call	ReleaseDescriptor	; Mark not present
	mov	eax,edi			; Find descriptor number
	sub	eax,offset dgroup:tGDT		;
	shr	eax,3			;
	bts	[desctable],eax		; Mark available
	ret
ReleaseGDTDescriptor	ENDP	
;
; Translate a selector to the address of a descriptor
;
DescriptorAddress	PROC	
	cwde
	push	ebx
	TEST	eax,ti_local		; See if in LDT
	jz	short getgdt
	sub	ebx,ebx			; If so get LDT selector
	sldt	bx			;
	and	ebx, NOT SEL_STATUS	; Strip off RPL and TI
	mov	edi,ebx			;
	add	edi,offset dgroup:tGDT         ; Find position in GDT
	call	GetDescriptorBase	; Load up the LDT base address
	ZA	edi			; Segment offset
	jmp	short gotldt		
getgdt:
	mov	edi,offset dgroup:tGDT         ; Otherwise just get the GDT table
gotldt:
	and	eax,NOT SEL_STATUS	; Strip off RPL and TI of descriptor
	add	edi,eax			; Add in to table base
	pop	ebx
	ret
DescriptorAddress	ENDP	
;
; Find a free GDT descriptor
;
FindFreeDescriptor	PROC	
	push	ecx
	push	ebx
	sub	eax,eax
	sub	ebx,ebx
	mov	edi,offset dgroup:desctable	; Get descriptor table
	mov	ecx,(NUMGDT+31) shr 5	; Number of DWORDS to search
nextdesc:
	bsf	ebx,DWORD PTR [edi]	; Search one
	jnz	gotone			; Found a bit, finish up
	add	edi,4			; Else next word
	inc	eax			;
	loop	nextdesc		; loop
	stc				; Searched everything, nothing loose
	pop	ebx
	pop	ecx
	ret
gotone:
	shl	eax,4			; dWords to bits
	add	eax,ebx			; Add in offset
	shl	eax,SEL_SHIFT		; Make it a selector
	mov	edi,eax			; Make DI point to it
	add	edi,offset dgroup:tGDT		;
	clc                             ; Success
	pop	ebx
	pop	ecx
	ret
FindFreeDescriptor	ENDP	
;
; Set the base fields of a descriptor
;
SetDescriptorBase	PROC	
	mov	[edi + DESCRIPTOR.base],ax
	shr	eax,16
	mov	[edi + DESCRIPTOR.MEDBASE],al
	mov	[edi + DESCRIPTOR.HIBASE],ah
	ret
SetDescriptorBase	ENDP	
;
; Return the base fields of a descriptor
;
GetDescriptorBase	PROC	
	push	eax
	mov	ah,[edi + DESCRIPTOR.HIBASE]
	mov	al,[edi + DESCRIPTOR.MEDBASE]
	shl	eax,16
	mov	ax,[edi + DESCRIPTOR.BASE]
	mov	edi,eax
	pop	eax
	ret
GetDescriptorBase	ENDP	
;
; Set the limit fields of a descriptor
;
SetDescriptorLimit	PROC	
	and	[edi + DESCRIPTOR.HILIM], NOT DT_HIGR
	test	eax,0fff00000h
	jz	sdl_logran
	or	[edi + DESCRIPTOR.HILIM],DT_HIGR
	shr	eax,12
sdl_logran:
	mov	[edi + DESCRIPTOR.LIMIT],ax
	shr	eax,16
	and	[edi + DESCRIPTOR.HILIM],0f0h
	or	[edi + DESCRIPTOR.HILIM],al
	ret
SetDescriptorLimit	ENDP	
;
; Get the limit fields of a descriptor
;
; There is actually an instruction to do this one but I don't use it
;
GetDescriptorLimit	PROC	
	mov	al,[edi + DESCRIPTOR.HILIM]
	and	ax,15
	shl	eax,16
	mov	ax,[edi + DESCRIPTOR.LIMIT]
	test	[edi + DESCRIPTOR.HILIM],DT_HIGR
	jz	gdl_logran
	shl	eax,12
	or	eax,PG_SIZE -1
gdl_logran:
	ret
GetDescriptorLimit	ENDP	
;
; Set a Gate offset
;
SetGateOffset	PROC	
	mov	[edi + GATEDESC.LOOFFSET],ax
	shr	ax,16
	mov	[edi + GATEDESC.HIOFFSET],ax
	ret
SetGateOffset	ENDP	
;
; Set a Gate Selector
;
SetGateSelector	PROC	
	mov	[edi + GATEDESC.GSELECTOR],ax
	ret
SetGateSelector	ENDP	
;
; Set a Gate Count field
;
SetGateCount	PROC	
	mov	[edi + GATEDESC.COUNT],al
	ret
SetGateCount	ENDP	
GetGateOffset	PROC	
	mov	ax,[edi + GATEDESC.HIOFFSET]
	shl	eax,16
	mov	ax,[edi + GATEDESC.LOOFFSET]
	ret
GetGateOFfset	ENDP	
GetGateSelector	PROC	
	mov	ax,[edi + GATEDESC.GSELECTOR]
	ret
GetGateSelector	ENDP	
;
; Get the Descriptor Type
;
GetDescriptorType	PROC	
	mov	al,[edi + DESCRIPTOR.DTYPE]
	ret
GetDescriptorType	ENDP	
seg386	ENDS	
END