;
; LSD
;
; Copyright(c) LADsoft
;
; David Lindauer, camille@bluegrass.net
;
;
; One thing not done during rundown is flushing the file buffers.
;
;
; Boot.asm
;
; Function: Startup and rundown
;
;   Handles creating the basic GDT
;   Handles revectoring interrupts
;   Handles all initialization
;   Handles calling first task
;   Handles rundown
;   Handles startup messages
;
	;MASM MODE
	.386p

include  page.asi 
include	 boot.asi 
	PUBLIC	rIDT, tIDT, tGDT, pIDT, pGDT
	PUBLIC	idtadr, gdtadr, zero, baseseg, dosdata
	PUBLIC	_exit, toss, boss
	PUBLIC	trap12
	public	eom
	extrn monitor_init :  PROC
include	 pic.ase 
include  ints.ase 
include  os.asi 
include  timer.ase 
include  page.ase 
include  descript.ase 
include  pageall.ase 
include  tss.ase 
include  video.ase 
include  prints.ase 
include  kb.ase 
include  loader.ase 
include  errors.asi 
include  beep.ase 
include  serial.ase 
include  floppy.ase 
include  cmos.ase 
include  buffers.ase 
include  files.ase 
include  xstack.ase 
include  vgaini.ase 
include  glbltss.ase 	
include  a20.ase 
segdata	SEGMENT	

;
; IDT and GDT are first so they will be DWORD aligned
;
tIDT	db	IDTSIZE DUP(0)	; Protected mode IDT
tGDT	db	8 DUP(-1)	; Protected mode GDT
	db	GDTSIZE-8 DUP(0)

rIDT	dw	3ffh		; Real mode values for IDT register
	dd	0
pIDT	dw	IDTSIZE-1	; Protected mode IDT register
idtadr	dd	offset dgroup:tIDT
pGDT	dw	GDTSIZE-1	; Protected mode GDT register
gdtadr	dd	offset dgroup:tGDT
baseseg	dw	dgroup		; Program runs from here
dosdata	dw	0		; Segment of DOS data
LABEL tDOSVEC   BYTE
				; table of DOS vectors to patch into program
segdata	ENDS	

seg386data	SEGMENT	
	align
;
;Initial GDT entries
;
LABEL	iGDT	WORD
include	 gdt.def 
erropen	db	"Error opening file",10,13,0
errclose db	"Error closing file",10,13,0
errread	db	"Error reading file",10,13,0
errbadform db	"Error in file format",10,13,0
errnomem db	"Error - no memory available",10,13,0
errnodesc db	"Error - no descriptors available",10,13,0
osversion db	"LSD-32 Version ",VERID / 100+ '0'
	db	'.',VERID MOD 100 / 10 + '0'
	db	VERID MOD 10 + '0',10,13
	db	"Copyright (c), 1996, LADsoft",10,13,0
basememamount db "Kb Base Memory",10,13,0
extmemamount db	"Kb Extended Memory",10,13,10,13,0
seg386data	ENDS	

stack386	SEGMENT	
label	boss	byte
	dd	PROTSTACKSIZE	DUP (?) ; Program stack
label	toss	byte
label	eom	word
stack386	ENDS	

seg386	SEGMENT	
;
; zero and codezero, offset of dgroup and cgroup from abs 0
;
zero		dd	dgroup	; Offset of Protected mode from absolute zero
codezero	dd	cgroup
;
; Faults
;
seg386data	SEGMENT	
errmsg	db	"Error # ", 0
trapmsg	db	10,13,"Processor fault: "
pfnum	dw	3030h
	db	13,10, "CS:  ",0
trapmsg2 db	13,10, "EIP: ",0
trapmsg3 db	13,10, "CR2: ",0
trapmsg4 db	13,10, 0
align
cantload dd	0
errnum	dw	0
errorocurred db 0
errstack df	0
	align
seg386data	ENDS	

;
; Create real mode trap and interrupt vectors
; Monitor will override these definitions if installed
;
;
	PROCESSORTRAPS	0,7 			; Trap processor traps
	PROCESSORTRAPS	8,1,ERROR
	PROCESSORTRAPS	9,1
	PROCESSORTRAPS	10,2,ERROR
trap12:
	PROCESSORTRAPS	12,3,ERROR
	PROCESSORTRAPS	15,2
	TRANSFERS	17,31			; Transfer real mode ints to the bios
include  ints.def 
segdata	SEGMENT	
	dw	-1			; This ends the tDOSVEC table
segdata	ENDS	

proctraperror:
	mov	bx,DS386		; Get common data seg
	mov	DS,bx
;	cmp	al,12			; See if stack trap
;	jnz	nostack			; No, do normal
;	cli				; Otherwise reload stack
;	mov	[dword ptr errstack],offset toss	;
;	mov	[word ptr errstack + 4],DS386	;
;	lss	esp,[fword ptr errstack];
;	sti				;
;	push	0			; Push null data
;	push	0
;	push	0
nostack:
	pop	ebx			; Get error number or selector
	mov	[errnum],bx		; Save it
	mov	[errorocurred],-1	; Mark we have it
proctrap:
	push	DS386			; Switch to system data
	pop	ds
	cbw				; extend
	mov	bl,10			;
	div	bl			;
	or	eax,3030h		; Make ASCII
	mov	[pfnum],ax		; Put in buffer
	MESSAGE	trapmsg			; CR/LF
	mov	eax,[esp+4]		; Print the CS
	call	Printword		;
	MESSAGE trapmsg2
	mov	eax,[esp]		; Print the EIP
	call	PrintDword
	MESSAGE trapmsg3
	mov	eax,CR2 		; Print CR2 in case it was a page
	call	PrintDWord		; exception
	Message	Trapmsg4
	test	[errorocurred],-1
	jz	noerror
	MESSAGE errmsg
	mov	ax,[errnum]
	call	PrintWord
noerror:
	jmp	_exit			; Quit
;
; Startup code
;
seg8086	SEGMENT	
startup:
	mov	ax,ds 				; Get DOS data seg
	mov	bx,dgroup			; DGROUP
	mov	ds,bx				;
	mov	es,bx				;
	mov	[dosdata],ax			; Get dos data seg

	shl	[codezero],4
	shl	[zero],4			; Fix ZERO address
	mov	ebx,[zero]			; Load it
	mov	[stackbase],ebx
	add	[gdtadr],ebx			; Adjust GDT and IDT pointers
	add	[idtadr],ebx
	call	setupgdt			; Set up the GDT
	lgdt	FWORD PTR [pGDT]		; Load GDT

	TOPROT	,firsttime			; Into protected mode
	cli
	call	a20on		  		; Enable a20 line
	call	SetSystemPageTables		; Initialize page tables
	mov	eax,PT_SYSTEMDIR		; Set page table address
	mov	CR3,eax				;
	PAGINGON ebx				; Now enable paging

	call	pic386				; 386 PIC
	call	swapdosvec			; Enable real mode interrupts
	call	_timerenable			; Get the 60Hz clock up
	sti
	call	PageAllocInit			; Setup page allocation
 	call	DescriptorInit			; Set up GDT item allocation
	call	video_enable			; grab video states
	call	kb_enable			; Grab kb states

	call	InitCMOS			; Init CMOS clock driver
ifdef STANDALONE
	call	textmode			; Enable text mode video
endif
;
; Now come routines which allocate extended memory
; BUFFERINIT MUST BE FIRST
;
	call	BufferInit			; Initialize buffers
	call	ClearFCBs			; Initialize FCBs
	call	serialinit			; Initialize serial ports
	call	init_glbl_tss_page		; Init the TSS page ptr page
ifdef MONITOR
	call	monitor_init			; Initialize the debugger traps
endif
	call	TaskInit			; Init the system task
;
; Now we load the specified file and go
;
	call	setLoadFile			; Get load file name
	call	InitExtendStack			; Trap vector 12 for stack extent
	MESSAGE	osversion
	call	CountBaseMem			; Count base memory
	mov	eax,edx				;
	shl	eax,2				; 4Kb per page
	call	PrintDecimalNumber		; Print it
	MESSAGE	basememamount			; And Diag message
	mov	eax,[mempages]			; Mempages, ext memory
	shl	eax,2				; 4Kb a shot
	call	PrintDecimalNumber		; Display memory
	MESSAGE	extmemamount			; And Diag message
	sub	eax,eax				; Run first task
	call	NewTask				;
						; Never gets here if task
						; runs successfully
	call	errenum				; Enumerate errors
_exit:
	mov	eax,PT_SYSTEMDIR
	mov	CR3,eax
	mov	ax,DSABS			; Resseting seg registers
	mov	fs,ax   			; Just in case
	mov	gs,ax
	mov	ax,DS386			; Reset the seg registers
	mov	es,ax                           ; Just in case
	mov	ds,ax
	cli
	mov	ax,DS386
	mov	ss,ax
	mov	esp,offset dgroup:toss
	mov	eax,[zero]
	mov	[stackbase],eax
	os	mi_disablewatchdog			; Kill the watchdog
;	call	FlushBuffers			; Can't put here
	os	MS_DETACH			; Detach mouse
	call	VGA_RUNDOWN
	call	RestoreCMOS			; Restore CMOS states
	call	kb_disable			; Restore kb states
	call	video_disable			; Restore video states
	call	_timerdisable			; Disable 72 Hz clock
	call	swapdosvec			; Disable real mode interrupts
	call	pic8086				; 8086 PIC
	call	beep_disable			; Turn off beeper
	call	a20off				; Set A20 back the way it was
	FROMPROT				; Into real mode
	sti
	call	FloppyRundown			; Reinit BiosFloppy states
IFDEF	standalone
	test	BYTE PTR [cantload],-1		; See if load error
	jz	short startup			; No error
	CLI					; Load error, wait for hard 
	halt					;  reset
endif
	EXITCODE				; To DOS
;
; Routine copyies the initial GDT entries to the GDT table
;   Zero adjusting as necessary
;
setupgdt	PROC	
	CLD					; Direction = up
	mov	esi,offset dgroup:iGDT		; Load GDT table pointers
	mov	di,offset dgroup:tGDT + 8

	mov	cx,NUMGDT-1			; Create GDT
gdtinit:
	lodsw					; Get flats
	movsd					; Move GDT entry to table
	movsd
	test	ax,gdtDataOffset		; Adjust this entry as data?
	jz	checkcode			; No, continue
	mov	ebx,[zero]			; Get the data offset
	mov	dl,BYTE PTR [zero + 2]		;
	add	WORD PTR [di+2-8],bx		; Else add in the ZERO offset
	add	BYTE PTR [di+4-8],dl		;
	jmp	nooffset
checkcode:
	test	ax,gdtCodeOffset		; Adjust this entry as data?
	jz	nooffset			; No, continue
	mov	ebx,[codezero]			; Get the data offset
	mov	dl,BYTE PTR [codezero + 2]		;
	add	WORD PTR [di+2-8],bx		; Else add in the ZERO offset
	add	BYTE PTR [di+4-8],dl		;
nooffset:
	test	ax,gdtLastEntry
	jnz	endGDT
	loop	gdtinit				; But don't overflow table
endGDT:
	RET
setupgdt	ENDP	
seg8086	ENDS	
;
; Routine swaps contents of DOSVEC table with the entries
;   in the real mode interrupt table
;
swapdosvec	PROC	
	assume	ds:dgroup,es:nothing
	mov	esi,offset dgroup:tDOSVEC		; get vector table
	pushfd
	cli
swaploop:
	cmp	WORD PTR [esi],-1		; End of table
	jz	short swapdone			;Yes, quit
	lodsw					; Get entry address
	cwde					;
	mov	edi,eax				; to edi
	sub	edi,[zero]			; Absolute zero
	lodsd					; Get new vector
	mov	ecx,[edi]			; Get old vector
	stosd					; Exchange them
	mov	[esi-4],ecx			;
	jmp	swaploop			; Loop
swapdone:
	popfd
	ret
swapdosvec	ENDP	
;
; Routine to set the load file and command line ptrs
;
SetLoadFile	PROC	
	push	gs
	mov	ax,DSABS		; Absolute indexing
	mov	gs,ax                   ;
	movzx	ebx,[dosdata]
	shl	ebx,4                   ; Make a linear address
	add	ebx,80h                 ;
	movzx	eax,BYTE PTR gs:[ebx]      ; Get the count byte
	inc	ebx                     ; Point to filename
	push	ebx                     ; Save filename
	add	ebx,eax                 ; Point to end of filename
	mov	BYTE PTR gs:[ebx],0	; Make it a zero
	pop	ebx                     ; Filename
	inc	ebx                     ; Index past space
	mov	esi,ebx
slf_loop:
	cmp	BYTE PTR gs:[esi],0
	jz	short slf_load
	cmp	BYTE PTR gs:[esi],' '
	jz	short slf_got
	inc	esi
	jmp	slf_loop
slf_got:
	mov	BYTE PTR gs:[esi],0
	inc	esi
slf_load:
	call	init_load_file		; initialize as load file
	pop	gs
	ret
SetLoadFile	ENDP	
ErrEnum	PROC	
	cmp	al,ERR_FILENOTFOUND
	jnz	short ee1
	MESSAGE	erropen
	ret
ee1:
	cmp	al,ERR_CLOSE
	jnz	short ee2
	MESSAGE	errclose
	ret
ee2:
	cmp	al,ERR_READ
	jnz	short ee3
	MESSAGE	errread
	ret
ee3:
	cmp	al,ERR_BADFORMAT
	jnz	short ee4
	MESSAGE	errbadform
	ret
ee4:
	cmp	al,ERR_NOMEM
	jnz	short ee5
	MESSAGE	errnomem
	ret
ee5:	
	cmp	al,ERR_NODESC
	jnz	short ee6
	MESSAGE errnodesc
ee6:	
	inc	[cantload]
	ret
ErrEnum	ENDP	
seg386	ENDS	
END	startup