;
; title.asm
;
; this puts up the game title, and processes the time the user enters
;
ifdef SMALL
	.model small
else
	.model tiny
endif

include atc.asi
include atc.mac
include input.ase
include planes.ase
include io.ase
include error.ase

	public dotitle

	.data
ten	db	10	; value
sixty	dw	60	; value

	.code

dotitle	PROC
	setcolor CO_NORM       		; put out header
	PMsg	18,10,"ATC Version 2.0, David Lindauer"
	PMsg	20,10,"Type the number of minutes (>=16)"
	setcolor CO_TIME
timerep:
	Pmsg	TIME_ROW,TIME_COL-1,">  <"	; display time prompt
	loadcoord TIME_ROW,TIME_COL
	mov	bx,2
	call	setinput
wtime:
	call	getinput		; handle input
	jc	quit			; get out if esc pressed
	jz	accept   		; go accept if return pressed
	call	movecheck		; wait for one second
	jc	wtime
	call	clear_msg		; then try to clear the message
	jmp	wtime
accept:
	mov	al,[inbuf]		; get first digit
	call	getdig			; first digit
	jc	terr
	mul	[ten]			; times ten
	mov	ah,al			; ah = temp
	mov	al,[inbuf+1]		; get second digit
	call	getdig
	jc	terr
	add	al,ah 			; add it in
	sub	ah,ah
	cmp	al,BASETIME		; range check
	jc	terr
	mul	[sixty]			; else calculate seconds
	inc	ax			; bump right past the minute
					; so we get a show of planes
	mov	[timeleft],ax
	setcolor CO_NORM
	loadcoord	18,10
	mov	cx,7
	mov	dx,80
	call	clrblock
	clc
quit:
	ret
terr:
	setcolor CO_ERR			; print an error and loop
	call	draw_msg
	db	ERROR_ROW,ERROR_COL,"Invalid time",0
	jmp	timerep
dotitle	ENDP
	end