;
; rand.asm
;
; this is the random number module
;
; it also has the time-fetch routine used to determine time lapses
;
ifdef SMALL
	.model small
else
	.model tiny
endif
	public rand,srand,getticks

	.data
seed	dd	045168297h
mulval	dd	15a4e35h

	.code
;
; read the low word of the bios tick count
;
; returns:
;   ax = low word of ticks
;
getticks PROC
	push ds
	mov ax,40h
	mov ds,ax
	mov ax,ds:[6ch]
	pop ds
	ret
getticks ENDP
;
; init the random number generator from the system timer
;
srand	PROC
	call	getticks
	mov	word ptr [seed],ax
	ret
srand	ENDP
;
; generate a random number
;
; seed = seed * mulval + 1
;
; rn = (seed >> 16) % modulous
;
; input:
;   ax = modulous
;
; returns:
;   ax = value
;
rand	PROC
	push	dx
	push	cx
	push	bx
	push	ax
	mov	ax,word ptr [seed]	; this is a partial 32x32 multiply
	mul	word ptr [mulval]	; which discards the upper 32-bits
	mov	cx,ax			; of the result
	mov	bx,dx
	mov	ax,word ptr [seed + 2]
	mul	word ptr [mulval]
	add	bx,ax
	mov	ax,word ptr [seed]
	mul	word ptr [mulval+2]
	add	bx,ax
	add	cx,1
	adc	bx,0
	mov	word ptr [seed],cx
	mov	word ptr [seed + 2],bx
	mov	ax,bx
	pop	bx
	sub	dx,dx
	div	bx
	xchg	ax,dx			; return remainder
	pop	bx
	pop	cx
	pop	dx
	ret
rand	ENDP
	end