;
; input.asm
;
; this is the module that buffers user input for the parser
;
ifdef SMALL
	.model small
else
	.model tiny
endif

	public	getinput,getdig, setinput, inbuf

include io.ase

	.data
incurs	dw	?		; input cursor pos
inbuf	db	4 dup (' ')	; input buffer
inlen	db	?		; max len of input
	.code

;
;transforms an input character into a digit
;
; input:
;   al = char
;
; returns:
;   cy clr : error
;   cy clr : ax = val
getdig	PROC
	sub	al,'0'
	jc	gdx
	cmp	al,10
	cmc
gdx:
	ret
getdig	ENDP
;
; initialize input params
;
; input:
;   ax = cursor pos
;   bl = input len
;
; returns:
;
;  CY set: escape
;  ZR set: hit return
;  otherwise call again later
;
setinput	PROC
	mov	[inlen],bl
	mov	[incurs],ax
	mov	word ptr [inbuf],'  '
	mov	word ptr [inbuf+2],'  '
	ret
setinput	ENDP

getinput	PROC
	call	scankey	; get a key
	jz	noinput	; and return if no input
	cmp	al,' '	; check for control chars
	jc	control
	cmp	al,7fh	; and alternate backspace
	jz	bkspc
	mov	bx,word ptr [inbuf+1]	; shift buffer to left
	mov	word ptr [inbuf],bx
	mov	bl,[inlen]	; put al in last position
	sub	bh,bh
	mov	[inbuf+bx-1],al
	jmp	putin		; redisplay
control:
	cmp	al,13		; control char, see if CR
	jnz	notcr		;
	clc			; yes, return
	ret
notcr:
	cmp	al,01bh
	jnz	notesc
	stc			; esc, set carry
	ret
notesc:
	cmp	al,8    	; 
	jnz	noinput	
bkspc:
	mov	ax,word ptr [inbuf]	;ctrl-h or backspace, shift right
	mov	word ptr [inbuf+1],ax
	mov	[inbuf],' '
putin:
	mov	ax,[incurs]	; set cursor pos
	call	setpos
	mov	cl,[inlen]	; get len
	sub	ch,ch
	mov	si,offset inbuf	; and buf
pilp:
	lodsb			; blit to screen
	call	putch
	loop	pilp

noinput:
	clc			; return with no flags set
	or	al,1
	ret
		
getinput	ENDP
	end