;
; fix.asm
;
; this holds the game boards and game board init routines,
; also some utility routines for dealing with the fix structures
;
ifdef SMALL
	.model small
else
	.model tiny
endif

	public initfix,findfix,fixptr, fixpos

include atc.asi
include atc.mac
include rand.ase

	.data
fixptr	dw	?			;pointer to fixes in use
fixsize	dw	14*size fixstruc	; size of one field of fixes
three 	db	3			; value three

fixbase label	byte	; table of fixes
;
; fixes are the opposite of the exit direction
;
;Fix Table 0
	fixstruc	<00,00,SouthEast>	;0
	fixstruc	<00,08,South>	;1
	fixstruc	<00,19,South>	;2
	fixstruc	<04,24,West>	;3
	fixstruc	<09,24,West>	;4
	fixstruc	<15,19,North>	;5
	fixstruc	<15,11,North>	;6
	fixstruc	<15,02,North>	;7
	fixstruc	<11,00,East>	;8
	fixstruc	<04,00,East>	;9
	fixstruc	<04,08,SouthEast>	;*#
	fixstruc	<09,19,North>	;*$
	fixstruc	<08,12,NorthWest>	;#
	fixstruc	<05,19,South>	;$


;Fix Table 1
	fixstruc	<00,04,South>	;0
	fixstruc	<00,12,South>	;1
	fixstruc	<00,17,South>	;2
	fixstruc	<05,24,West>	;3
	fixstruc	<10,24,West>	;4
	fixstruc	<15,19,North>	;5
	fixstruc	<15,12,North>	;6
	fixstruc	<15,04,North>	;7
	fixstruc	<10,00,East>	;8
	fixstruc	<05,00,East>	;9
	fixstruc	<05,12,South>	;*#
	fixstruc	<07,06,North>	;*$
	fixstruc	<09,12,North>	;#
	fixstruc	<03,06,South>	;$


;Fix Table 2
	fixstruc	<00,04,South>	;0
	fixstruc	<00,10,South>	;1
	fixstruc	<00,17,South>	;2
	fixstruc	<01,24,West>	;3
	fixstruc	<08,24,West>	;4
	fixstruc	<15,24,NorthWest>	;5
	fixstruc	<15,17,North>	;6
	fixstruc	<15,04,North>	;7
	fixstruc	<11,00,East>	;8
	fixstruc	<05,00,East>	;9
	fixstruc	<05,05,East>	;*#
	fixstruc	<08,17,SouthWest>	;*$
	fixstruc	<05,09,West>	;#
	fixstruc	<12,13,NorthEast>	;$


;Fix Table 3
	fixstruc	<00,04,South>	;0
	fixstruc	<00,10,South>	;1
	fixstruc	<00,16,South>	;2
	fixstruc	<00,24,SouthWest>	;3
	fixstruc	<08,24,West>	;4
	fixstruc	<15,16,North>	;5
	fixstruc	<15,10,North>	;6
	fixstruc	<15,03,North>	;7
	fixstruc	<08,00,East>	;8
	fixstruc	<04,00,East>	;9
	fixstruc	<04,16,West>	;*#
	fixstruc	<12,06,NorthEast>	;*$
	fixstruc	<04,12,East>	;#
	fixstruc	<08,10,SouthWest>	;$


;Fix Table 4
	fixstruc	<00,06,South>	;0
	fixstruc	<00,11,South>	;1
	fixstruc	<00,17,South>	;2
	fixstruc	<03,24,West>	;3
	fixstruc	<10,24,West>	;4
	fixstruc	<15,24,NorthWest>	;5
	fixstruc	<15,15,North>	;6
	fixstruc	<15,07,North>	;7
	fixstruc	<12,00,East>	;8
	fixstruc	<06,00,East>	;9
	fixstruc	<04,08,East>	;*#
	fixstruc	<08,13,West>	;*$
	fixstruc	<04,12,West>	;#
	fixstruc	<08,09,East>	;$


;Fix Table 5
	fixstruc	<00,07,South>	;0
	fixstruc	<00,12,South>	;1
	fixstruc	<00,17,South>	;2
	fixstruc	<05,24,West>	;3
	fixstruc	<10,24,West>	;4
	fixstruc	<15,15,North>	;5
	fixstruc	<15,10,North>	;6
	fixstruc	<15,04,North>	;7
	fixstruc	<08,00,East>	;8
	fixstruc	<03,00,East>	;9
	fixstruc	<05,09,East>	;*#
	fixstruc	<10,09,East>	;*$
	fixstruc	<05,13,West>	;#
	fixstruc	<10,13,West>	;$


;Fix Table 6
	fixstruc	<00,06,South>	;0
	fixstruc	<00,11,South>	;1
	fixstruc	<00,16,South>	;2
	fixstruc	<05,24,West>	;3
	fixstruc	<10,24,West>	;4
	fixstruc	<15,16,North>	;5
	fixstruc	<15,11,North>	;6
	fixstruc	<15,06,North>	;7
	fixstruc	<10,00,East>	;8
	fixstruc	<05,00,East>	;9
	fixstruc	<07,06,South>	;*#
	fixstruc	<05,11,East>	;*$
	fixstruc	<11,06,North>	;#
	fixstruc	<05,16,West>	;$


;Fix Table 7
	fixstruc	<00,00,SouthEast>	;0
	fixstruc	<00,08,South>	;1
	fixstruc	<00,14,South>	;2
	fixstruc	<02,24,West>	;3
	fixstruc	<08,24,West>	;4
	fixstruc	<15,20,North>	;5
	fixstruc	<15,14,North>	;6
	fixstruc	<15,05,North>	;7
	fixstruc	<11,00,East>	;8
	fixstruc	<05,00,East>	;9
	fixstruc	<11,18,NorthWest>	;*#
	fixstruc	<09,04,NorthEast>	;*$
	fixstruc	<07,14,SouthEast>	;#
	fixstruc	<05,08,SouthWest>	;$


;Fix Table 8
	fixstruc	<00,03,South>	;0
	fixstruc	<00,09,South>	;1
	fixstruc	<00,16,South>	;2
	fixstruc	<04,24,West>	;3
	fixstruc	<09,24,West>	;4
	fixstruc	<15,24,NorthWest>	;5
	fixstruc	<15,14,North>	;6
	fixstruc	<15,03,North>	;7
	fixstruc	<10,00,East>	;8
	fixstruc	<03,00,East>	;9
	fixstruc	<04,15,West>	;*#
	fixstruc	<09,12,SouthWest>	;*$
	fixstruc	<04,10,East>	;#
	fixstruc	<13,08,NorthEast>	;$


;Fix Table 9
	fixstruc	<00,00,SouthEast>	;0
	fixstruc	<00,08,South>	;1
	fixstruc	<00,16,South>	;2
	fixstruc	<05,24,West>	;3
	fixstruc	<11,24,West>	;4
	fixstruc	<15,18,North>	;5
	fixstruc	<15,08,North>	;6
	fixstruc	<15,02,North>	;7
	fixstruc	<11,00,East>	;8
	fixstruc	<06,00,East>	;9
	fixstruc	<06,08,East>	;*#
	fixstruc	<09,13,South>	;*$
	fixstruc	<06,12,West>	;#
	fixstruc	<13,13,North>	;$

	.code
;
; get the position of a fix
;
; input:
;   al = fix
;
; returns:
;   ax = position
;   bx = pointer to fix data
;
fixpos	PROC
	mul	[three]
	mov	bx,[fixptr]
	add	bx,ax
	mov	ax,[bx]
	ret
fixpos	ENDP
;
; see if this position is a fix
;
; input:
;   ax = position
;
; output:
;   CY set:  not a fix
;   CY clr:  ax = fix number
findfix	PROC
	push	cx
	push	di
	mov	cx,14       	; fourteen fixes
	mov	di,[fixptr]	; get fixes in use
ffl:
	scasw			; match this one
	jz	gotfix
	inc	di		; skip heading
	loop	ffl
	pop	di
	pop	cx
	stc
	ret
gotfix:
	mov	ax,14		; got a fix, find its number
	sub	ax,cx
	pop	di
	pop	cx
	ret
findfix	ENDP

;
; randomly discover a fix table to use
;
initfix	PROC
	mov	ax,10		; 10 tables
	call	rand
	mul	[fixsize]	; multiply by table size
	add	ax,offset fixbase ; add in pointer to base
	mov	[fixptr],ax	; set the in-use pointer
	ret
initfix	ENDP
	end