;
; commands.asm
;
; this parses user input related to the game and sets things up
; for processing by the planes module.  The initial time is entered
; in title.asm
;
ifdef SMALL
	.model small
else
	.model tiny
endif

include atc.asi
include atc.mac
include input.ase
include draw.ase
include error.ase
include fix.ase
include planes.ase
include io.ase

	public parsecommand, initparse
;
; command examples
;
; $ = plane name
; # = digit 0-9
; ^ = digit 0-4
; % = airport
;
; $A#	- set altitude
; $L^	- set left turn
; $R^	- set right turn
; $C%	- clear to land
; $H    - change heading
; $*	- circle navaid
; $S    - show status
;
	.data
planesize db	size planes	; size of planes struc
;
; clockwise flags for circling.  Byte offset is the octant, bit offset
; is the heading.  If a bit is set it means clockwise (turn to right)
;
;    \4:0/
;    5\:/1
;    --:--
;    7/:\3
;    /6:2\
;
; octant byte offset:
;    bit 0 = set if |x| > |y|
;    bit 1 = set if y < 0
;    bit 2 = set if x < 0
;
circtab	db	00011110b	; upper right upper
	db	00111100b	; upper right lower
	db	11110000b	; lower right lower
	db	01111000b	; lower right upper
	db	00001111b	; upper left upper
	db	10000111b	; upper left lower
	db	11100001b	; lower left lower
	db	11000011b	; lower left upper

	.code
;
; init for parsing
;
initparse PROC
	loadcoord	INPUT_ROW,INPUT_COL
	mov	bl,3
	call	setinput
	ret
initparse ENDP
;
; parse a command
;
parsecommand PROC
	call	getinput	; get input
	jc	pcx
	jz	gotcommand	; interpret if ret key
	clc
pcx:
	ret			; else exit
gotcommand:
	mov	ax,word ptr [inbuf]	; get command chars
	mov	bl,[inbuf+2]
	cmp	al,' '			; is first char ' '
	jnz	noshift	
	mov	al,ah   		; yes, shift over one
	mov	ah,bl	
	mov	bl,0
noshift:
	cmp	al,'a'			; is airplane lc
	jc	noadj
	sub	al,' '			; yes, make uc
noadj:
	sub	al,'A'			; make it a number
	jc	pcerr
	cmp	al,26
	jae	pcerr
	cmp	ah,'a'			; is command uc?
	jc	noadj2
	sub	ah,' '			; no make uc
noadj2:
	call	docommand               ; do the command
	jc	pcerr			; get out if err
	call	draw_msg
	db	ERROR_ROW, ERROR_COL,"ROGER",0
pcerr:
	call	initparse
	clc
	ret
parsecommand ENDP
;
; do a command
;
; input:
;   al = airplane
;   ah = command
;   bl = argument if any
;
; returns
;   CY set if error
;
docommand PROC
	xchg	ah,bh			;isolate plane name
	mul	[planesize]		; calculate plane pointer
	xchg	ax,bx
	lea	si,[bx + PLANESTRUCS]
	test	[si].flags,F_ONSCREEN ; see if visible
	jnz	ison
	call	draw_msg		; no, draw error
	db	ERROR_ROW, ERROR_COL,"Inactive plane",0
	stc
	ret
ison:
	cmp	ah,'A'			; alt command?
	jnz	notalt
	call	getdig			; yes, need alt
	jc	what1
	mov	[si].alt,al	; set it
	call	draw_plane
	call	check_conflict		; and go check for conflicts
	clc
	ret
notalt:
	cmp	ah,'L'			; left command?
	jnz	notleft
	call	getdig			; yes get digit 0-4
	jc	what1
	cmp	al,5
	jnc	what1
	mov	[si].rotate,al	; replace rotate
	and	[si].flags,NOT (F_RIGHT  + F_CIRCLE1 + F_CIRCLE2 + F_CHGHEAD + F_CTL); set left
	ret
what1:	jmp	what
notleft:
	cmp	ah,'R'			; right command?
	jnz	notright
	call	getdig  		; yes get digit 0-4
	jc	what1
	cmp	al,5
	jnc	what1
	mov	[si].rotate,al	; replace rotate
	or	[si].flags,F_RIGHT	; set right
	and	[si].flags,NOT (F_CIRCLE1 + F_CIRCLE2 + F_CHGHEAD + F_CTL)
	ret

notright:
	cmp	ah,'*'			; circle command?
	jnz	notcircle
	and	[si].flags,NOT (F_RIGHT + F_CHGHEAD + F_CTL); assume counter-clockwise
	add	si,planes.row		; point at row
	mov	al,10			; get pos of first fix
	call	fixpos
	mov	di,bx
	call	dist			; dist to first fix
	mov	cl,al
	mov	al,11              	; pos of second fix
	call	fixpos
	mov	di,bx	
	call	dist    		; dist to second fix
	sub	si,planes.row       	; back to plane
	cmp	al,cl			; which fix is it?
	mov	bl,F_CIRCLE1		; assume first
	mov	al,10
	jnc	usefirst
	xchg	al,cl			; nope, second
	mov	bl,F_CIRCLE2
	mov	al,11
usefirst:
	mov	[si].cirdist,cl		; set circle distance
	or	[si].flags,bl 		; set circle flag
	call	fixpos
;    bit 0 = set if x > y
;    bit 1 = set if y < 0
;    bit 2 = set if x < 0
	sub	al,[si].row		; get quadrant
	sub	ah,[si].col
	neg	ah   			; proper sign on col (row has proper sign)
	mov	dx,ax
	rol	ah,1				; roll sign bits
	rcl	al,1				; into lower part of al
	rcl	ah,1
	and	ah,3				; now ah = quadrant
	mov	bl,ah
	sub	bh,bh
	cmp	dl,dh				; flags from x-y
	jno	notmixed				;
	rcl	bl,1                            ; mixed signs, rol in sign of row
	jmp	join
notmixed:
     	rcl	bl,1				; unmixed signs, bit = x > y
	test	dl,80h				; if sign < 0 flip it
	jns	join
	xor	bl,1
join:
	mov	cl,[si].head		; get heading
	mov	al,1
	shl	al,cl
	test	[circtab +bx],al		; test against octant flags
	jz	ncleft
	or	[si].flags, F_RIGHT	; flag set, circling clockwise
ncleft:
	mov	[si].rotate,0
	clc
	ret

notcircle:
	cmp	ah,'S'			; status command
	jnz	notstatus
	loadcoord ERROR_ROW,ERROR_COL	; set up for status
	mov	bl,1			; yes, need command info
	call	draw_plane_info
	mov	[errtime],5		; clear it after a bit
	stc				; no roger message
	ret

notstatus:
	cmp	ah,'C'			; clear to land?
	jnz	heading
	or	[si].flags, F_CTL ; yep, set it up
	ret
heading:
	cmp	ah,'H'			; change heading at navaid?
	jnz	what
	or	[si].flags,F_CHGHEAD	; yep, set it up
	ret
what:
	call	draw_msg
	db	ERROR_ROW, ERROR_COL,"What?",0
	stc
	ret
docommand ENDP
	end