;
; io.asm
;
; this is fundamental I/O routines
;
; setting screen pos, drawing characters/strings
; getting keys, clearing portions of the screen
; and displaying two-digit decimal numbers
; 
ifdef SMALL
	.model small
else
	.model tiny
endif

	public	initscr,putch,setpos,color,getkey,scankey,clrblock
	public msgout,putstr, numout

include atc.asi
include atc.mac

	.data
color	db	CO_NORM	; current draw color
pos	dw	?	; draw position
onesixty db	160	; ;emgtj of a row in bytes
screen	dw	0b800h	; screen address, vga mode 3
ten	db	10

	.code
;
; subroutine to make sure we are in text mode
;
; the rules say we have a VGA card!
;
initscr PROC
	mov	ax,3	; text mode init via bios
	int 	10h
	mov	ah,2	; move cursor off screen
	sub	bh,bh
	mov	dx,01a00h
;	int	10h
	ret
initscr	ENDP
;
; set the current screen position
;
; in:
;   al = row
;   ah = col
;
setpos	PROC
	push	dx
	push	ax
	mul	[onesixty]	; find byte position of row
	mov	dx,ax
	pop	ax
	xchg	al,ah		; add in col * 2
	sub	ah,ah
	add	ax,ax
	add	ax,dx
	mov	[pos],ax	; save resulting position
	pop	dx
	ret
setpos	ENDP

;
; routine puts a character and increments the screen pos
;
; input:
;   al = character
;   color and position set up
;
putch	PROC
	push	es
	push	di
	mov	es,[screen]	; screen seg
	mov	ah,[color]	; color
	mov	di,[pos]	; position
	stosw			; draw char
	mov	[pos],di	; save incremented pos
	pop	di
	pop	es
	ret
putch	ENDP
;
; clear a block of the screen
;
; in:
;   ax = position (al = row)
;   cx = rows
;   dx = cols
;
clrblock PROC
	push	[pos]		; want to save position
	call	setpos		;
	xchg	dx,cx		; reorganize rows & cols
csl2:
	push	[pos]		; push current row,col
	push	cx		; push columns
csl:
	mov	al,' '		; loop to blank the column
	call	putch
	loop	csl
	pop	cx   		; restore col len
	pop	[pos]		; restore row & col
	add	[pos],160	; bump to next row
	dec	dx		; decrememt row count
	jnz	csl2
	pop	[pos]
	ret
clrblock ENDP
;
; unconditional getkey
;
; returns al = key
;
getkey PROC
	sub	ax,ax
	int	16h
	ret
getkey ENDP
;
; conditional get key:
;
; returns:
;    ZF set: no key
;    ZF ckr: key in al
;
scankey	PROC
	mov	ah,1
	int	16h
	jz	nokey
	pushf
	call	getkey
	popf
nokey:
	ret
scankey	ENDP
;
; blit a string to the screen
;
; input:
;   si = pointer to null terminated string
;
putstr	PROC
	lods	byte ptr cs:[si]	; get char
	or	al,al
	jz	psx	; get out if nuoo
	call	putch	; else put char
	jmp	putstr	; and loop
psx:
	ret
putstr	ENDP
;
; blit a string that has been inlined in the code segment
;
; input:
;   return address points to string
;
; output:
;   return address updated past string
;
msgout	PROC
	push	bp	; stack frame
	mov	bp,sp
	xchg	si,[bp+2] ; si = pointer and save old si
	lods	word ptr cs:[si]	; grab the position
	or	ax,ax
	js	noset	; if negative use current pos
	call	setpos	; set the position
noset:
mol:
	lods	byte ptr cs:[si]	; get char
	or	al,al
	jz	psx2	; get out if nuoo
	call	putch	; else put char
	jmp	mol	; and loop
psx2:
	xchg	si,[bp+2] ; update return pointer
	pop	bp
	ret
msgout	ENDP

;
; display a byte value in base 10
;
; input:
;   al = number
numout	PROC
	sub	ah,ah
	div	[ten]			; get digits
	add	ax,'00'
	mov	dl,ah
	call	putch
	xchg	al,dl			; put second dig
	call	putch
	ret
numout	ENDP
	end