;
; error.asm
;
; this module prints up messages and errors.  It is also responsible
; for the five-second delay used to erase the ROGER and related
; messages from the screen
;
ifdef SMALL
	.model small
else
	.model tiny
endif

include atc.asi
include atc.mac
include draw.ase
include io.ase
include atc.ase
include planes.ase

	public draw_error,clear_msg, draw_msg, errtime

	.data
errtime	db	0

	.code
;
; clear the 'roger' message
;
clear_msg PROC
	test	[errtime],-1		; is it up?
	jz	noerr			; no, out
	dec	[errtime]		; dec time
	jnz	noerr			; get out if time not up
	loadcoord ERROR_ROW,ERROR_COL	; set up for spaceover
	call	setpos
	setcolor CO_MESSAGE
	mov	cx,ERROR_LEN		; number of spaces
cel:
	mov	al,' '			; put them out
	call	putch
	loop	cel
noerr:
	ret
clear_msg ENDP
;
; draw a message (e.g. roger)
;
; input:
;   si = pointer to message
;
draw_msg PROC
	setcolor CO_MESSAGE
	mov	[errtime],5
	jmp	msgout
draw_msg ENDP
;
; draw one of the errors
;
; input:
;   stack = pointer to message
;   al = first plane (or 0)
;   ah = second plane (or 0)
;
draw_error PROC
	pop	si			; get message pos
	push	ax			; push planes
	setcolor CO_ERR			; set color
	loadcoord ERROR_ROW,ERROR_COL	; set row and column
	call	setpos
	call	putstr			; print error message
	pop	ax
	or	al,al			; see if any planes
	jz	noplanes		; no draw none
	push	ax			; draw the first plane
	call	putch			
	pop	ax
	xchg	al,ah  			; second plane
	or	al,al
	jz	noplanes		; get out if none
	push	ax			; display joint
	Msg	" and "
	pop	ax
	call	putch			; and second plane
noplanes:
	loadcoord PLANECOUNT_ROW, PLANECOUNT_COL ; display number of planes
	call	setpos
	call	countplanes
	call	numout
	Msg	" planes left."
	Pmsg	PRESS_ROW, PRESS_COL, "<Press any key>" ; wait for a key
	call	getkey
	jmp	exit			; get out of program
	
draw_error ENDP
	end