;
; draw.asm
;
; this file does most of the graphics formatting.
;
; It draws planes, backgrounds, fixes, airport and plane info
; and also the remaining time
;
ifdef SMALL
	.model small
else
	.model tiny
endif

	public draw_bg,draw_full_bg,draw_plane,draw_plane_info
	public erase_info_region,draw_airport_info, draw_time
include atc.asi
include atc.mac
include io.ase
include fix.ase

	.data
fixes	db	"0123456789**#$"	; names of fixes
heads	db	"N NEE SES SWW NW"	; names of headings
sixty	dw	60	;constant 60
	.code
;
;utility routines
;
putdig	PROC
	add	al,'0'
	jmp	putch
putdig	ENDP
putdash PROC
	mov	al,'-'
	jmp	putch
putdash	endp
putspace PROC
	mov	al,' '
	jmp	putch
putspace ENDP
putfix	PROC
	setcolor CO_FIX
putfix 	ENDP
putfix2 PROC
	mov	bx,offset fixes
	xlat
	JMP	putch
putfix2	ENDP
;
; put a heading
;
; input:
;   al = heading
;
puthead	PROC
	sub	ah,ah	; two chars per heading
	shl	al,1
	mov	bx,ax	; get the chars into bx
	mov	bx,word ptr [bx + heads]
	mov	al,bl	; put them out
	call	putch
	mov	al,bh
	call	putch
	ret
puthead	ENDP
;
; draw a point on the playing field (erase current plane)
;
draw_bg	PROC
	mov	ax,word ptr [si].row	; get pos
draw_bg ENDP
draw_bg2 PROC
	push	ax
	shl	ah,1	; two characters per position
	call	setpos	; set position
	setcolor CO_RADAR 	; set color
	pop	ax
	push	bx
	push	cx
	mov	bx,PLANESTRUCS	; scan planes list
	mov	cx,26
bgpl:
	test	[bx].flags,F_ONSCREEN	; plane onscreen
	jz	bgnp
	cmp	ax,word ptr [bx].row	; yes, is plane here
	jnz	bgnp
	cmp	bx,si			; yes, is it current plane
	jnz	drawplane		; no, draw it
bgnp:
	add	bx,size planes		; loop
	loop	bgpl
	pop	cx
	pop	bx
	call	findfix	; else see if it is a fix
	jnc	drawfix	; yes, draw it
	mov	al,'.'	; else draw a dot and space
	call	putch
	jmp	putspace
drawfix:
	call	putfix2  ; draw the fix and a space
	jmp	putspace
drawplane:
	xchg	si,bx	; si = new plane ptr
	call	draw_plane	; draw it
	xchg	si,bx		; restore regs
	pop	cx
	pop	bx
	ret
draw_bg2	ENDP

;
; draw the full playing field
;
draw_full_bg	PROC
	sub	cx,cx	; rows
dbgl2:
	sub	dx,dx	; cols
dbgl1:
	mov	al,cl	; get screen pos
	mov	ah,dl
	call	draw_bg2	; draw it
	inc	dx	; next column
	cmp	dl,COLS
	jnz	dbgl1
	inc	cx	; next row
	cmp	cl,ROWS
	jnz	dbgl2
	ret
draw_full_bg	ENDP

;
; draw a plane
;
; input:
;  si points to plane struct
;
draw_plane PROC
	setcolor CO_PLANE
	mov	ax,word ptr [si].row	; get pos
	shl	ah,1   			; two chars/point
	call	setpos
	mov	al,[si].pname	; draw name
	call	putch
	mov	al,[si].alt	; draw altitude
	jmp	putdig
draw_plane ENDP

;
; draw the plane information
;
; input:
;   si points to plane struct
;   bl is nonzero if we want the optional command
;   ax = position
;
;AJ9-HD-0$(-R3CH)-F

draw_plane_info PROC
	push	bx				; save command flag
	call	setpos				; set pos and color
	setcolor CO_PLANEINFO

	mov	al, [si].pname		; display name
	call	putch

	mov	al,'J'				; display jet/prop flag
	test	[si].flags,F_JET
	jnz	pjet
	mov	al,'P'

pjet:
	call	putch

	mov	al,[si].alt		; display altitude
	call	putdig

	call	putdash				; display heading
	mov	al,[si].head
	call	puthead

	call	putdash				; display source and dest
	mov	al,[si].src
	call	putfix2
	mov	al,[si].dest
	call	putfix2

	pop	ax				; get command flag
	or	al,al
	jz	nocommand			; branch if no command
	test	[si].flags ,F_CIRCLE1 OR F_CIRCLE2 ; if circling do rot
	jnz	dorot
	call	putdash				; any rotate?
	test	[si].rotate,7
	jz	norot
dorot:
	test	[si].flags,F_RIGHT	; yes, put L or R
	mov	al,'R'
	jnz	putright
	mov	al,'L'
putright:
	call	putch
	test	[si].flags ,F_CIRCLE1 OR F_CIRCLE2 ; if circling no val
	jnz	norotval
	mov	al,[si].rotate	; put rotate
	call	putdig
	jmp	cdo
norot:
	call	putdash				; no rotate, dash over it
norotval:
	call	putdash
cdo: 
	mov	al,'*'     			; assume circle
	test	[si].flags,F_CIRCLE1 OR F_CIRCLE2 ; check for it
	jnz	docirc
	mov	al,'-'				; nope, dash
docirc:
	call	putch

	mov	al,'H'				; assume heading change
	test	[si].flags,F_CHGHEAD
	jnz	dohead
	mov	al,'-'				; nope, dash
dohead:
	call	putch
	mov	al,'C'				; assume clear to land
	test	[si].flags,F_CTL		; is it?
	jnz 	doctl
	mov	al,'-'				; no put dash
doctl:
	call	putch
nocommand:
	call	putdash				; put fuel
	mov	al,[si].fuel
	cmp	al,10
	jc	dofuel
	mov	al,'+'				; fuel too big, put +
	call	putch
	jmp	nofuel
dofuel:
	call	putdig				; else fuel
nofuel:
	ret
draw_plane_info ENDP

;
; erasee theplane entry info area
;
erase_info_region PROC
	setcolor CO_PLANEINFO
	mov	al,0
	mov	ah,COLS*2
	mov	cx,ROWS
	mov	dx,80-COLS*2
	jmp	clrblock
erase_info_region ENDP

;
; draw the airport info
;
; input:
;  ax = cursor pos
; 
draw_airport_info PROC
	setcolor CO_PLANEINFO
	push	si
	push	bx
	push	ax
	mov	si,[fixptr]		; point at first airport
	lea	si,[si + size fixstruc *12]
	mov	bl,[fixes+12]		; get name
	mov	bh,[si].fhead ; and take-off heading
	call	oneair			; put it
	pop	ax
	inc	al			; next row
	mov	bl,[fixes+13]		; name of second airport
	mov	bh,[si+size fixstruc].fhead ; heading
	call	oneair			; draw it
	pop	bx
	pop	si
	ret
;
; sub-rpocedure draws a single airport info
;
; input:
;   ax = cursor pos
;   bl = name
;   bh = take-off heading
;
oneair	PROC
	call	setpos		; set pos
	mov	al,bl		; put the airport name
	call	putch
	call	putspace	; and some pretty stuff
	call	putdash
	call	putspace
	mov	al,bh		; get takeoff heading
	xor	al,4		; but display langind heading
	call	puthead		; draw it
	ret
oneair	ENDP
draw_airport_info ENDP
;
; draw value of time to screen
;
; input:
;   ax = time
;
draw_time	PROC
	setcolor CO_TIME
	push	ax			; save time
	mov	ax,TIME_ROW + (TIME_COL SHL 8) ; set pos
	call	setpos
	pop	ax
	call	numout
	ret
draw_time	ENDP
	end