
;
; atc.asm
;
; atc main module
;
; this sets up the game environment and holds the main loop
;
ifdef SMALL
	.model small
else
	.model tiny
endif

	public exit
include atc.asi
include atc.mac
include io.ase
include draw.ase
include fix.ase
include planes.ase
include title.ase
include commands.ase
include rand.ase
include error.ase

ifdef SMALL
	.stack
endif

	.code
ifndef small
	org 100h
endif
start:
ifdef SMALL
	mov ax,dgroup
	mov ds,ax
	mov es,ax
endif
;
; initialize
;
	call	srand
	call	initscr
;
; select a fix table and draw BG
;
	call	initfix
	call	clearplane
	call	draw_full_bg
;
; draw the airport headings
;
	loadcoord 10,60
	call	draw_airport_info
;
; dotitle and help
;
	call	dotitle
	jc	exit

;
; erase the airport headings
;
	call	erase_info_region
;
; gen the planes table
;
	call	initplanes
;
; init for command parsing
;
	call	initparse
;
; main loop
;
main:
	call	parsecommand
	jc	exit
	call	movecheck
	jc	main
	call	clear_msg
	call	moveplanes
	jnc	main
	call	getkey
exit:
;
; clear screen and exit
;
	mov	ax,3
	int	10h
	mov	ah,4ch
	int	21h
	end	start